/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaWildcardType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectJavaWildcardType
extends ReflectJavaType
implements JavaWildcardType {
    @NotNull
    private final WildcardType reflectType;
    @NotNull
    private final Collection<JavaAnnotation> annotations;
    private final boolean isDeprecatedInJavaDoc;

    public ReflectJavaWildcardType(@NotNull WildcardType reflectType) {
        Intrinsics.checkNotNullParameter((Object)reflectType, (String)"reflectType");
        this.reflectType = reflectType;
        this.annotations = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    protected WildcardType getReflectType() {
        return this.reflectType;
    }

    @Override
    @Nullable
    public ReflectJavaType getBound() {
        ReflectJavaType reflectJavaType;
        Object[] upperBounds2 = this.getReflectType().getUpperBounds();
        Object[] lowerBounds = this.getReflectType().getLowerBounds();
        if (upperBounds2.length > 1 || lowerBounds.length > 1) {
            throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Wildcard types with many bounds are not yet supported: ", (Object)this.getReflectType()));
        }
        if (lowerBounds.length == 1) {
            Intrinsics.checkNotNullExpressionValue((Object)lowerBounds, (String)"lowerBounds");
            Object object = ArraysKt.single((Object[])lowerBounds);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lowerBounds.single()");
            reflectJavaType = ReflectJavaType.Factory.create((Type)object);
        } else if (upperBounds2.length == 1) {
            Intrinsics.checkNotNullExpressionValue((Object)upperBounds2, (String)"upperBounds");
            Object object = ArraysKt.single((Object[])upperBounds2);
            Type ub = (Type)object;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)ub, Object.class)) {
                Intrinsics.checkNotNullExpressionValue((Object)ub, (String)"ub");
                reflectJavaType = ReflectJavaType.Factory.create(ub);
            } else {
                reflectJavaType = null;
            }
        } else {
            reflectJavaType = null;
        }
        return reflectJavaType;
    }

    @Override
    public boolean isExtends() {
        Type[] typeArray = this.getReflectType().getUpperBounds();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"reflectType.upperBounds");
        return !Intrinsics.areEqual((Object)ArraysKt.firstOrNull((Object[])typeArray), Object.class);
    }

    @Override
    @NotNull
    public Collection<JavaAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return this.isDeprecatedInJavaDoc;
    }
}

