/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter;

import java.io.Serializable;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.build.GradleEnvironment;
import org.gradle.tooling.model.build.JavaEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalBuildIdentifier;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalGradleEnvironment;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalJavaEnvironment;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.Supplier;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.Suppliers;

@ApiStatus.Internal
public final class InternalBuildEnvironment
implements BuildEnvironment,
Serializable {
    private final Supplier<InternalBuildIdentifier> buildIdentifier;
    private final Supplier<InternalGradleEnvironment> gradle;
    private final Supplier<InternalJavaEnvironment> java;

    public InternalBuildEnvironment(@NotNull Supplier<InternalBuildIdentifier> buildIdentifier, @NotNull Supplier<InternalGradleEnvironment> gradle, @NotNull Supplier<InternalJavaEnvironment> java) {
        if (buildIdentifier == null) {
            InternalBuildEnvironment.$$$reportNull$$$0(0);
        }
        if (gradle == null) {
            InternalBuildEnvironment.$$$reportNull$$$0(1);
        }
        if (java == null) {
            InternalBuildEnvironment.$$$reportNull$$$0(2);
        }
        this.buildIdentifier = Suppliers.wrap(buildIdentifier);
        this.gradle = Suppliers.wrap(gradle);
        this.java = Suppliers.wrap(java);
    }

    public InternalBuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier.get();
    }

    public GradleEnvironment getGradle() {
        return this.gradle.get();
    }

    public JavaEnvironment getJava() {
        return this.java.get();
    }

    @Contract(value="null -> null")
    public static BuildEnvironment convertBuildEnvironment(@Nullable BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null || buildEnvironment instanceof InternalBuildEnvironment) {
            return buildEnvironment;
        }
        return new InternalBuildEnvironment(() -> {
            BuildIdentifier buildIdentifier = buildEnvironment.getBuildIdentifier();
            return new InternalBuildIdentifier(buildIdentifier.getRootDir());
        }, () -> {
            GradleEnvironment gradle = buildEnvironment.getGradle();
            return new InternalGradleEnvironment(gradle.getGradleUserHome(), gradle.getGradleVersion());
        }, () -> {
            JavaEnvironment java = buildEnvironment.getJava();
            return new InternalJavaEnvironment(java.getJavaHome(), java.getJvmArguments());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "buildIdentifier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "gradle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "java";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/tooling/serialization/internal/adapter/InternalBuildEnvironment";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

