/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdwp;

import java.io.IOException;

public class Packet {
    public static final short NoFlags = 0;
    public static final short Reply = 128;
    public static final short ReplyNoError = 0;
    static int uID = 1;
    static final byte[] nullData = new byte[0];
    int id = Packet.uniqID();
    short flags = (short)128;
    short cmdSet;
    short cmd;
    short errorCode;
    byte[] data = nullData;
    volatile boolean replied = false;

    public byte[] toByteArray() {
        int len = this.data.length + 11;
        byte[] b = new byte[len];
        b[0] = (byte)(len >>> 24 & 0xFF);
        b[1] = (byte)(len >>> 16 & 0xFF);
        b[2] = (byte)(len >>> 8 & 0xFF);
        b[3] = (byte)(len >>> 0 & 0xFF);
        b[4] = (byte)(this.id >>> 24 & 0xFF);
        b[5] = (byte)(this.id >>> 16 & 0xFF);
        b[6] = (byte)(this.id >>> 8 & 0xFF);
        b[7] = (byte)(this.id >>> 0 & 0xFF);
        b[8] = (byte)this.flags;
        if ((this.flags & 0x80) == 0) {
            b[9] = (byte)this.cmdSet;
            b[10] = (byte)this.cmd;
        } else {
            b[9] = (byte)(this.errorCode >>> 8 & 0xFF);
            b[10] = (byte)(this.errorCode >>> 0 & 0xFF);
        }
        if (this.data.length > 0) {
            System.arraycopy(this.data, 0, b, 11, this.data.length);
        }
        return b;
    }

    public static Packet fromByteArray(byte[] b) throws IOException {
        if (b.length < 11) {
            throw new IOException("packet is insufficient size");
        }
        int b0 = b[0] & 0xFF;
        int b1 = b[1] & 0xFF;
        int b2 = b[2] & 0xFF;
        int b3 = b[3] & 0xFF;
        int len = b0 << 24 | b1 << 16 | b2 << 8 | b3 << 0;
        if (len != b.length) {
            throw new IOException("length size mis-match");
        }
        int b4 = b[4] & 0xFF;
        int b5 = b[5] & 0xFF;
        int b6 = b[6] & 0xFF;
        int b7 = b[7] & 0xFF;
        Packet p = new Packet();
        p.id = b4 << 24 | b5 << 16 | b6 << 8 | b7 << 0;
        p.flags = (short)(b[8] & 0xFF);
        if ((p.flags & 0x80) == 0) {
            p.cmdSet = (short)(b[9] & 0xFF);
            p.cmd = (short)(b[10] & 0xFF);
        } else {
            short b9 = (short)(b[9] & 0xFF);
            short b10 = (short)(b[10] & 0xFF);
            p.errorCode = (short)((b9 << 8) + (b10 << 0));
        }
        p.data = new byte[b.length - 11];
        System.arraycopy(b, 11, p.data, 0, p.data.length);
        return p;
    }

    Packet() {
    }

    private static synchronized int uniqID() {
        return uID++;
    }
}

