/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.JvmPackagePartProto;
import org.jetbrains.kotlin.modules.TargetId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0018\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/daemon/RemoteIncrementalCacheClient;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "target", "Lorg/jetbrains/kotlin/modules/TargetId;", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "<init>", "(Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;Lorg/jetbrains/kotlin/modules/TargetId;Lorg/jetbrains/kotlin/daemon/common/Profiler;)V", "getFacade", "()Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "getTarget", "()Lorg/jetbrains/kotlin/modules/TargetId;", "getProfiler", "()Lorg/jetbrains/kotlin/daemon/common/Profiler;", "getObsoletePackageParts", "", "", "getObsoleteMultifileClasses", "getStableMultifileFacadeParts", "facadeInternalName", "getPackagePartData", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/JvmPackagePartProto;", "partInternalName", "getModuleMappingData", "", "getClassFilePath", "internalClassName", "close", "", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nRemoteIncrementalCacheClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteIncrementalCacheClient.kt\norg/jetbrains/kotlin/daemon/RemoteIncrementalCacheClient\n+ 2 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n*L\n1#1,45:1\n44#2,4:46\n44#2,4:50\n44#2,4:54\n44#2,4:58\n44#2,4:62\n44#2,4:66\n44#2,4:70\n*S KotlinDebug\n*F\n+ 1 RemoteIncrementalCacheClient.kt\norg/jetbrains/kotlin/daemon/RemoteIncrementalCacheClient\n*L\n31#1:46,4\n33#1:50,4\n35#1:54,4\n37#1:58,4\n39#1:62,4\n41#1:66,4\n43#1:70,4\n*E\n"})
public final class RemoteIncrementalCacheClient
implements IncrementalCache {
    @NotNull
    private final CompilerCallbackServicesFacade facade;
    @NotNull
    private final TargetId target;
    @NotNull
    private final Profiler profiler;

    public RemoteIncrementalCacheClient(@NotNull CompilerCallbackServicesFacade facade, @NotNull TargetId target, @NotNull Profiler profiler) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        this.facade = facade;
        this.target = target;
        this.profiler = profiler;
    }

    public /* synthetic */ RemoteIncrementalCacheClient(CompilerCallbackServicesFacade compilerCallbackServicesFacade, TargetId targetId, Profiler profiler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            profiler = new DummyProfiler();
        }
        this(compilerCallbackServicesFacade, targetId, profiler);
    }

    @NotNull
    public final CompilerCallbackServicesFacade getFacade() {
        return this.facade;
    }

    @NotNull
    public final TargetId getTarget() {
        return this.target;
    }

    @NotNull
    public final Profiler getProfiler() {
        return this.profiler;
    }

    @NotNull
    public Collection<String> getObsoletePackageParts() {
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        Collection<String> res$iv = this.facade.incrementalCache_getObsoletePackageParts(this.target);
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    @NotNull
    public Collection<String> getObsoleteMultifileClasses() {
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        Collection<String> res$iv = this.facade.incrementalCache_getObsoleteMultifileClassFacades(this.target);
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    @Nullable
    public Collection<String> getStableMultifileFacadeParts(@NotNull String facadeInternalName) {
        Intrinsics.checkNotNullParameter((Object)facadeInternalName, (String)"facadeInternalName");
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        Collection<String> res$iv = this.facade.incrementalCache_getMultifileFacadeParts(this.target, facadeInternalName);
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    @Nullable
    public JvmPackagePartProto getPackagePartData(@NotNull String partInternalName) {
        Intrinsics.checkNotNullParameter((Object)partInternalName, (String)"partInternalName");
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        JvmPackagePartProto res$iv = this.facade.incrementalCache_getPackagePartData(this.target, partInternalName);
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    @Nullable
    public byte[] getModuleMappingData() {
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        byte[] res$iv = this.facade.incrementalCache_getModuleMappingData(this.target);
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    @NotNull
    public String getClassFilePath(@NotNull String internalClassName) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        String res$iv = this.facade.incrementalCache_getClassFilePath(this.target, internalClassName);
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    public void close() {
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        this.facade.incrementalCache_close(this.target);
        Unit res$iv = Unit.INSTANCE;
        $this$withMeasure$iv.endMeasure(this, startState$iv);
    }
}

