/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.configuration.HeadlessLogging;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.util.ApplicationKt;
import com.intellij.util.CoroutinesKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.notification.ExternalAnnotationsProgressNotificationListener;
import org.jetbrains.plugins.gradle.service.notification.ExternalAnnotationsProgressNotificationManager;
import org.jetbrains.plugins.gradle.service.notification.ExternalAnnotationsTaskId;
import org.jetbrains.plugins.gradle.service.project.GradleHeadlessLoggingProjectActivityKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003\u0012\u0013\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/GradleHeadlessLoggingProjectActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addTaskNotificationListener", "progressManager", "Lcom/intellij/openapi/externalSystem/service/notification/ExternalSystemProgressNotificationManager;", "addStateNotificationListener", "addAnnotationListener", "StateExternalAnnotationNotificationListener", "StateNotificationListener", "LoggingNotificationListener", "intellij.gradle"})
public final class GradleHeadlessLoggingProjectActivity
implements ProjectActivity {
    @NotNull
    private final CoroutineScope scope;

    public GradleHeadlessLoggingProjectActivity(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (!ApplicationKt.getApplication().isHeadlessEnvironment() || ApplicationKt.getApplication().isUnitTestMode()) {
            return Unit.INSTANCE;
        }
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        Intrinsics.checkNotNull((Object)progressManager);
        this.addTaskNotificationListener(progressManager);
        this.addStateNotificationListener(project, progressManager);
        this.addAnnotationListener();
        return Unit.INSTANCE;
    }

    private final void addTaskNotificationListener(ExternalSystemProgressNotificationManager progressManager) {
        LoggingNotificationListener listener2 = new LoggingNotificationListener();
        progressManager.addNotificationListener((ExternalSystemTaskNotificationListener)listener2);
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)this.scope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(progressManager, listener2, null){
            int label;
            final /* synthetic */ ExternalSystemProgressNotificationManager $progressManager;
            final /* synthetic */ LoggingNotificationListener $listener;
            {
                this.$progressManager = $progressManager;
                this.$listener = $listener;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this.$listener);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final void addStateNotificationListener(Project project, ExternalSystemProgressNotificationManager progressManager) {
        StateNotificationListener notificationListener2 = new StateNotificationListener(project, this.scope);
        progressManager.addNotificationListener((ExternalSystemTaskNotificationListener)notificationListener2);
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)this.scope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(progressManager, notificationListener2, null){
            int label;
            final /* synthetic */ ExternalSystemProgressNotificationManager $progressManager;
            final /* synthetic */ StateNotificationListener $notificationListener;
            {
                this.$progressManager = $progressManager;
                this.$notificationListener = $notificationListener;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this.$notificationListener);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final void addAnnotationListener() {
        ExternalAnnotationsProgressNotificationManager externalAnnotationsNotificationManager = ExternalAnnotationsProgressNotificationManager.Companion.getInstance();
        StateExternalAnnotationNotificationListener externalAnnotationsProgressListener = new StateExternalAnnotationNotificationListener();
        externalAnnotationsNotificationManager.addNotificationListener(externalAnnotationsProgressListener);
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)this.scope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(externalAnnotationsNotificationManager, externalAnnotationsProgressListener, null){
            int label;
            final /* synthetic */ ExternalAnnotationsProgressNotificationManager $externalAnnotationsNotificationManager;
            final /* synthetic */ StateExternalAnnotationNotificationListener $externalAnnotationsProgressListener;
            {
                this.$externalAnnotationsNotificationManager = $externalAnnotationsNotificationManager;
                this.$externalAnnotationsProgressListener = $externalAnnotationsProgressListener;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$externalAnnotationsNotificationManager.removeNotificationListener(this.$externalAnnotationsProgressListener);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/GradleHeadlessLoggingProjectActivity$LoggingNotificationListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "<init>", "()V", "logPath", "Ljava/nio/file/Path;", "onTaskOutput", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "text", "", "stdOut", "", "processMessage", "gradleText", "intellij.gradle"})
    public static final class LoggingNotificationListener
    implements ExternalSystemTaskNotificationListener {
        @NotNull
        private final Path logPath;

        public LoggingNotificationListener() {
            Path path;
            LoggingNotificationListener loggingNotificationListener;
            LoggingNotificationListener loggingNotificationListener2 = this;
            try {
                loggingNotificationListener = loggingNotificationListener2;
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path2 = Files.createFile(PathKt.createParentDirectories((Path)GradleHeadlessLoggingProjectActivityKt.access$getGradleLogWriterPath$p()), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createFile(...)");
                path = path2;
            }
            catch (FileAlreadyExistsException e) {
                loggingNotificationListener = loggingNotificationListener2;
                path = GradleHeadlessLoggingProjectActivityKt.access$getGradleLogWriterPath$p();
            }
            loggingNotificationListener.logPath = path;
        }

        public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            String gradleText = (stdOut ? "" : "STDERR: ") + text;
            PathsKt.appendText$default((Path)this.logPath, (CharSequence)gradleText, null, (int)2, null);
            String croppedMessage = this.processMessage(gradleText);
            if (croppedMessage != null) {
                HeadlessLogging.INSTANCE.logMessage(GradleHeadlessLoggingProjectActivityKt.access$getGradlePrefix$p() + croppedMessage);
            }
        }

        private final String processMessage(String gradleText) {
            char[] cArray = new char[]{'\r'};
            String string = StringsKt.trimStart((String)gradleText, (char[])cArray);
            cArray = new char[]{'\n'};
            String cropped = StringsKt.trimEnd((String)string, (char[])cArray);
            if (StringsKt.startsWith$default((String)cropped, (String)"Download", (boolean)false, (int)2, null)) {
                if (StringsKt.contains$default((CharSequence)cropped, (CharSequence)" took ", (boolean)false, (int)2, null)) {
                    return cropped;
                }
                return null;
            }
            return cropped;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/GradleHeadlessLoggingProjectActivity$StateExternalAnnotationNotificationListener;", "Lorg/jetbrains/plugins/gradle/service/notification/ExternalAnnotationsProgressNotificationListener;", "<init>", "()V", "onStartResolve", "", "id", "Lorg/jetbrains/plugins/gradle/service/notification/ExternalAnnotationsTaskId;", "onFinishResolve", "intellij.gradle"})
    public static final class StateExternalAnnotationNotificationListener
    implements ExternalAnnotationsProgressNotificationListener {
        @Override
        public void onStartResolve(@NotNull ExternalAnnotationsTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            HeadlessLogging.INSTANCE.logMessage(GradleHeadlessLoggingProjectActivityKt.access$getGradlePrefix$p() + "Gradle resolving external annotations started " + id.getProjectId());
        }

        @Override
        public void onFinishResolve(@NotNull ExternalAnnotationsTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            HeadlessLogging.INSTANCE.logMessage(GradleHeadlessLoggingProjectActivityKt.access$getGradlePrefix$p() + "Gradle resolving external annotations finished " + id.getProjectId());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/GradleHeadlessLoggingProjectActivity$StateNotificationListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "onSuccess", "", "projectPath", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "onFailure", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onCancel", "onStart", "intellij.gradle"})
    public static final class StateNotificationListener
    implements ExternalSystemTaskNotificationListener {
        @NotNull
        private final Project project;
        @NotNull
        private final CoroutineScope scope;

        public StateNotificationListener(@NotNull Project project, @NotNull CoroutineScope scope) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            this.project = project;
            this.scope = scope;
        }

        public void onSuccess(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (!GradleHeadlessLoggingProjectActivityKt.isGradleProjectResolveTask(id)) {
                return;
            }
            HeadlessLogging.INSTANCE.logMessage(GradleHeadlessLoggingProjectActivityKt.access$getGradlePrefix$p() + "Gradle resolve stage finished with success: " + id.getIdeProjectId());
            SimpleMessageBusConnection simpleMessageBusConnection = this.project.getMessageBus().connect(this.scope);
            Topic topic = ProjectDataImportListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            simpleMessageBusConnection.subscribe(topic, (Object)new ProjectDataImportListener(id){
                final /* synthetic */ ExternalSystemTaskId $id;
                {
                    this.$id = $id;
                }

                public void onImportStarted(String projectPath) {
                    HeadlessLogging.INSTANCE.logMessage(GradleHeadlessLoggingProjectActivityKt.access$getGradlePrefix$p() + "Gradle data import stage started: " + this.$id.getIdeProjectId());
                }

                public void onImportFinished(String projectPath) {
                    HeadlessLogging.INSTANCE.logMessage(GradleHeadlessLoggingProjectActivityKt.access$getGradlePrefix$p() + "Gradle data import stage finished with success: " + this.$id.getIdeProjectId());
                }

                public void onFinalTasksFinished(String projectPath) {
                    HeadlessLogging.INSTANCE.logMessage(GradleHeadlessLoggingProjectActivityKt.access$getGradlePrefix$p() + "Gradle data import(final tasks) stage finished: " + this.$id.getIdeProjectId());
                }

                public void onFinalTasksStarted(String projectPath) {
                    HeadlessLogging.INSTANCE.logMessage(GradleHeadlessLoggingProjectActivityKt.access$getGradlePrefix$p() + "Gradle data import(final tasks) stage started: " + this.$id.getIdeProjectId());
                }

                public void onImportFailed(String projectPath, Throwable t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    HeadlessLogging.INSTANCE.logFatalError(t);
                }
            });
        }

        public void onFailure(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull Exception exception) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            if (!GradleHeadlessLoggingProjectActivityKt.isGradleProjectResolveTask(id)) {
                return;
            }
            HeadlessLogging.INSTANCE.logFatalError((Throwable)exception);
        }

        public void onCancel(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (!GradleHeadlessLoggingProjectActivityKt.isGradleProjectResolveTask(id)) {
                return;
            }
            HeadlessLogging.INSTANCE.logWarning(GradleHeadlessLoggingProjectActivityKt.access$getGradlePrefix$p() + "Gradle resolve stage canceled " + id.getIdeProjectId());
        }

        public void onStart(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (!GradleHeadlessLoggingProjectActivityKt.isGradleProjectResolveTask(id)) {
                return;
            }
            HeadlessLogging.INSTANCE.logMessage(GradleHeadlessLoggingProjectActivityKt.access$getGradlePrefix$p() + "Gradle resolve stage started " + id.getIdeProjectId() + ", working dir: " + projectPath);
        }
    }
}

