/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

public abstract class AbstractTextToNumberFilter
extends RuleFilter {
    protected static Map<String, Float> numbers = new HashMap<String, Float>();
    protected static Map<String, Float> multipliers = new HashMap<String, Float>();

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        int posWord = 0;
        float total = 0.0f;
        float current = 0.0f;
        float totalDecimal = 0.0f;
        float currentDecimal = 0.0f;
        int addedZeros = 0;
        boolean percentage = false;
        boolean decimal = false;
        while (posWord < patternTokens.length && patternTokens[posWord].getEndPos() <= match.getToPos()) {
            if (patternTokens[posWord].getStartPos() >= match.getFromPos() && patternTokens[posWord].getEndPos() <= match.getToPos()) {
                String form = patternTokens[posWord].getToken().toLowerCase();
                if (posWord > 0 && this.isPercentage(patternTokens, posWord)) {
                    percentage = true;
                    break;
                }
                if (this.isComma(form)) {
                    decimal = true;
                    ++posWord;
                    continue;
                }
                List<String> forms = this.tokenize(form);
                for (String subForm : forms) {
                    if (!decimal) {
                        if (numbers.containsKey(subForm)) {
                            current += numbers.get(subForm).floatValue();
                            continue;
                        }
                        if (!multipliers.containsKey(subForm)) continue;
                        if (current == 0.0f) {
                            current = 1.0f;
                        }
                        total += current * multipliers.get(subForm).floatValue();
                        current = 0.0f;
                        continue;
                    }
                    if (!numbers.containsKey(subForm)) continue;
                    int zerosToAdd = this.format(numbers.get(subForm).floatValue(), false).length();
                    currentDecimal = (float)((double)currentDecimal + (double)numbers.get(subForm).floatValue() / Math.pow(10.0, addedZeros + zerosToAdd));
                    ++addedZeros;
                }
            }
            ++posWord;
        }
        total += current;
        RuleMatch ruleMatch = match;
        String sugg = this.format(total += (totalDecimal += currentDecimal), percentage);
        ruleMatch.addSuggestedReplacement(sugg);
        return ruleMatch;
    }

    private String format(float d, boolean percentage) {
        String result = d == (float)((long)d) ? String.format("%d", (long)d) : String.format("%s", Float.valueOf(d));
        if (percentage) {
            result = result + "\u202f%";
        }
        return this.formatResult(result);
    }

    protected abstract boolean isComma(String var1);

    protected abstract boolean isPercentage(AnalyzedTokenReadings[] var1, int var2);

    protected String formatResult(String s) {
        return s;
    }

    protected List<String> tokenize(String s) {
        return Collections.singletonList(s);
    }
}

