---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 一般的なGitコマンドとワークフロー。
title: 基本的なGit操作
description: プロジェクトの作成、リポジトリのクローン、スタッシュの変更、ブランチ、フォーク。
---

基本的なGit操作は、Gitリポジトリを管理し、コードに変更を加えるのに役立ちます。これらは、次の利点を提供します:  

- バージョン管理: プロジェクトの履歴を保持して変更を追跡し、必要に応じて以前のバージョンに戻します。
- コラボレーション: コラボレーションを可能にし、コードの共有と同時作業を容易にします。
- 組織: ブランチとマージリクエストを使用して、作業を整理および管理します。
- Code Quality: マージリクエストを介してコードレビューを促進し、コードの品質と一貫性を維持するのに役立ちます。
- バックアップとリカバリー: 変更をリモートリポジトリにプッシュして、作業がバックアップされ、リカバリー可能であることを確認します。

Git操作を効果的に使用するには、リポジトリ、ブランチ、コミット、マージリクエストなどの主要な概念を理解することが重要です。詳細については、[Gitの学習を開始する](get_started.md)を参照してください。

一般的に使用されるGitコマンドの詳細については、[Gitコマンド](commands.md)を参照してください。

## プロジェクトを作成する {#create-a-project}

`git push`コマンドは、ローカルリポジトリの変更をリモートリポジトリに送信します。ローカルリポジトリからプロジェクトを作成するか、既存のリポジトリをインポートできます。リポジトリを追加すると、GitLabは選択したネームスペースにプロジェクトを作成します。詳細については、[プロジェクトの作成](project.md)を参照してください。

## リポジトリのクローンを作成する {#clone-a-repository}

`git clone`コマンドは、コンピューター上にリモートリポジトリのコピーを作成します。ローカルでコードを作業し、変更をリモートリポジトリにプッシュして戻すことができます。詳細については、[Gitリポジトリのクローンを作成](clone.md)を参照してください。

## ブランチを作成する {#create-a-branch}

`git checkout -b <name-of-branch>`コマンドは、リポジトリに新しいブランチを作成します。ブランチは、デフォルトのブランチに影響を与えることなく変更できる、リポジトリ内のファイルのコピーです。詳細については、[ブランチの作成](branch.md)を参照してください。

## ステージ、コミット、そして変更をプッシュ {#stage-commit-and-push-changes}

`git add`、`git commit`、および`git push`コマンドは、変更を加えてリモートリポジトリを更新します。Gitは、チェックアウトされたブランチの最新バージョンに対する変更を追跡します。詳細については、[変更のステージング、コミット、プッシュ](commit.md)を参照してください。

## 変更をスタッシュ {#stash-changes}

`git stash`コマンドは、すぐにコミットしたくない変更を一時的に保存します。不完全な変更をコミットせずに、ブランチを切り替えたり、他の操作を実行したりできます。詳細については、[スタッシュの変更](stash.md)を参照してください。

## ブランチにファイルを追加 {#add-files-to-a-branch}

`git add <filename>`コマンドは、Gitリポジトリまたはブランチにファイルを追加します。新しいファイルを追加したり、既存のファイルを変更したり、ファイルを削除したりできます。詳細については、[ブランチへのファイル追加](add_files.md)を参照してください。

## マージリクエスト {#merge-requests}

マージリクエストは、あるブランチから別のブランチへの変更をマージするリクエストです。マージリクエストは、コラボレーションしてコードの変更をレビューする方法を提供します。詳細については、[マージリクエスト](../../user/project/merge_requests/_index.md)と[ブランチをマージする](merge.md)を参照してください。

## フォークを更新する {#update-your-fork}

フォークは、選択したネームスペースに作成するリポジトリとそのすべてのブランチの個人用コピーです。自分のフォークに変更を加え、`git push`を使用して送信できます。詳細については、[フォークを更新](forks.md)を参照してください。

## 関連トピック {#related-topics}

- [Gitの学習を開始する](get_started.md)
  - [Gitをインストールする](how_to_install_git/_index.md)
  - [一般的なGitコマンド](commands.md)
- [高度な操作](advanced.md)
- [Gitのトラブルシューティング](troubleshooting_git.md)
- [Gitチートシート](https://about.gitlab.com/images/press/git-cheat-sheet.pdf)
