/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package agent.dbgmodel.jna.dbgmodel.debughost;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinDef.ULONGLONGByReference;
import com.sun.jna.platform.win32.WinNT.HRESULT;

public class X_WrapIDebugHostBaseClass extends WrapIDebugHostBaseClass
		implements X_IDebugHostBaseClass {
	public static class ByReference extends X_WrapIDebugHostBaseClass
			implements Structure.ByReference {
	}

	public X_WrapIDebugHostBaseClass() {
	}

	public X_WrapIDebugHostBaseClass(Pointer pvInstance) {
		super(pvInstance);
	}

	@Override
	public HRESULT GetOffset(ULONGLONGByReference offset) {
		return _invokeHR(VTIndices.GET_OFFSET, getPointer(), offset);
	}

}
