/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.object;

import ghidra.util.Msg;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.MDString;
import mdemangler.functiontype.MDFunctionType;
import mdemangler.naming.MDQualification;
import mdemangler.naming.MDQualifiedBasicName;
import mdemangler.object.MDObject;
import mdemangler.typeinfo.MDTypeInfo;
import mdemangler.typeinfo.MDTypeInfoParser;

public class MDObjectCPP
extends MDObject {
    protected MDHashedObject hashedObject;
    protected MDQualifiedBasicName qualifiedName;
    protected MDTypeInfo typeInfo;
    protected boolean embeddedObjectFlag;
    protected boolean hashedObjectFlag;

    public MDObjectCPP(MDMang dmang) {
        super(dmang);
    }

    public MDQualifiedBasicName getQualifiedName() {
        return this.qualifiedName;
    }

    public MDTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public MDObjectCPP getEmbeddedObject() {
        if (this.embeddedObjectFlag) {
            return this.qualifiedName.getBasicName().getEmbeddedObject();
        }
        return this;
    }

    public String getName() {
        if (this.hashedObjectFlag) {
            return this.hashedObject.toString();
        }
        return this.getQualifiedName().getBasicName().toString();
    }

    public MDQualification getQualification() {
        if (this.hashedObjectFlag) {
            return this.hashedObject.getQualification();
        }
        return this.getQualifiedName().getQualification();
    }

    public boolean isString() {
        if (this.qualifiedName == null) {
            return false;
        }
        return this.qualifiedName.isString();
    }

    public MDString getMDString() {
        if (this.isString()) {
            return this.qualifiedName.getMDString();
        }
        return null;
    }

    @Override
    public void insert(StringBuilder builder) {
        if (this.hashedObjectFlag) {
            this.hashedObject.insert(builder);
        } else {
            this.qualifiedName.insert(builder);
            if (this.typeInfo != null) {
                this.typeInfo.insert(builder);
            }
        }
    }

    @Override
    protected void parseInternal() throws MDException {
        if (this.dmang.peek() != '?') {
            throw new MDException("Invalid ObjectCPP");
        }
        if (!this.dmang.isProcessingModeActive(MDMang.ProcessingMode.LLVM)) {
            this.dmang.increment();
        }
        if (this.dmang.peek(0) == '?' && this.dmang.peek(1) == '?') {
            this.embeddedObjectFlag = true;
        }
        if (this.dmang.peek(0) == '?' && this.dmang.peek(1) == '@') {
            this.dmang.processHashedObject(this);
        } else {
            this.qualifiedName = new MDQualifiedBasicName(this.dmang);
            this.qualifiedName.parse();
            if (this.qualifiedName.isString()) {
                return;
            }
            if (this.dmang.peek() != '\uffff') {
                int RTTINum = this.qualifiedName.getRTTINumber();
                this.typeInfo = MDTypeInfoParser.parse(this.dmang, RTTINum);
                if (this.qualifiedName.isTypeCast()) {
                    this.typeInfo.setTypeCast();
                }
                this.typeInfo.parse();
                if (!this.typeInfo.getNameModifier().isEmpty()) {
                    this.qualifiedName.setNameModifier(this.typeInfo.getNameModifier());
                }
                if (this.qualifiedName.isTypeCast()) {
                    this.applyFunctionReturnTypeToTypeCastOperatorName();
                }
            }
        }
    }

    private void applyFunctionReturnTypeToTypeCastOperatorName() {
        if (!(this.typeInfo.getMDType() instanceof MDFunctionType)) {
            Msg.warn((Object)this, (Object)"Cannot get function return type from non-function");
            return;
        }
        MDFunctionType functionType = (MDFunctionType)this.typeInfo.getMDType();
        if (!functionType.hasReturn() || functionType.getReturnType() == null) {
            Msg.warn((Object)this, (Object)"No return type available to set to cast operator name");
            return;
        }
        this.qualifiedName.setCastTypeString(functionType.getReturnType().toString());
    }

    public void processHashedObject() throws MDException {
        this.hashedObject = new MDHashedObject(this.dmang);
        this.hashedObject.parse();
        this.hashedObjectFlag = true;
    }

    public void processHashedObjectMSVC() throws MDException {
        throw new MDException("cannot parse hashed symbol");
    }

    public class MDHashedObject
    extends MDParsableItem {
        private String hashString;
        private MDQualification qualification;

        public MDHashedObject(MDMang dmang) {
            super(dmang);
            this.hashString = "";
            this.qualification = new MDQualification(dmang);
        }

        public String getHashString() {
            return this.hashString;
        }

        public MDQualification getQualification() {
            return this.qualification;
        }

        @Override
        protected void parseInternal() throws MDException {
            char ch;
            if (this.dmang.peek() != '?' && this.dmang.peek(1) != '@') {
                throw new MDException("Invalid HashedObject");
            }
            this.dmang.increment(2);
            StringBuilder builder = new StringBuilder();
            int start = this.dmang.getIndex();
            while ((ch = this.dmang.peek()) != '\uffff' && ch != '@' && (Character.isLetter(ch) || Character.isDigit(ch))) {
                builder.append(ch);
                this.dmang.increment();
            }
            int end = this.dmang.getIndex();
            if (end - start != 32 || ch != '@') {
                throw new MDException("Invalid HashedObject");
            }
            this.dmang.increment();
            this.hashString = builder.toString();
        }

        @Override
        public void insert(StringBuilder builder) {
            builder.append("`" + this.hashString + "'");
        }
    }
}

