/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBProcess;
import SWIG.SBThread;
import SWIG.StateType;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbCause;
import agent.lldb.manager.LldbReason;
import agent.lldb.model.iface1.LldbModelTargetConfigurable;
import agent.lldb.model.iface2.LldbModelTargetProcess;
import agent.lldb.model.iface2.LldbModelTargetThread;
import agent.lldb.model.iface2.LldbModelTargetThreadContainer;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetProcessImpl;
import agent.lldb.model.impl.LldbModelTargetThreadImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="ThreadContainer", elementResync=TargetObjectSchema.ResyncMode.ALWAYS, elements={@TargetElementType(type=LldbModelTargetThreadImpl.class)}, attributes={@TargetAttributeType(name="_base", type=Integer.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class LldbModelTargetThreadContainerImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetThreadContainer,
LldbModelTargetConfigurable {
    protected final SBProcess process;

    public LldbModelTargetThreadContainerImpl(LldbModelTargetProcessImpl process) {
        super(process.getModel(), (TargetObject)process, "Threads", "ThreadContainer");
        this.process = process.getProcess();
        this.changeAttributes(List.of(), Map.of("_base", 16), "Initialized");
        this.getManager().addEventsListener(this);
        this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
    }

    @Override
    public void threadCreated(SBThread thread) {
        this.changeElements(List.of(), List.of(this.getTargetThread(thread)), Map.of(), "Created");
        LldbModelTargetThread targetThread = this.getTargetThread(thread);
        this.changeElements(List.of(), List.of(targetThread), Map.of(), "Created");
        targetThread.threadStateChangedSpecific(StateType.eStateConnected, LldbReason.getReason(null));
        this.broadcast().event((TargetObject)this.getProxy(), (TargetThread)targetThread, TargetEventScope.TargetEventType.THREAD_CREATED, "Thread " + DebugClient.getId(thread) + " started", List.of(targetThread));
    }

    @Override
    public void threadReplaced(SBThread thread) {
        this.changeElements(List.of(), List.of(this.getTargetThread(thread)), Map.of(), "Created");
        LldbModelTargetThread targetThread = this.getTargetThread(thread);
        this.changeElements(List.of(), List.of(targetThread), Map.of(), "Created");
    }

    @Override
    public void threadStateChanged(SBThread thread, StateType state, LldbCause cause, LldbReason reason) {
        LldbModelTargetThread targetThread = this.getTargetThread(thread);
        TargetEventScope.TargetEventType eventType = this.getEventType(state, cause, reason);
        this.broadcast().event((TargetObject)this.getProxy(), (TargetThread)targetThread, eventType, "Thread " + DebugClient.getId(thread) + " state changed", List.of(targetThread));
        targetThread.threadStateChangedSpecific(state, reason);
    }

    @Override
    public void threadExited(SBThread thread) {
        if (thread == null) {
            return;
        }
        String threadId = LldbModelTargetThreadImpl.indexThread(thread);
        LldbModelTargetThread targetThread = (LldbModelTargetThread)this.getMapObject(thread);
        if (targetThread != null) {
            this.broadcast().event((TargetObject)this.getProxy(), (TargetThread)targetThread, TargetEventScope.TargetEventType.THREAD_EXITED, "Thread " + threadId + " exited", List.of(targetThread));
        }
        this.changeElements(List.of(threadId), List.of(), Map.of(), "Exited");
    }

    private TargetEventScope.TargetEventType getEventType(StateType state, LldbCause cause, LldbReason reason) {
        switch (state.swigValue()) {
            case 0: {
                return TargetEventScope.TargetEventType.RUNNING;
            }
            case 1: {
                return TargetEventScope.TargetEventType.PROCESS_EXITED;
            }
            case 2: 
            case 3: 
            case 4: {
                return TargetEventScope.TargetEventType.PROCESS_CREATED;
            }
            case 5: {
                return TargetEventScope.TargetEventType.STOPPED;
            }
            case 6: 
            case 7: {
                return TargetEventScope.TargetEventType.RUNNING;
            }
            case 8: 
            case 9: 
            case 10: {
                return TargetEventScope.TargetEventType.PROCESS_EXITED;
            }
            case 11: {
                return TargetEventScope.TargetEventType.STOPPED;
            }
        }
        return TargetEventScope.TargetEventType.STOPPED;
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.getManager().listThreads(this.process).thenAccept(byTID -> {
            List threads;
            LldbModelTargetThreadContainerImpl lldbModelTargetThreadContainerImpl = this;
            synchronized (lldbModelTargetThreadContainerImpl) {
                threads = byTID.values().stream().map(this::getTargetThread).collect(Collectors.toList());
            }
            this.setElements(threads, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized LldbModelTargetThread getTargetThread(SBThread thread) {
        TargetObject targetObject = this.getMapObject(thread);
        if (targetObject != null) {
            LldbModelTargetThread targetThread = (LldbModelTargetThread)targetObject;
            targetThread.setModelObject(thread);
            return targetThread;
        }
        return new LldbModelTargetThreadImpl(this, (LldbModelTargetProcess)this.parent, thread);
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        switch (key) {
            case "_base": {
                if (value instanceof Integer) {
                    this.changeAttributes(List.of(), Map.of("_base", value), "Modified");
                    for (TargetObject child : this.getCachedElements().values()) {
                        if (!(child instanceof LldbModelTargetThreadImpl)) continue;
                        LldbModelTargetThreadImpl targetThread = (LldbModelTargetThreadImpl)child;
                        targetThread.setBase(value);
                    }
                    break;
                }
                throw new DebuggerIllegalArgumentException("Base should be numeric");
            }
        }
        return AsyncUtils.nil();
    }
}

