/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBBreakpointLocation;
import SWIG.SBTarget;
import agent.lldb.model.iface2.LldbModelTargetBreakpointLocation;
import agent.lldb.model.iface2.LldbModelTargetBreakpointLocationContainer;
import agent.lldb.model.iface2.LldbModelTargetProcess;
import agent.lldb.model.impl.LldbModelTargetAbstractXpointSpec;
import agent.lldb.model.impl.LldbModelTargetBreakpointLocationImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetProcessImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="BreakpointLocationContainer", elements={@TargetElementType(type=LldbModelTargetBreakpointLocationImpl.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class LldbModelTargetBreakpointLocationContainerImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetBreakpointLocationContainer {
    protected final LldbModelTargetProcessImpl targetProcess;

    public LldbModelTargetBreakpointLocationContainerImpl(LldbModelTargetProcess targetProcess) {
        super(targetProcess.getModel(), (TargetObject)targetProcess, "Breakpoints", "BreakpointLocationContainer");
        this.targetProcess = (LldbModelTargetProcessImpl)targetProcess;
        this.getManager().addEventsListener(this);
        this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
    }

    public LldbModelTargetBreakpointLocation getTargetBreakpointLocation(SBBreakpointLocation loc) {
        TargetObject targetObject = this.getMapObject(loc);
        if (targetObject != null) {
            LldbModelTargetBreakpointLocation location = (LldbModelTargetBreakpointLocation)targetObject;
            location.setModelObject(loc);
            return location;
        }
        TargetObject spec = this.getModel().getModelObject(loc.GetBreakpoint());
        return new LldbModelTargetBreakpointLocationImpl((LldbModelTargetAbstractXpointSpec)spec, loc);
    }

    @Override
    public void addBreakpointLocation(LldbModelTargetBreakpointLocation loc) {
        this.changeElements(List.of(), Map.of(loc.getName(), loc), "Added");
    }

    @Override
    public void removeBreakpointLocation(LldbModelTargetBreakpointLocation loc) {
        this.changeElements(List.of(loc.getName()), Map.of(), "Removed");
    }

    public SBTarget getSession() {
        return (SBTarget)this.getModelObject();
    }
}

