/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.ByteArray;
import SWIG.SBError;
import SWIG.SBProcess;
import SWIG.SBStream;
import SWIG.SWIGTYPE_p_void;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class LldbReadMemoryCommand
extends AbstractLldbCommand<AddressSetView> {
    private final SBProcess process;
    private final Address addr;
    private final ByteBuffer buf;
    private final int len;

    public LldbReadMemoryCommand(LldbManagerImpl manager, SBProcess process, Address addr, ByteBuffer buf, int len) {
        super(manager);
        this.process = process;
        this.addr = addr;
        this.buf = buf;
        this.len = len;
    }

    @Override
    public AddressSetView complete(LldbPendingCommand<?> pending) {
        return new AddressSet(this.addr, this.addr.add((long)(this.len - 1)));
    }

    @Override
    public void invoke() {
        BigInteger offset = this.addr.getOffsetAsBigInteger();
        SBError error = new SBError();
        ByteArray buffer = new ByteArray(this.len);
        long read = this.process.ReadMemory(offset, (SWIGTYPE_p_void)buffer, (long)this.len, error);
        if (!error.Success()) {
            SBStream stream = new SBStream();
            error.GetDescription(stream);
            Msg.error((Object)this, (Object)(error.GetType() + ":" + stream.GetData()));
            return;
        }
        int i = 0;
        while ((long)i < read) {
            this.buf.put(i, buffer.getitem(i));
            ++i;
        }
        buffer.delete();
    }
}

