/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBProcess;
import SWIG.SBTarget;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbCause;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LldbListProcessesCommand
extends AbstractLldbCommand<Map<String, SBProcess>> {
    private Map<String, SBProcess> updatedProcesses;
    private SBTarget session;

    public LldbListProcessesCommand(LldbManagerImpl manager, SBTarget session) {
        super(manager);
        this.session = session;
    }

    @Override
    public Map<String, SBProcess> complete(LldbPendingCommand<?> pending) {
        Map<String, SBProcess> allProcesses = this.manager.getKnownProcesses(this.session);
        Set<String> cur = allProcesses.keySet();
        for (String id : this.updatedProcesses.keySet()) {
            if (cur.contains(id)) continue;
            this.manager.addProcessIfAbsent(this.session, this.updatedProcesses.get(id));
        }
        String sessionId = DebugClient.getId(this.session);
        for (String id : new ArrayList<String>(cur)) {
            if (this.updatedProcesses.containsKey(id)) continue;
            this.manager.removeProcess(sessionId, id, LldbCause.Causes.UNCLAIMED);
        }
        return allProcesses;
    }

    @Override
    public void invoke() {
        SBProcess p = this.session.GetProcess();
        this.updatedProcesses = new HashMap<String, SBProcess>();
        this.updatedProcesses.put(DebugClient.getId(p), p);
    }
}

