/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.gadp.impl;

import agent.lldb.gadp.LldbGadpServer;
import agent.lldb.model.AbstractLldbModel;
import agent.lldb.model.impl.LldbModelImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.gadp.server.AbstractGadpServer;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;

public class LldbGadpServerImpl
implements LldbGadpServer {
    protected final AbstractLldbModel model = new LldbModelImpl();
    protected final GadpSide server;

    public LldbGadpServerImpl(SocketAddress addr) throws IOException {
        this.server = new GadpSide(this.model, addr);
    }

    @Override
    public CompletableFuture<Void> startLLDB(String[] args) {
        return this.model.startLLDB(args).thenCompose(__ -> this.server.launchAsyncService());
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.server.getLocalAddress();
    }

    @Override
    public boolean isRunning() {
        return this.model.isRunning();
    }

    @Override
    public void terminate() throws IOException {
        this.model.terminate();
        this.server.terminate();
    }

    public class GadpSide
    extends AbstractGadpServer {
        public GadpSide(AbstractLldbModel model, SocketAddress addr) throws IOException {
            super((DebuggerObjectModel)model, addr);
        }
    }
}

