/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.linux;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import ghidra.pty.linux.Err;

public interface PosixC
extends Library {
    public static final PosixC BARE = (PosixC)Native.load((String)"c", PosixC.class);
    public static final PosixC INSTANCE = new PosixC(){

        @Override
        public String strerror(int errnum) {
            return BARE.strerror(errnum);
        }

        @Override
        public int close(int fd) {
            return Err.checkLt0(BARE.close(fd));
        }

        @Override
        public int read(int fd, Pointer buf, int len) {
            return Err.checkLt0(BARE.read(fd, buf, len));
        }

        @Override
        public int write(int fd, Pointer buf, int i) {
            return Err.checkLt0(BARE.write(fd, buf, i));
        }

        @Override
        public int setsid() {
            return Err.checkLt0(BARE.setsid());
        }

        @Override
        public int open(String path, int mode, int flags) {
            return Err.checkLt0(BARE.open(path, mode, flags));
        }

        @Override
        public int dup2(int oldfd, int newfd) {
            return Err.checkLt0(BARE.dup2(oldfd, newfd));
        }

        @Override
        public int execv(String path, String[] argv) {
            return Err.checkLt0(BARE.execv(path, argv));
        }

        @Override
        public int ioctl(int fd, int cmd, Pointer ... args) {
            return Err.checkLt0(BARE.ioctl(fd, cmd, args));
        }

        @Override
        public int tcgetattr(int fd, Termios.ByReference termios_p) {
            return Err.checkLt0(BARE.tcgetattr(fd, termios_p));
        }

        @Override
        public int tcsetattr(int fd, int optional_actions, Termios.ByReference termios_p) {
            return Err.checkLt0(BARE.tcsetattr(fd, optional_actions, termios_p));
        }
    };

    public String strerror(int var1);

    public int close(int var1);

    public int read(int var1, Pointer var2, int var3);

    public int write(int var1, Pointer var2, int var3);

    public int setsid();

    public int open(String var1, int var2, int var3);

    public int dup2(int var1, int var2);

    public int execv(String var1, String[] var2);

    public int ioctl(int var1, int var2, Pointer ... var3);

    public int tcgetattr(int var1, Termios.ByReference var2);

    public int tcsetattr(int var1, int var2, Termios.ByReference var3);

    @Structure.FieldOrder(value={"c_iflag", "c_oflag", "c_cflag", "c_lflag", "c_line", "c_cc", "c_ispeed", "c_ospeed"})
    public static class Termios
    extends Structure {
        public static final int TCSANOW = 0;
        public static final int ECHO = 8;
        public int c_iflag;
        public int c_oflag;
        public int c_cflag;
        public int c_lflag;
        public byte c_line;
        public byte[] c_cc = new byte[32];
        public int c_ispeed;
        public int c_ospeed;

        public static class ByReference
        extends Termios
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"ws_row", "ws_col", "ws_xpixel", "ws_ypixel"})
    public static class Winsize
    extends Structure {
        public static final int TIOCSWINSZ = 21524;
        public short ws_row;
        public short ws_col;
        public short ws_xpixel;
        public short ws_ypixel;

        public static class ByReference
        extends Winsize
        implements Structure.ByReference {
        }
    }
}

