/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractCompositeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractPointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DummyMsType;
import ghidra.app.util.pdb.pdbapplicator.ClassTypeUtils;
import ghidra.app.util.pdb.pdbapplicator.CompositeTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FixupContext;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.CancelledException;

public class PointerTypeApplier
extends MsTypeApplier {
    public PointerTypeApplier(DefaultPdbApplicator applicator) throws IllegalArgumentException {
        super(applicator);
    }

    String getPointerCommentField(AbstractPointerMsType type, FixupContext fixupContext) throws CancelledException, PdbException {
        AbstractPointerMsType.PointerMode pointerMode = type.getPointerMode();
        if (pointerMode == AbstractPointerMsType.PointerMode.MEMBER_FUNCTION_POINTER) {
            return "\"::*\" (pmf)";
        }
        if (pointerMode == AbstractPointerMsType.PointerMode.MEMBER_DATA_POINTER) {
            return "\"::*\" (pdm)";
        }
        return null;
    }

    @Override
    DataType apply(AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        Object dataType;
        if (fixupContext != null && (dataType = this.applicator.getDataType(type)) != null) {
            return dataType;
        }
        dataType = type instanceof DummyMsType ? new PointerDataType(this.applicator.getDataTypeManager()) : this.applyAbstractPointerMsType((AbstractPointerMsType)type, fixupContext);
        dataType = this.applicator.resolve((DataType)dataType);
        this.applicator.putDataType(type, (DataType)dataType);
        return dataType;
    }

    private DataType getUnderlyingType(AbstractPointerMsType type, FixupContext fixupContext) throws CancelledException, PdbException {
        RecordNumber underlyingRecord = type.getUnderlyingRecordNumber();
        return this.applicator.getProcessedDataType(underlyingRecord, fixupContext, true);
    }

    private DataType applyAbstractPointerMsType(AbstractPointerMsType type, FixupContext fixupContext) throws CancelledException, PdbException {
        AbstractPointerMsType.PointerMode pointerMode = type.getPointerMode();
        if (pointerMode == AbstractPointerMsType.PointerMode.MEMBER_DATA_POINTER || pointerMode == AbstractPointerMsType.PointerMode.MEMBER_FUNCTION_POINTER) {
            return this.processMemberPointer(type, fixupContext);
        }
        return this.processPointer(type, fixupContext);
    }

    private DataType processMemberPointer(AbstractPointerMsType type, FixupContext fixupContext) throws CancelledException, PdbException {
        DataType underlyingType = this.getUnderlyingType(type, fixupContext);
        int size = type.getSize().intValueExact();
        AbstractPointerMsType.PointerMode pointerMode = type.getPointerMode();
        String name = pointerMode == AbstractPointerMsType.PointerMode.MEMBER_FUNCTION_POINTER ? String.format("pmf_%08x", type.toString().hashCode()) : String.format("pdm_%08x", type.toString().hashCode());
        RecordNumber containingClassRecordNumber = type.getMemberPointerContainingClassRecordNumber();
        CategoryPath storagePath = this.getCategoryPathForMemberPointer(containingClassRecordNumber);
        StructureDataType dt = new StructureDataType(storagePath, name, size);
        dt.setDescription(type.toString());
        return this.applicator.resolve((DataType)dt);
    }

    private CategoryPath getCategoryPathForMemberPointer(RecordNumber containingClassRecordNumber) {
        AbstractMsType containingType = this.applicator.getPdb().getTypeRecord(containingClassRecordNumber);
        MsTypeApplier applier = this.applicator.getTypeApplier(containingClassRecordNumber);
        if (containingType instanceof AbstractCompositeMsType) {
            AbstractCompositeMsType compositeMsType = (AbstractCompositeMsType)containingType;
            if (applier instanceof CompositeTypeApplier) {
                CompositeTypeApplier compositeApplier = (CompositeTypeApplier)applier;
                SymbolPath symbolPath = compositeApplier.getFixedSymbolPath(compositeMsType);
                CategoryPath categoryPath = this.applicator.getCategory(symbolPath);
                return ClassTypeUtils.getInternalsCategoryPath(categoryPath);
            }
        }
        return this.applicator.getAnonymousTypesCategory();
    }

    private DataType processPointer(AbstractPointerMsType type, FixupContext fixupContext) throws CancelledException, PdbException {
        DataType underlyingType = this.getUnderlyingType(type, fixupContext);
        int size = type.getSize().intValueExact();
        if (size == this.applicator.getDataOrganization().getPointerSize()) {
            size = -1;
        }
        if (underlyingType == null || this.applicator.isPlaceholderType(underlyingType)) {
            return this.applicator.getPlaceholderPointer(size);
        }
        return new PointerDataType(underlyingType, size, this.applicator.getDataTypeManager());
    }
}

