/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.unix;

import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.sys.EmuIOException;
import ghidra.pcode.emu.unix.AbstractStreamEmuUnixFileHandle;
import ghidra.program.model.lang.CompilerSpec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOStreamEmuUnixFileHandle
extends AbstractStreamEmuUnixFileHandle<byte[]> {
    protected final InputStream input;
    protected final OutputStream output;

    public static IOStreamEmuUnixFileHandle stdin(PcodeMachine<byte[]> machine, CompilerSpec cSpec) {
        return new IOStreamEmuUnixFileHandle(machine, cSpec, System.in, null);
    }

    public static IOStreamEmuUnixFileHandle stdout(PcodeMachine<byte[]> machine, CompilerSpec cSpec) {
        return new IOStreamEmuUnixFileHandle(machine, cSpec, null, System.out);
    }

    public static IOStreamEmuUnixFileHandle stderr(PcodeMachine<byte[]> machine, CompilerSpec cSpec) {
        return new IOStreamEmuUnixFileHandle(machine, cSpec, null, System.err);
    }

    public IOStreamEmuUnixFileHandle(PcodeMachine<byte[]> machine, CompilerSpec cSpec, InputStream input, OutputStream output) {
        super(machine, cSpec);
        this.input = input;
        this.output = output;
    }

    @Override
    public byte[] read(byte[] buf) throws EmuIOException {
        if (this.input == null) {
            return (byte[])this.arithmetic.fromConst(0L, this.offsetBytes);
        }
        try {
            int result = this.input.read(buf);
            return (byte[])this.arithmetic.fromConst((long)result, this.offsetBytes);
        }
        catch (IOException e) {
            throw new EmuIOException("Could not read host input stream", e);
        }
    }

    @Override
    public byte[] write(byte[] buf) throws EmuIOException {
        if (this.output == null) {
            return (byte[])this.arithmetic.fromConst(0L, this.offsetBytes);
        }
        try {
            this.output.write(buf);
            return (byte[])this.arithmetic.fromConst((long)buf.length, this.offsetBytes);
        }
        catch (IOException e) {
            throw new EmuIOException("Could not write host output stream", e);
        }
    }

    @Override
    public void close() {
    }
}

