/*
 * Decompiled with CFR 0.152.
 */
package ghidra.codecompare;

import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.DecompilerLocation;
import ghidra.app.decompiler.component.DecompilerCodeComparisonPanel;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DualDecompilerFieldPanelCoordinator;
import ghidra.codecompare.DecompileDataDiff;
import ghidra.codecompare.DecompilerDiffCodeComparisonPanel;
import ghidra.codecompare.graphanalysis.TokenBin;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public class CodeDiffFieldPanelCoordinator
extends DualDecompilerFieldPanelCoordinator {
    private BidiMap<Integer, Integer> leftToRightLineNumberPairing;
    private List<ClangLine> leftLines = new ArrayList<ClangLine>();
    private List<ClangLine> rightLines = new ArrayList<ClangLine>();
    private int lockedLeftLineNumber = 0;
    private int lockedRightLineNumber = 0;
    private DecompilerPanel leftDecompilerPanel;
    private DecompilerPanel rightDecompilerPanel;
    private boolean matchConstantsExactly;
    private List<TokenBin> highBins;

    public CodeDiffFieldPanelCoordinator(DecompilerDiffCodeComparisonPanel dualDecompilerPanel) {
        super((DecompilerCodeComparisonPanel)dualDecompilerPanel);
        this.leftDecompilerPanel = dualDecompilerPanel.getLeftDecompilerPanel();
        this.rightDecompilerPanel = dualDecompilerPanel.getRightDecompilerPanel();
        this.leftToRightLineNumberPairing = new DualHashBidiMap();
    }

    public void computeLinePairing(DecompileDataDiff decompileDataDiff, TaskMonitor monitor) throws CancelledException {
        this.highBins = decompileDataDiff.getTokenMap(this.matchConstantsExactly, monitor);
        HighFunction leftHighFunction = decompileDataDiff.getLeftHighFunction();
        this.clearLineNumberPairing();
        for (TokenBin bin : this.highBins) {
            if (bin.getMatch() == null) continue;
            boolean isLeftBin = bin.getHighFunction().equals(leftHighFunction);
            ClangToken binToken = bin.get(0);
            ClangToken sidekickToken = bin.getMatch().get(0);
            ClangToken leftClangToken = isLeftBin ? binToken : sidekickToken;
            ClangToken rightClangToken = isLeftBin ? sidekickToken : binToken;
            ClangLine leftLine = leftClangToken.getLineParent();
            ClangLine rightLine = rightClangToken.getLineParent();
            this.leftToRightLineNumberPairing.put((Object)leftLine.getLineNumber(), (Object)rightLine.getLineNumber());
        }
    }

    public void leftLocationChanged(ProgramLocation leftLocation) {
        int leftLineNumber;
        ClangLine leftLine;
        DecompilerLocation leftDecompilerLocation = (DecompilerLocation)leftLocation;
        ClangToken leftToken = leftDecompilerLocation != null ? leftDecompilerLocation.getToken() : null;
        ClangLine clangLine = leftLine = leftToken != null ? leftToken.getLineParent() : null;
        if (leftLine != null && this.searchLeftForPair(leftLineNumber = leftLine.getLineNumber())) {
            this.lockLines(new BigInteger[]{BigInteger.valueOf(this.lockedLeftLineNumber), BigInteger.valueOf(this.lockedRightLineNumber)});
        }
        this.panelViewChanged(this.leftDecompilerPanel);
    }

    public void rightLocationChanged(ProgramLocation rightLocation) {
        int rightLineNumber;
        ClangLine rightLine;
        DecompilerLocation rightDecompilerLocation = (DecompilerLocation)rightLocation;
        ClangToken rightToken = rightDecompilerLocation != null ? rightDecompilerLocation.getToken() : null;
        ClangLine clangLine = rightLine = rightToken != null ? rightToken.getLineParent() : null;
        if (rightLine != null && this.searchRightForPair(rightLineNumber = rightLine.getLineNumber())) {
            this.lockLines(new BigInteger[]{BigInteger.valueOf(this.lockedLeftLineNumber), BigInteger.valueOf(this.lockedRightLineNumber)});
        }
        this.panelViewChanged(this.rightDecompilerPanel);
    }

    public void replaceDecompileDataDiff(DecompileDataDiff decompileDataDiff, boolean shouldMatchConstantsExactly, TaskMonitor monitor) throws CancelledException {
        this.matchConstantsExactly = shouldMatchConstantsExactly;
        if (this.leftDecompilerPanel != null) {
            this.leftLines = this.leftDecompilerPanel.getLines();
        } else {
            this.leftLines.clear();
        }
        if (this.rightDecompilerPanel != null) {
            this.rightLines = this.rightDecompilerPanel.getLines();
        } else {
            this.rightLines.clear();
        }
        this.lockFunctionSignatureLines();
        this.computeLinePairing(decompileDataDiff, monitor);
    }

    void clearLineNumberPairing() {
        this.leftToRightLineNumberPairing.clear();
    }

    List<TokenBin> getHighBins() {
        return this.highBins;
    }

    private void panelViewChanged(DecompilerPanel panel) {
        ViewerPosition viewerPosition = panel.getViewerPosition();
        BigInteger index = viewerPosition.getIndex();
        int xOffset = viewerPosition.getXOffset();
        int yOffset = viewerPosition.getYOffset();
        this.viewChanged(panel.getFieldPanel(), index, xOffset, yOffset);
    }

    private void lockFunctionSignatureLines() {
        ClangLine leftLine = this.getClangLine(this.leftLines, 0);
        ClangLine rightLine = this.getClangLine(this.rightLines, 0);
        ClangLine leftFunctionLine = this.findFunctionSignatureLine(this.leftLines);
        ClangLine rightFunctionLine = this.findFunctionSignatureLine(this.rightLines);
        if (leftFunctionLine != null && rightFunctionLine != null) {
            leftLine = leftFunctionLine;
            rightLine = rightFunctionLine;
        }
        if (leftLine != null && rightLine != null) {
            this.setLockedLineNumbers(leftLine.getLineNumber(), rightLine.getLineNumber());
            this.lockLines(new BigInteger[]{BigInteger.valueOf(this.lockedLeftLineNumber), BigInteger.valueOf(this.lockedRightLineNumber)});
        }
    }

    private ClangLine findFunctionSignatureLine(List<ClangLine> lines) {
        for (ClangLine clangLine : lines) {
            int numTokens = clangLine.getNumTokens();
            for (int i = 0; i < numTokens; ++i) {
                ClangToken token = clangLine.getToken(i);
                if (!(token instanceof ClangFuncNameToken)) continue;
                return clangLine;
            }
        }
        return null;
    }

    private ClangLine getClangLine(List<ClangLine> lines, int lineNumber) {
        if (lines.isEmpty()) {
            return null;
        }
        int size = lines.size();
        if (lineNumber < 1) {
            lineNumber = 1;
        }
        if (lineNumber > size) {
            lineNumber = size;
        }
        return lines.get(lineNumber - 1);
    }

    private void setLockedLineNumbers(int leftLineNumber, int rightLineNumber) {
        this.lockedLeftLineNumber = leftLineNumber;
        this.lockedRightLineNumber = rightLineNumber;
    }

    private boolean searchRightForPair(int rightLineNumber) {
        if (this.setLeftFromRight(rightLineNumber)) {
            return true;
        }
        int lastLine = this.rightLines.size();
        int previous = rightLineNumber - 1;
        int next = rightLineNumber + 1;
        while (previous > 0 || next <= lastLine) {
            if (previous > 0) {
                if (this.setLeftFromRight(previous)) {
                    return true;
                }
                --previous;
            }
            if (next > lastLine) continue;
            if (this.setLeftFromRight(next)) {
                return true;
            }
            ++next;
        }
        return false;
    }

    private boolean setLeftFromRight(int rightLineNumber) {
        Integer leftLineNumber = (Integer)this.leftToRightLineNumberPairing.getKey((Object)rightLineNumber);
        if (leftLineNumber == null) {
            return false;
        }
        this.setLockedLineNumbers(leftLineNumber, rightLineNumber);
        return true;
    }

    private boolean searchLeftForPair(int leftLineNumber) {
        if (this.setRightFromLeft(leftLineNumber)) {
            return true;
        }
        int lastLine = this.leftLines.size();
        int previous = leftLineNumber - 1;
        int next = leftLineNumber + 1;
        while (previous > 0 || next <= lastLine) {
            if (previous > 0) {
                if (this.setRightFromLeft(previous)) {
                    return true;
                }
                --previous;
            }
            if (next > lastLine) continue;
            if (this.setRightFromLeft(next)) {
                return true;
            }
            ++next;
        }
        return false;
    }

    private boolean setRightFromLeft(int leftLineNumber) {
        Integer rightLineNumber = (Integer)this.leftToRightLineNumberPairing.get((Object)leftLineNumber);
        if (rightLineNumber == null) {
            return false;
        }
        this.setLockedLineNumbers(leftLineNumber, rightLineNumber);
        return true;
    }
}

