/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.model.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorizontalCompaction<V> {
    private static final Logger log = LoggerFactory.getLogger(HorizontalCompaction.class);
    protected LV<V>[][] layers;
    protected Map<LV<V>, LV<V>> rootMap;
    protected Map<LV<V>, LV<V>> alignMap;
    protected int deltaX;
    protected int deltaY;
    protected Map<LV<V>, LV<V>> sink = new HashMap<LV<V>, LV<V>>();
    protected Map<LV<V>, Integer> shift = new HashMap<LV<V>, Integer>();
    protected Map<LV<V>, Integer> x = new HashMap<LV<V>, Integer>();
    protected Map<LV<V>, Integer> y = new HashMap<LV<V>, Integer>();
    Consumer<LV<V>> methodReference = this::placeBlock;

    public HorizontalCompaction(LV<V>[][] layers, Map<LV<V>, LV<V>> rootMap, Map<LV<V>, LV<V>> alignMap, int deltaX, int deltaY) {
        this.layers = layers;
        this.rootMap = rootMap;
        this.alignMap = alignMap;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        Arrays.stream(layers).flatMap(Arrays::stream).forEach(v -> {
            this.sink.put((LV<LV>)v, (LV<LV>)v);
            this.shift.put((LV<Integer>)v, Integer.MAX_VALUE);
        });
    }

    public Point getPoint(LV<V> v) {
        return Point.of(this.x.get(v).intValue(), this.y.get(v).intValue());
    }

    public void horizontalCompaction() {
        Arrays.stream(this.layers).flatMap(Arrays::stream).filter(v -> this.root((LV<V>)v) == v).forEach(this.methodReference);
        for (int i = 0; i < this.layers.length; ++i) {
            LV<V>[] list;
            for (LV<V> v2 : list = this.layers[i]) {
                this.x(v2, this.x(this.root(v2)));
                this.y(v2, i * this.deltaY);
                if (this.shift(this.sink(this.root(v2))) >= Integer.MAX_VALUE) continue;
                this.x(v2, this.x(v2) + this.shift(this.sink(this.root(v2))));
            }
        }
    }

    protected void placeBlock(LV<V> v) {
        if (!this.x.containsKey(v)) {
            this.x(v, 0);
            LV<V> w = v;
            do {
                if (!this.hasPredecessor(w)) continue;
                LV<V> u = this.root(this.pred(w));
                this.placeBlock(u);
                if (this.sink(v) == v) {
                    this.sink(v, this.sink(u));
                }
                if (this.sink(v) != this.sink(u)) {
                    this.shift(this.sink(u), Math.min(this.shift(this.sink(u)), this.x(v) - this.x(u) - this.deltaX));
                    continue;
                }
                int plus = this.deltaX * (this.pos(v) - this.idx(v));
                this.x(v, Math.max(this.x(v), this.x(u) + Math.max(this.deltaX, plus)));
            } while ((w = this.align(w)) != v);
        }
    }

    protected boolean hasPredecessor(LV<V> v) {
        return v.getIndex() > 0;
    }

    protected int pos(LV<V> v) {
        return v.getIndex();
    }

    protected int idx(LV<V> v) {
        return v.getIndex();
    }

    protected LV<V> sink(LV<V> v) {
        return this.sink.get(v);
    }

    protected void sink(LV<V> k, LV<V> v) {
        this.sink.put(k, v);
    }

    protected int shift(LV<V> v) {
        return this.shift.get(v);
    }

    protected void shift(LV<V> k, int v) {
        this.shift.put(k, v);
    }

    protected int x(LV<V> v) {
        return this.x.get(v);
    }

    protected void x(LV<V> v, int d) {
        this.x.put(v, d);
    }

    protected int y(LV<V> v) {
        return this.y.get(v);
    }

    protected void y(LV<V> v, int d) {
        this.y.put(v, d);
    }

    protected LV<V> root(LV<V> v) {
        return this.rootMap.get(v);
    }

    protected void root(LV<V> k, LV<V> v) {
        this.rootMap.put(k, v);
    }

    protected LV<V> align(LV<V> v) {
        return this.alignMap.get(v);
    }

    protected void align(LV<V> k, LV<V> v) {
        this.alignMap.put(k, v);
    }

    protected LV<V> pred(LV<V> v) {
        int layerOfV = v.getRank();
        int indexOfV = v.getIndex();
        if (indexOfV < 1) {
            return null;
        }
        LV<V>[] list = this.layers[layerOfV];
        return list[indexOfV - 1];
    }

    public Map<LV<V>, LV<V>> getSink() {
        return this.sink;
    }

    public Map<LV<V>, Integer> getShift() {
        return this.shift;
    }

    public Map<LV<V>, Integer> getX() {
        return this.x;
    }

    public Map<LV<V>, Integer> getY() {
        return this.y;
    }
}

