/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.renderer;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.layout.ObservableCachingLayout;
import edu.uci.ics.jung.visualization.renderers.BasicRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.edge.BasicEdgeLabelRenderer;
import ghidra.graph.viewer.layout.Column;
import ghidra.graph.viewer.layout.LayoutLocationMap;
import ghidra.graph.viewer.layout.Row;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VisualGraphRenderer<V extends VisualVertex, E extends VisualEdge<V>>
extends BasicRenderer<V, E> {
    public static Map<VisualGraphLayout<?, ?>, LayoutLocationMap<?, ?>> DEBUG_ROW_COL_MAP = new HashMap();
    private Renderer.EdgeLabel<V, E> edgeLabelRenderer = new BasicEdgeLabelRenderer();

    public VisualGraphRenderer(Renderer.EdgeLabel<V, E> edgeLabelRenderer) {
        this.edgeLabelRenderer = edgeLabelRenderer;
    }

    public void render(RenderContext<V, E> renderContext, Layout<V, E> layout) {
        try {
            this.mimickSuperPaintingWithoutPaintingSelectedVertices(renderContext, layout);
        }
        catch (Exception e) {
            if (e instanceof ConcurrentModificationException) {
                return;
            }
            throw e;
        }
    }

    private void mimickSuperPaintingWithoutPaintingSelectedVertices(RenderContext<V, E> renderContext, Layout<V, E> layout) {
        for (VisualEdge e : layout.getGraph().getEdges()) {
            this.renderEdge(renderContext, layout, e);
            this.renderEdgeLabel(renderContext, layout, (E)e);
        }
        Collection defaultVertices = layout.getGraph().getVertices();
        List<VisualVertex> vertices = GraphViewerUtils.createCollectionWithZOrderBySelection(defaultVertices);
        for (VisualVertex v : vertices) {
            this.renderVertex(renderContext, layout, v);
            this.renderVertexLabel(renderContext, layout, (V)v);
        }
        this.paintLayoutGridCells(renderContext, layout);
    }

    public void renderVertexLabel(RenderContext<V, E> rc, Layout<V, E> layout, V v) {
        String label = (String)rc.getVertexLabelTransformer().apply(v);
        if (label == null) {
            return;
        }
        super.renderVertexLabel(rc, layout, v);
    }

    public void renderEdgeLabel(RenderContext<V, E> rc, Layout<V, E> layout, E e) {
        if (this.edgeLabelRenderer == null) {
            return;
        }
        Function xform = rc.getEdgeLabelTransformer();
        String label = (String)xform.apply(e);
        if (label == null) {
            return;
        }
        this.edgeLabelRenderer.labelEdge(rc, layout, e, (String)xform.apply(e));
    }

    private void paintLayoutGridCells(RenderContext<V, E> renderContext, Layout<V, E> layout) {
        LayoutLocationMap<?, ?> locationMap;
        Layout key = layout;
        if (layout instanceof ObservableCachingLayout) {
            key = ((ObservableCachingLayout)layout).getDelegate();
        }
        if ((locationMap = DEBUG_ROW_COL_MAP.get(key)) == null) {
            return;
        }
        int rowCount = locationMap.getRowCount();
        if (rowCount == 0) {
            return;
        }
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Color originalColor = g.getColor();
        GColor gridColor = GThemeDefaults.Colors.Palette.ORANGE;
        GColor textColor = GThemeDefaults.Colors.Palette.BLACK;
        boolean isCondensed = locationMap.isCondensed();
        Row<?> lastRow = locationMap.lastRow();
        Column lastColumn = locationMap.lastColumn();
        if (lastRow == null || lastColumn == null) {
            return;
        }
        int width = lastColumn.x + lastColumn.getPaddedWidth(isCondensed);
        int height = lastRow.y + lastRow.getPaddedHeight(isCondensed);
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        for (Row<?> row : locationMap.rows()) {
            Point2D start = new Point2D.Double(0.0, row.y);
            start = transformer.transform(Layer.LAYOUT, start);
            g.setColor((Color)textColor);
            g.drawString(Integer.toString(row.index), (float)start.getX() - 20.0f, (float)(start.getY() + 5.0));
            Point2D end = new Point2D.Double(width, row.y);
            end = transformer.transform(Layer.LAYOUT, end);
            g.setColor((Color)gridColor);
            g.drawLine((int)start.getX(), (int)start.getY(), (int)end.getX(), (int)end.getY());
        }
        Point2D start = new Point2D.Double(0.0, lastRow.y + lastRow.getPaddedHeight(isCondensed));
        start = transformer.transform(Layer.LAYOUT, start);
        Point2D end = new Point2D.Double(width, lastRow.y + lastRow.getPaddedHeight(isCondensed));
        end = transformer.transform(Layer.LAYOUT, end);
        g.drawLine((int)start.getX(), (int)start.getY(), (int)end.getX(), (int)end.getY());
        for (Column column : locationMap.columns()) {
            start = new Point2D.Double(column.x, 0.0);
            start = transformer.transform(Layer.LAYOUT, start);
            g.setColor((Color)textColor);
            g.drawString(Integer.toString(column.index), (float)start.getX() - 5.0f, (float)(start.getY() - 10.0));
            end = new Point2D.Double(column.x, height);
            end = transformer.transform(Layer.LAYOUT, end);
            g.setColor((Color)gridColor);
            g.drawLine((int)start.getX(), (int)start.getY(), (int)end.getX(), (int)end.getY());
        }
        start = new Point2D.Double(lastColumn.x + lastColumn.getPaddedWidth(isCondensed), 0.0);
        start = transformer.transform(Layer.LAYOUT, start);
        end = new Point2D.Double(lastColumn.x + lastColumn.getPaddedWidth(isCondensed), height);
        end = transformer.transform(Layer.LAYOUT, end);
        g.drawLine((int)start.getX(), (int)start.getY(), (int)end.getX(), (int)end.getY());
        g.setColor(originalColor);
    }
}

