/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.PropertyLoader;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.control.Modifiers;
import org.jungrapht.visualization.control.MultiSelectionStrategy;
import org.jungrapht.visualization.control.TransformSupport;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.selection.MutableSelectedState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionSelectingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    private static final Logger log = LoggerFactory.getLogger(RegionSelectingGraphMousePlugin.class);
    protected boolean locked;
    protected Shape viewRectangle;
    protected Shape layoutTargetShape;
    protected VisualizationServer.Paintable lensPaintable;
    protected Color lensColor;
    protected Point2D deltaDown;
    protected MultiSelectionStrategy multiSelectionStrategy;
    protected int singleSelectionMask;
    protected int toggleSingleSelectionMask;
    protected int regionSelectionMask;
    protected int toggleRegionSelectionMask;
    protected int regionSelectionCompleteMask;
    protected int toggleRegionSelectionCompleteMask;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public RegionSelectingGraphMousePlugin(Builder<V, E, ?, ?> builder) {
        this(builder.regionSelectionMask, builder.toggleRegionSelectionMask, builder.regionSelectionCompleteMask, builder.toggleRegionSelectionCompleteMask);
    }

    public RegionSelectingGraphMousePlugin() {
        this(RegionSelectingGraphMousePlugin.builder());
    }

    protected RegionSelectingGraphMousePlugin(int regionSelectionMask, int toggleRegionSelectionMask, int regionSelectionCompleteMask, int toggleRegionSelectionCompleteMask) {
        this.layoutTargetShape = this.viewRectangle = new Rectangle2D.Float();
        this.lensColor = Color.cyan;
        this.regionSelectionMask = regionSelectionMask;
        this.toggleRegionSelectionMask = toggleRegionSelectionMask;
        this.regionSelectionCompleteMask = regionSelectionCompleteMask;
        this.toggleRegionSelectionCompleteMask = toggleRegionSelectionCompleteMask;
        this.lensPaintable = new LensPaintable();
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    public Color getLensColor() {
        return this.lensColor;
    }

    public void setLensColor(Color lensColor) {
        this.lensColor = lensColor;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        log.trace("pressed");
        if (e.getModifiersEx() == this.regionSelectionMask || e.getModifiersEx() == this.toggleRegionSelectionMask) {
            this.down = e.getPoint();
            log.trace("mouse pick at screen coords {}", (Object)e.getPoint());
            this.deltaDown = this.down;
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            this.multiSelectionStrategy = vv.getMultiSelectionStrategySupplier().get();
            TransformSupport transformSupport = vv.getTransformSupport();
            this.viewRectangle = this.multiSelectionStrategy.getInitialShape(e.getPoint());
            MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
            this.updatePickingTargets(vv, multiLayerTransformer, this.down, this.down);
            vv.addPostRenderPaintable(this.lensPaintable);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Collection<V> picked;
        log.trace("released");
        Point out = e.getPoint();
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        if (e.getModifiersEx() == this.toggleRegionSelectionCompleteMask) {
            if (this.down != null && this.multiSelectionMayProceed(this.layoutTargetShape.getBounds2D())) {
                Collection<V> collection = this.toggleSelectionForContainedVertices(vv, this.layoutTargetShape);
            }
        } else if (e.getModifiersEx() == this.regionSelectionCompleteMask && this.down != null && this.multiSelectionMayProceed(this.layoutTargetShape.getBounds2D()) && (picked = this.pickContainedVertices(vv, this.layoutTargetShape)).isEmpty()) {
            vv.getSelectedVertexState().clear();
            vv.getSelectedEdgeState().clear();
        }
        log.trace("down:{} out:{}", (Object)this.down, (Object)out);
        this.down = null;
        this.layoutTargetShape = multiLayerTransformer.inverseTransform(this.viewRectangle);
        vv.removePostRenderPaintable(this.lensPaintable);
        vv.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        log.trace("dragged " + this.viewRectangle);
        if (e.getModifiersEx() == this.regionSelectionMask || e.getModifiersEx() == this.toggleRegionSelectionMask) {
            log.trace("mouseDragged");
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            if (!this.locked) {
                MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
                Point p = e.getPoint();
                log.trace("view p for drag event is {}", (Object)p);
                log.trace("down is {}", (Object)this.down);
                if (this.down != null) {
                    Point out = e.getPoint();
                    this.multiSelectionStrategy.updateShape(this.down, out);
                    this.layoutTargetShape = multiLayerTransformer.inverseTransform(this.viewRectangle);
                }
                vv.repaint();
            }
        }
    }

    private boolean multiSelectionMayProceed(Rectangle2D targetShape) {
        return !targetShape.isEmpty();
    }

    protected Point2D inverseTransform(VisualizationViewer<V, E> vv, Point2D p) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        return multiLayerTransformer.inverseTransform(p);
    }

    protected Shape transform(VisualizationViewer<V, E> vv, Shape shape) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        return multiLayerTransformer.transform(shape);
    }

    protected void updatePickingTargets(VisualizationViewer vv, MultiLayerTransformer multiLayerTransformer, Point2D down, Point2D out) {
        this.multiSelectionStrategy.updateShape(down, down);
        this.layoutTargetShape = multiLayerTransformer.inverseTransform(this.viewRectangle);
    }

    protected Collection<V> pickContainedVertices(VisualizationViewer<V, E> vv, Shape pickTarget) {
        MutableSelectedState selectedVertexState = vv.getSelectedVertexState();
        GraphElementAccessor pickSupport = vv.getPickSupport();
        LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
        Collection picked = pickSupport.getVertices(layoutModel, pickTarget);
        selectedVertexState.clear();
        selectedVertexState.select(picked);
        return picked;
    }

    protected Collection<V> toggleSelectionForContainedVertices(VisualizationViewer<V, E> vv, Shape pickTarget) {
        MutableSelectedState selectedVertexState = vv.getSelectedVertexState();
        GraphElementAccessor pickSupport = vv.getPickSupport();
        LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
        Collection picked = pickSupport.getVertices(layoutModel, pickTarget);
        picked.forEach(v -> {
            boolean selected = selectedVertexState.isSelected(v);
            if (selected) {
                selectedVertexState.deselect(v);
            } else {
                selectedVertexState.select(v);
            }
        });
        return picked.stream().filter(selectedVertexState::isSelected).collect(Collectors.toSet());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "\n regionSelectionMask :" + Modifiers.maskStrings.get(this.regionSelectionMask) + "\n toggleRegionSelectionMask:" + Modifiers.maskStrings.get(this.toggleRegionSelectionMask) + "\n regionSelectionCompleteMask:" + Modifiers.maskStrings.get(this.regionSelectionCompleteMask) + "\n toggleRegionSelectionCompleteMask:" + Modifiers.maskStrings.get(this.toggleRegionSelectionCompleteMask);
    }

    static {
        PropertyLoader.load();
    }

    public static class Builder<V, E, T extends RegionSelectingGraphMousePlugin, B extends Builder<V, E, T, B>> {
        protected int regionSelectionMask = Modifiers.masks.get(System.getProperty("jungrapht.regionSelectionMask", "MB1_MENU"));
        protected int toggleRegionSelectionMask = Modifiers.masks.get(System.getProperty("jungrapht.toggleRegionSelectionMask", "MB1_SHIFT_MENU"));
        protected int regionSelectionCompleteMask = Modifiers.masks.get(System.getProperty("jungrapht.regionSelectionCompleteMask", "MENU"));
        protected int toggleRegionSelectionCompleteMask = Modifiers.masks.get(System.getProperty("jungrapht.toggleRegionSelectionCompleteMask", "SHIFT_MENU"));

        public B self() {
            return (B)this;
        }

        public B regionSelectionMask(int regionSelectionMask) {
            this.regionSelectionMask = regionSelectionMask;
            return this.self();
        }

        public B toggleRegionSelectionMask(int toggleRegionSelectionMask) {
            this.toggleRegionSelectionMask = toggleRegionSelectionMask;
            return this.self();
        }

        public B regionSelectionCompleteMask(int regionSelectionCompleteMask) {
            this.regionSelectionCompleteMask = regionSelectionCompleteMask;
            return this.self();
        }

        public B toggleRegionSelectionCompleteMask(int toggleRegionSelectionCompleteMask) {
            this.toggleRegionSelectionCompleteMask = toggleRegionSelectionCompleteMask;
            return this.self();
        }

        public T build() {
            return (T)new RegionSelectingGraphMousePlugin(this);
        }
    }

    class LensPaintable
    implements VisualizationServer.Paintable {
        LensPaintable() {
        }

        @Override
        public void paint(Graphics g) {
            Color oldColor = g.getColor();
            g.setColor(RegionSelectingGraphMousePlugin.this.lensColor);
            ((Graphics2D)g).draw(RegionSelectingGraphMousePlugin.this.viewRectangle);
            g.setColor(oldColor);
        }

        @Override
        public boolean useTransform() {
            return false;
        }
    }
}

