/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.extend;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfProgramHeader;
import ghidra.app.util.bin.format.elf.ElfProgramHeaderType;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfSectionHeaderType;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.extend.ElfExtension;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Program;

public class HCS12X_ElfExtension
extends ElfExtension {
    public static final ElfProgramHeaderType PT_HCS12_ARCHEXT = new ElfProgramHeaderType(0x70000000, "PT_HCS12X_ARCHEXT", "HCS12X extension");
    public static final ElfSectionHeaderType SHT_HCS12_ATTRIBUTES = new ElfSectionHeaderType(0x70000003, "SHT_AHCS12_ATTRIBUTES", "Attribute section");

    public boolean canHandle(ElfHeader elf) {
        return elf.e_machine() == 53;
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        Language language = elfLoadHelper.getProgram().getLanguage();
        boolean isSpecialHCSMemory = this.isHCS12(language) || this.isHCS12X(language);
        return this.canHandle(elfLoadHelper.getElfHeader()) && isSpecialHCSMemory;
    }

    public String getDataTypeSuffix() {
        return "_HCS12";
    }

    private boolean isHCS12(Language language) {
        return "HCS-12".equals(language.getProcessor().toString());
    }

    private boolean isHCS12X(Language language) {
        return "HCS-12X".equals(language.getProcessor().toString());
    }

    public Address getPreferredSegmentAddress(ElfLoadHelper elfLoadHelper, ElfProgramHeader elfProgramHeader) {
        AddressSpace space = this.getPreferredSegmentAddressSpace(elfLoadHelper, elfProgramHeader);
        Program program = elfLoadHelper.getProgram();
        long addrWordOffset = elfProgramHeader.getVirtualAddress();
        if (space == program.getAddressFactory().getDefaultAddressSpace()) {
            addrWordOffset += elfLoadHelper.getImageBaseWordAdjustmentOffset();
        }
        addrWordOffset = this.hcs12TranslatePagedAddress(elfLoadHelper, addrWordOffset);
        return space.getTruncatedAddress(addrWordOffset, true);
    }

    public Address getPreferredSectionAddress(ElfLoadHelper elfLoadHelper, ElfSectionHeader elfSectionHeader) {
        Program program = elfLoadHelper.getProgram();
        AddressSpace space = this.getPreferredSectionAddressSpace(elfLoadHelper, elfSectionHeader);
        long addrWordOffset = elfSectionHeader.getAddress();
        if (space == program.getAddressFactory().getDefaultAddressSpace()) {
            addrWordOffset += elfLoadHelper.getImageBaseWordAdjustmentOffset();
        }
        addrWordOffset = this.hcs12TranslatePagedAddress(elfLoadHelper, addrWordOffset);
        return space.getTruncatedAddress(addrWordOffset, true);
    }

    private long hcs12TranslatePagedAddress(ElfLoadHelper elfLoaderHelper, long addrWordOffset) {
        Language lang = elfLoaderHelper.getProgram().getLanguage();
        if (this.isHCS12X(lang)) {
            return this.hcs12xTranslatePagedAddress(addrWordOffset);
        }
        long page = addrWordOffset >> 16 & 0xFFL;
        long addr = addrWordOffset & 0xFFFFL;
        if ((addr & 0xC000L) == 0L) {
            return 0xF4000L | addr & 0x3FFFL;
        }
        if ((addr & 0xC000L) == 16384L) {
            return 0xF8000L | addr & 0x3FFFL;
        }
        if ((addr & 0xC000L) == 32768L) {
            return page << 14 | addr & 0x3FFFL;
        }
        if ((addr & 0xC000L) == 49152L) {
            return 0xFC000L | addr & 0x3FFFL;
        }
        return addr;
    }

    private long hcs12xTranslatePagedAddress(long addrWordOffset) {
        long page = addrWordOffset >> 16 & 0xFFL;
        long addr = addrWordOffset & 0xFFFFL;
        if ((addr & 0xFC00L) == 0L) {
            return addr;
        }
        if ((addr & 0xFC00L) == 2048L) {
            return 0x100000L | (page << 10 | addr & 0x3FFL);
        }
        if ((addr & 0xFC00L) == 3072L) {
            return 0x13FC00L | addr & 0x3FFL;
        }
        if ((addr & 0xF000L) == 4096L) {
            return page << 12 | addr & 0xFFFL;
        }
        if ((addr & 0xF000L) == 8192L) {
            return 0xFE000L | addr & 0xFFFL;
        }
        if ((addr & 0xF000L) == 12288L) {
            return 0xFF000L | addr & 0xFFFL;
        }
        if ((addr & 0xC000L) == 16384L) {
            return 0x7F4000L | addr & 0x3FFFL;
        }
        if ((addr & 0xC000L) == 32768L) {
            return 0x400000L | page << 14 | addr & 0x3FFFL;
        }
        if ((addr & 0xC000L) == 49152L) {
            return 0x7FC000L | addr & 0x3FFFL;
        }
        return addr;
    }

    public Address evaluateElfSymbol(ElfLoadHelper elfLoadHelper, ElfSymbol elfSymbol, Address address, boolean isExternal) {
        if (isExternal) {
            return address;
        }
        long laddr = address.getOffset();
        laddr = this.hcs12TranslatePagedAddress(elfLoadHelper, laddr);
        Address mappedAddr = address.getNewAddress(laddr);
        return mappedAddr;
    }
}

