/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.mcast.discovery;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilterRuleList;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactory;
import org.rzo.netty.mcast.MulticastEndpoint;
import org.rzo.netty.mcast.discovery.DiscoveryListener;

public class DiscoveryClient
extends MulticastEndpoint {
    private String name;
    private Set<String> hosts = Collections.synchronizedSet(new HashSet());
    private volatile boolean stop = false;
    private Set<DiscoveryListener> listeners = Collections.synchronizedSet(new HashSet());
    private static Executor executor = Executors.newCachedThreadPool();
    private IpFilterRuleList firewall;

    public void init() throws Exception {
        ChannelPipelineFactory factory = new ChannelPipelineFactory(){

            @Override
            public ChannelPipelineFactory.HandlerList getPipeline() throws Exception {
                ChannelPipelineFactory.HandlerList pipeline = new ChannelPipelineFactory.HandlerList();
                pipeline.addLast("discoveryClient", (ChannelHandler)new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object e) throws Exception {
                        try {
                            String response = DiscoveryClient.this.getStringMessage((ByteBuf)((DatagramPacket)e).content());
                            InetSocketAddress remoteAddress = (InetSocketAddress)((DatagramPacket)e).sender();
                            if (DiscoveryClient.this.debug && DiscoveryClient.this.logger != null) {
                                DiscoveryClient.this.logger.info("discoveryClient messageReceived " + response + "/" + remoteAddress);
                            }
                            if (response == null) {
                                return;
                            }
                            String[] resp = response.split("&");
                            if (resp.length == 3) {
                                String remoteName = resp[0];
                                if (!DiscoveryClient.this.name.equals(remoteName)) {
                                    return;
                                }
                                if (!DiscoveryClient.this.validate((ByteBuf)((DatagramPacket)e).content(), remoteAddress)) {
                                    return;
                                }
                                String host = resp[1];
                                InetAddress.getByName(host);
                                int port = Integer.parseInt(resp[2]);
                                if (!DiscoveryClient.this.hosts.contains(response)) {
                                    DiscoveryClient.this.hosts.add(response);
                                    for (DiscoveryListener listener : DiscoveryClient.this.listeners) {
                                        listener.newHost(DiscoveryClient.this.name, response);
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            Constants.ahessianLogger.warn("", (Throwable)ex);
                        }
                    }
                });
                return pipeline;
            }
        };
        super.init(factory);
    }

    public void start() throws Exception {
        this.stop = false;
        this.discoverServices();
    }

    private void discoverServices() throws Exception {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!DiscoveryClient.this.stop) {
                    try {
                        DiscoveryClient.this.send(Unpooled.copiedBuffer((byte[])DiscoveryClient.this.name.getBytes()));
                    }
                    catch (Exception e) {
                        Constants.ahessianLogger.warn("", (Throwable)e);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Constants.ahessianLogger.warn("", (Throwable)e);
                    }
                }
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void stop() {
        this.stop = true;
    }

    public void addListener(DiscoveryListener listener) {
        this.listeners.add(listener);
    }

    public void removeHost(String host) {
        this.hosts.remove(host);
    }

    private boolean validate(ByteBuf e, SocketAddress socketAddress) {
        if (this.firewall == null) {
            return true;
        }
        Iterator iterator = this.firewall.iterator();
        IpFilterRule ipFilterRule = null;
        while (iterator.hasNext()) {
            InetAddress inetAddress = ((InetSocketAddress)socketAddress).getAddress();
            ipFilterRule = (IpFilterRule)iterator.next();
            if (!ipFilterRule.contains(inetAddress)) continue;
            return ipFilterRule.isAllowRule();
        }
        return true;
    }

    public void setIpSet(IpFilterRuleList ipSet) {
        this.firewall = ipSet;
    }

    public static void main(String[] args) throws Exception {
        final DiscoveryClient client = new DiscoveryClient();
        client.setName("testService");
        client.addListener(new DiscoveryListener(){

            @Override
            public void newHost(String name, String host) {
                System.out.println("found service " + host + " " + name);
                client.stop();
            }
        });
        client.init();
        client.start();
    }
}

