/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.bootstrap;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.LinkedList;
import org.rzo.netty.ahessian.log.OutLogger;

public abstract class ChannelPipelineFactory<C extends Channel>
extends ChannelInitializer<C> {
    private volatile boolean _debug = false;
    EventExecutorGroup _group;

    public ChannelPipelineFactory(EventExecutorGroup executor) {
        this._group = executor;
    }

    public ChannelPipelineFactory() {
    }

    public EventExecutorGroup getGroup() {
        return this._group;
    }

    public ChannelPipelineFactory<C> debug() {
        this._debug = true;
        return this;
    }

    public static HandlerList handlerList(ChannelHandler ... handlers) {
        HandlerList result = new HandlerList();
        int i = 0;
        for (ChannelHandler handler : handlers) {
            result.addLast(handler.getClass().getSimpleName() + "_" + i, handler);
        }
        return result;
    }

    protected void initChannel(C ch) throws Exception {
        if (this._debug) {
            ch.pipeline().addFirst("xlogger", (ChannelHandler)new OutLogger("first"));
        }
        HandlerList list = this.getPipeline();
        for (HandlerEntry entry : list) {
            if (entry.getGroup() == null) {
                ch.pipeline().addLast(entry.getKey(), entry.getValue());
                continue;
            }
            ch.pipeline().addLast(entry.getGroup(), entry.getKey(), entry.getValue());
        }
    }

    public abstract HandlerList getPipeline() throws Exception;

    public static class HandlerEntry {
        ChannelHandler _value;
        String _key;
        EventExecutorGroup _group;

        public HandlerEntry(String name, ChannelHandler handler) {
            this(name, handler, null);
        }

        public HandlerEntry(String name, ChannelHandler handler, EventExecutorGroup group) {
            this._value = handler;
            this._key = name;
            this._group = group;
        }

        public String getKey() {
            return this._key;
        }

        public ChannelHandler getValue() {
            return this._value;
        }

        public EventExecutorGroup getGroup() {
            return this._group;
        }
    }

    public static class HandlerList
    extends LinkedList<HandlerEntry> {
        Channel _channel;

        public void addLast(String name, ChannelHandler handler) {
            super.addLast(new HandlerEntry(name, handler));
        }

        public void addLast(String name, ChannelHandler handler, EventExecutorGroup group) {
            super.addLast(new HandlerEntry(name, handler, group));
        }

        public void mixin(ChannelHandlerContext ctx) {
            ChannelPipeline pipeline = ctx.pipeline();
            for (HandlerEntry entry : this) {
                pipeline.addLast(entry.getKey(), entry.getValue());
            }
            this._channel = ctx.channel();
        }

        public boolean hasChannel() {
            return this._channel != null && this._channel.isActive();
        }

        public void close() {
            if (this._channel != null) {
                try {
                    this._channel.close().sync();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

