/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.byteviewer.FileByteBlock;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockSelection;
import ghidra.app.plugin.core.format.ByteBlockSet;
import ghidra.program.model.address.AddressSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

class FileByteBlockSet
implements ByteBlockSet {
    private FileByteBlock block;
    private List<EditInfo> changeList;

    FileByteBlockSet(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        fis.read(bytes);
        fis.close();
        this.block = new FileByteBlock(bytes);
        this.changeList = new ArrayList<EditInfo>();
    }

    @Override
    public void dispose() {
        this.block = null;
        this.changeList = null;
    }

    public Object getActiveObject(ByteBlock activeBlock, int offset) {
        return null;
    }

    @Override
    public ByteBlock[] getBlocks() {
        return new ByteBlock[]{this.block};
    }

    @Override
    public ProgramLocationPluginEvent getPluginEvent(String source, ByteBlock activeBlock, BigInteger offset, int column) {
        return null;
    }

    @Override
    public ProgramSelectionPluginEvent getPluginEvent(String source, ByteBlockSelection selection) {
        return null;
    }

    @Override
    public boolean isChanged(ByteBlock activeBlock, BigInteger bigIndex, int length) {
        int index = bigIndex.intValue();
        for (int i = 0; i < length; ++i) {
            if (!this.contains(index + i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void notifyByteEditing(ByteBlock activeBlock, BigInteger bigIndex, byte[] oldValue, byte[] newValue) {
        int index = bigIndex.intValue();
        for (int i = 0; i < oldValue.length; ++i) {
            if (oldValue[i] == newValue[i]) continue;
            EditInfo newedit = new EditInfo(index + i);
            this.changeList.add(newedit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(String pathname) throws IOException {
        byte[] buf = this.block.getBytes();
        try (FileOutputStream fos = new FileOutputStream(new File(pathname));){
            fos.write(buf);
        }
        this.block = new FileByteBlock(buf);
        this.changeList = new ArrayList<EditInfo>();
    }

    private boolean contains(int index) {
        for (int i = 0; i < this.changeList.size(); ++i) {
            EditInfo info = this.changeList.get(i);
            if (index != info.index) continue;
            return true;
        }
        return false;
    }

    @Override
    public AddressSet getAddressSet(ByteBlockSelection selection) {
        return null;
    }

    private class EditInfo {
        private int index;

        EditInfo(int index) {
            this.index = index;
        }
    }
}

