/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.rtti;

import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.rtti.AbstractCreateRttiDataModel;
import ghidra.app.cmd.data.rtti.Rtti1Model;
import ghidra.app.cmd.data.rtti.Rtti2Model;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.IBO32DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.Msg;
import java.util.List;

public class Rtti3Model
extends AbstractCreateRttiDataModel {
    public static final String DATA_TYPE_NAME = "RTTIClassHierarchyDescriptor";
    private static String STRUCTURE_NAME = "_s__RTTIClassHierarchyDescriptor";
    private static final int SIGNATURE_ORDINAL = 0;
    private static final int ATTRIBUTES_ORDINAL = 1;
    private static final int BASE_ARRAY_PTR_ORDINAL = 3;
    private static final int NUM_BASES_OFFSET = 8;
    private static final int BASE_ARRAY_PTR_OFFSET = 12;
    private static final long MAX_RTTI_1_COUNT = 1000L;
    private DataType dataType;
    private Rtti2Model rtti2Model;

    public Rtti3Model(Program program, Address rtti3Address, DataValidationOptions validationOptions) {
        super(program, rtti3Address, validationOptions);
    }

    @Override
    public String getName() {
        return DATA_TYPE_NAME;
    }

    @Override
    protected void validateModelSpecificInfo() throws InvalidDataTypeException {
        Program program = this.getProgram();
        int rtti1Count = this.getRtti1Count();
        if (rtti1Count < 1 || (long)rtti1Count > 1000L) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't have a valid RTTIBaseClassDescriptor count.");
        }
        boolean validateReferredToData = this.validationOptions.shouldValidateReferredToData();
        Address rtti2Address = this.getRtti2Address();
        if (rtti2Address == null) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't refer to a valid location for the RTTIBaseClassArray.");
        }
        this.rtti2Model = new Rtti2Model(program, rtti1Count, rtti2Address, this.validationOptions);
        if (validateReferredToData) {
            this.rtti2Model.validate();
        } else if (!this.rtti2Model.isLoadedAndInitializedAddress()) {
            throw new InvalidDataTypeException("Data referencing " + this.rtti2Model.getName() + " data type isn't a loaded and initialized address " + rtti2Address + ".");
        }
    }

    public static DataType getDataType(Program program) {
        DataType rtti3Dt = Rtti3Model.getSimpleDataType(program);
        DataType rtti1Dt = Rtti1Model.getSimpleDataType(program);
        Rtti3Model.setRtti1DataType(rtti3Dt, program, rtti1Dt);
        Rtti1Model.setRtti3DataType(rtti1Dt, program, rtti3Dt);
        return MSDataTypeUtils.getMatchingDataType((Program)program, (DataType)rtti3Dt);
    }

    static void setRtti1DataType(DataType rtti3Dt, Program program, DataType rtti1Dt) {
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        boolean is64Bit = MSDataTypeUtils.is64Bit((Program)program);
        Structure rtti3Struct = (Structure)DataTypeUtils.getBaseDataType((DataType)rtti3Dt);
        DataType individualRtti2EntryDt = Rtti2Model.getIndividualEntryDataType(program, rtti1Dt);
        PointerTypedef rtti2RefDt = is64Bit ? IBO32DataType.createIBO32PointerTypedef((DataType)individualRtti2EntryDt) : new PointerDataType(individualRtti2EntryDt, (DataTypeManager)dataTypeManager);
        rtti3Struct.replace(3, (DataType)rtti2RefDt, rtti2RefDt.getLength(), "pBaseClassArray", "ref to BaseClassArray (RTTI 2)");
    }

    static DataType getSimpleDataType(Program program) {
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        boolean is64Bit = MSDataTypeUtils.is64Bit((Program)program);
        CategoryPath categoryPath = new CategoryPath(CATEGORY_PATH);
        StructureDataType struct = MSDataTypeUtils.getAlignedPack4Structure((DataTypeManager)dataTypeManager, (CategoryPath)categoryPath, (String)STRUCTURE_NAME);
        DWordDataType dWordDataType = new DWordDataType((DataTypeManager)dataTypeManager);
        struct.add((DataType)dWordDataType, "signature", null);
        struct.add((DataType)dWordDataType, "attributes", "bit flags");
        struct.add((DataType)dWordDataType, "numBaseClasses", "number of base classes (i.e. rtti1Count)");
        DataType rtti2Dt = Rtti2Model.getSimpleIndividualEntryDataType(program);
        PointerTypedef rtti2RefDt = is64Bit ? IBO32DataType.createIBO32PointerTypedef((DataType)rtti2Dt) : new PointerDataType(rtti2Dt, (DataTypeManager)dataTypeManager);
        struct.add((DataType)rtti2RefDt, "pBaseClassArray", "ref to BaseClassArray (RTTI 2)");
        return new TypedefDataType(categoryPath, DATA_TYPE_NAME, (DataType)struct, (DataTypeManager)dataTypeManager);
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = Rtti3Model.getDataType(this.getProgram());
        }
        return this.dataType;
    }

    @Override
    protected int getDataTypeLength() {
        return this.getDataType().getLength();
    }

    public int getSignature() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getIntegerValue(this.getDataType(), 0, this.getMemBuffer());
    }

    public int getAttributes() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getIntegerValue(this.getDataType(), 1, this.getMemBuffer());
    }

    public int getRtti1Count() throws InvalidDataTypeException {
        this.checkValidity();
        Address rtti3Address = this.getAddress();
        return Rtti3Model.getRtti1Count(this.getProgram(), rtti3Address);
    }

    public static int getRtti1Count(Program program, Address rtti3Address) {
        Memory memory = program.getMemory();
        Address rtti1CountAddress = rtti3Address.add(8L);
        int rtti1Count = 0;
        try {
            rtti1Count = (int)new Scalar(32, (long)memory.getInt(rtti1CountAddress, memory.isBigEndian())).getValue();
            return rtti1Count;
        }
        catch (MemoryAccessException e) {
            Msg.error(Rtti3Model.class, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            return 0;
        }
    }

    public Address getRtti2Address() throws InvalidDataTypeException {
        this.checkValidity();
        return Rtti3Model.getRtti2Address(this.getProgram(), this.getAddress());
    }

    private static Address getRtti2Address(Program program, Address rtti3Address) {
        Memory memory = program.getMemory();
        Address rtti2CompAddress = rtti3Address.add(12L);
        Address pointedToAddress = MSDataTypeUtils.getReferencedAddress((Program)program, (Address)rtti2CompAddress);
        if (pointedToAddress == null || !memory.contains(pointedToAddress)) {
            return null;
        }
        return pointedToAddress;
    }

    @Override
    public boolean refersToRtti0(Address rtti0Address) {
        try {
            this.checkValidity();
            return this.rtti2Model.refersToRtti0(rtti0Address);
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
    }

    public List<String> getBaseClassTypes() throws InvalidDataTypeException {
        this.checkValidity();
        return this.rtti2Model.getBaseClassTypes();
    }

    public TypeDescriptorModel getRtti0Model() throws InvalidDataTypeException {
        this.checkValidity();
        return this.rtti2Model.getRtti0Model();
    }

    public Rtti2Model getRtti2Model() throws InvalidDataTypeException {
        this.checkValidity();
        return this.rtti2Model;
    }
}

