/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng.control;

import agent.dbgeng.dbgeng.COMUtilsExtra;
import agent.dbgeng.dbgeng.DbgEng;
import agent.dbgeng.dbgeng.DebugBreakpoint;
import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugEventInformation;
import agent.dbgeng.dbgeng.DebugExceptionFilterInformation;
import agent.dbgeng.dbgeng.DebugFilterInformation;
import agent.dbgeng.dbgeng.DebugSpecificFilterInformation;
import agent.dbgeng.dbgeng.DebugStackInformation;
import agent.dbgeng.dbgeng.DebugValue;
import agent.dbgeng.impl.dbgeng.DbgEngUtil;
import agent.dbgeng.impl.dbgeng.breakpoint.DebugBreakpointInternal;
import agent.dbgeng.impl.dbgeng.control.DebugControlInternal;
import agent.dbgeng.jna.dbgeng.DbgEngNative;
import agent.dbgeng.jna.dbgeng.breakpoint.IDebugBreakpoint;
import agent.dbgeng.jna.dbgeng.breakpoint.WrapIDebugBreakpoint;
import agent.dbgeng.jna.dbgeng.control.IDebugControl;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import ghidra.comm.util.BitmaskSet;
import javax.help.UnsupportedOperationException;

public class DebugControlImpl1
implements DebugControlInternal {
    private final DbgEng.OpaqueCleanable cleanable;
    private final IDebugControl jnaControl;

    public DebugControlImpl1(IDebugControl jnaControl) {
        this.cleanable = DbgEng.releaseWhenPhantom((Object)this, jnaControl);
        this.jnaControl = jnaControl;
    }

    @Override
    public boolean getInterrupt() {
        WinNT.HRESULT interrupt = this.jnaControl.GetInterrupt();
        if (interrupt.equals((Object)WinError.S_OK)) {
            return true;
        }
        if (interrupt.equals((Object)WinError.S_FALSE)) {
            return false;
        }
        COMUtils.checkRC((WinNT.HRESULT)interrupt);
        throw new AssertionError((Object)"Shouldn't get here");
    }

    @Override
    public void setInterrupt(DebugControl.DebugInterrupt interrupt) {
        WinDef.ULONG flags = new WinDef.ULONG((long)interrupt.ordinal());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.SetInterrupt(flags));
    }

    @Override
    public int getInterruptTimeout() {
        WinDef.ULONGByReference pulSeconds = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetInterruptTimeout(pulSeconds));
        return pulSeconds.getValue().intValue();
    }

    @Override
    public void setInterruptTimeout(int seconds) {
        WinDef.ULONG ulSeconds = new WinDef.ULONG((long)seconds);
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.SetInterruptTimeout(ulSeconds));
    }

    @Override
    public void print(BitmaskSet<DebugControl.DebugOutputLevel> levels, String message) {
        WinDef.ULONG mask = new WinDef.ULONG(levels.getBitmask());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.Output(mask, "%s", message));
    }

    @Override
    public void println(BitmaskSet<DebugControl.DebugOutputLevel> levels, String message) {
        WinDef.ULONG mask = new WinDef.ULONG(levels.getBitmask());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.Output(mask, "%s", message + "\r\n"));
    }

    @Override
    public void prompt(BitmaskSet<DebugControl.DebugOutputControl> ctl, String message) {
        WinDef.ULONG ctlMask = new WinDef.ULONG(ctl.getBitmask());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.OutputPrompt(ctlMask, "%s", message));
    }

    @Override
    public String getPromptText() {
        WinDef.ULONGByReference pulTextSize = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetPromptText(null, new WinDef.ULONG(0L), pulTextSize));
        byte[] buffer = new byte[pulTextSize.getValue().intValue()];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetPromptText(buffer, pulTextSize.getValue(), null));
        return Native.toString((byte[])buffer);
    }

    protected DbgEngNative.DEBUG_VALUE doEval(DebugValue.DebugValueType type, String expression) {
        DbgEngNative.DEBUG_VALUE.ByReference value = new DbgEngNative.DEBUG_VALUE.ByReference();
        WinDef.ULONGByReference pulRemainder = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.Evaluate(expression, new WinDef.ULONG((long)type.ordinal()), value, pulRemainder));
        int remainder = pulRemainder.getValue().intValue();
        if (remainder != expression.length()) {
            throw new RuntimeException("Failed to parse: " + expression.substring(remainder));
        }
        return value;
    }

    @Override
    public <T extends DebugValue> T evaluate(Class<T> desiredType, String expression) {
        DebugValue.DebugValueType type = DebugValue.DebugValueType.getDebugValueTypeForClass(desiredType);
        return this.doEval(type, expression).convertTo(desiredType);
    }

    @Override
    public void execute(BitmaskSet<DebugControl.DebugOutputControl> ctl, String cmd, BitmaskSet<DebugControl.DebugExecute> flags) {
        WinDef.ULONG flagMask;
        WinDef.ULONG ctlMask = new WinDef.ULONG(ctl.getBitmask());
        WinNT.HRESULT hr = this.jnaControl.Execute(ctlMask, cmd, flagMask = new WinDef.ULONG(flags.getBitmask()));
        if (hr.equals((Object)COMUtilsExtra.E_INTERNALEXCEPTION)) {
            return;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
    }

    @Override
    public void returnInput(String input) {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.ReturnInput(input));
    }

    @Override
    public DebugClient.DebugStatus getExecutionStatus() {
        WinDef.ULONGByReference pulStatus = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetExecutionStatus(pulStatus));
        return DebugClient.DebugStatus.values()[pulStatus.getValue().intValue()];
    }

    @Override
    public void setExecutionStatus(DebugClient.DebugStatus status) {
        WinDef.ULONG ulStatus = new WinDef.ULONG((long)status.ordinal());
        WinNT.HRESULT hr = this.jnaControl.SetExecutionStatus(ulStatus);
        if (!hr.equals((Object)COMUtilsExtra.E_ACCESS_DENIED)) {
            COMUtils.checkRC((WinNT.HRESULT)hr);
        }
    }

    public DebugBreakpoint doAddBreakpoint(DebugBreakpoint.BreakType type, WinDef.ULONG ulDesiredId) {
        WinDef.ULONG ulType = new WinDef.ULONG((long)type.ordinal());
        PointerByReference ppBp = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.AddBreakpoint(ulType, ulDesiredId, ppBp));
        WrapIDebugBreakpoint Bp = new WrapIDebugBreakpoint(ppBp.getValue());
        DebugBreakpointInternal bpt = DebugBreakpointInternal.tryPreferredInterfaces(this, (arg_0, arg_1) -> ((IDebugBreakpoint)Bp).QueryInterface(arg_0, arg_1));
        return bpt;
    }

    @Override
    public int getNumberBreakpoints() {
        WinDef.ULONGByReference ulNumber = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetNumberBreakpoints(ulNumber));
        return ulNumber.getValue().intValue();
    }

    @Override
    public DebugBreakpoint getBreakpointByIndex(int index) {
        WinDef.ULONG ulIndex = new WinDef.ULONG((long)index);
        PointerByReference ppBp = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetBreakpointByIndex(ulIndex, ppBp));
        WrapIDebugBreakpoint Bp = new WrapIDebugBreakpoint(ppBp.getValue());
        DebugBreakpointInternal bpt = DebugBreakpointInternal.tryPreferredInterfaces(this, (arg_0, arg_1) -> ((IDebugBreakpoint)Bp).QueryInterface(arg_0, arg_1));
        return bpt;
    }

    @Override
    public DebugBreakpoint getBreakpointById(int id) {
        WinDef.ULONG ulId = new WinDef.ULONG((long)id);
        PointerByReference ppBp = new PointerByReference();
        WinNT.HRESULT hr = this.jnaControl.GetBreakpointById(ulId, ppBp);
        if (hr.equals((Object)COMUtilsExtra.E_NOINTERFACE)) {
            return null;
        }
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED)) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        WrapIDebugBreakpoint Bp = new WrapIDebugBreakpoint(ppBp.getValue());
        DebugBreakpointInternal bpt = DebugBreakpointInternal.tryPreferredInterfaces(this, (arg_0, arg_1) -> ((IDebugBreakpoint)Bp).QueryInterface(arg_0, arg_1));
        return bpt;
    }

    @Override
    public DebugBreakpoint addBreakpoint(DebugBreakpoint.BreakType type, int desiredId) {
        return this.doAddBreakpoint(type, new WinDef.ULONG((long)desiredId));
    }

    @Override
    public DebugBreakpoint addBreakpoint(DebugBreakpoint.BreakType type) {
        return this.doAddBreakpoint(type, DbgEngUtil.DEBUG_ANY_ID);
    }

    @Override
    public DebugBreakpoint addBreakpoint2(DebugBreakpoint.BreakType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DebugBreakpoint addBreakpoint2(DebugBreakpoint.BreakType type, int desiredId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeBreakpoint(IDebugBreakpoint comBpt) {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.RemoveBreakpoint(comBpt));
    }

    @Override
    public void waitForEvent(int timeout) {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.WaitForEvent(new WinDef.ULONG(0L), new WinDef.ULONG((long)timeout)));
    }

    @Override
    public DebugEventInformation getLastEventInformation() {
        WinDef.ULONGByReference pulType = new WinDef.ULONGByReference();
        WinDef.ULONGByReference pulProcessId = new WinDef.ULONGByReference();
        WinDef.ULONGByReference pulThreadId = new WinDef.ULONGByReference();
        WinDef.ULONG ulExtraInformationSize = new WinDef.ULONG(0L);
        WinDef.ULONGByReference pulExtraInformationUsed = new WinDef.ULONGByReference();
        WinDef.ULONG ulDescriptionSize = new WinDef.ULONG(0L);
        WinDef.ULONGByReference pulDescriptionUsed = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetLastEventInformation(pulType, pulProcessId, pulThreadId, null, ulExtraInformationSize, pulExtraInformationUsed, null, ulDescriptionSize, pulDescriptionUsed));
        return new DebugEventInformation(pulType.getValue().intValue(), pulProcessId.getValue().intValue(), pulThreadId.getValue().intValue());
    }

    @Override
    public DebugStackInformation getStackTrace(long frameOffset, long stackOffset, long instructionOffset) {
        WinDef.ULONGLONG ullFrameOffset = new WinDef.ULONGLONG(frameOffset);
        WinDef.ULONGLONG ullStackOffset = new WinDef.ULONGLONG(stackOffset);
        WinDef.ULONGLONG ullInstructionOffset = new WinDef.ULONGLONG(instructionOffset);
        WinDef.ULONG ulFrameSize = new WinDef.ULONG(100L);
        DbgEngNative.DEBUG_STACK_FRAME[] pParams = new DbgEngNative.DEBUG_STACK_FRAME[ulFrameSize.intValue()];
        WinDef.ULONGByReference pulFramesFilled = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetStackTrace(ullFrameOffset, ullStackOffset, ullInstructionOffset, pParams, ulFrameSize, pulFramesFilled));
        return new DebugStackInformation(pulFramesFilled.getValue().intValue(), pParams);
    }

    @Override
    public int getActualProcessorType() {
        WinDef.ULONGByReference ulType = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaControl.GetActualProcessorType(ulType);
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED)) {
            return -1;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return ulType.getValue().intValue();
    }

    @Override
    public int getEffectiveProcessorType() {
        WinDef.ULONGByReference ulType = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetEffectiveProcessorType(ulType));
        return ulType.getValue().intValue();
    }

    @Override
    public int getExecutingProcessorType() {
        WinDef.ULONGByReference ulType = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetExecutingProcessorType(ulType));
        return ulType.getValue().intValue();
    }

    @Override
    public int getDebuggeeType() {
        WinDef.ULONGByReference ulClass = new WinDef.ULONGByReference();
        WinDef.ULONGByReference ulQualifier = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetDebuggeeType(ulClass, ulQualifier));
        return ulClass.getValue().intValue();
    }

    @Override
    public DebugFilterInformation getNumberEventFilters() {
        WinDef.ULONGByReference ulSpecificEvents = new WinDef.ULONGByReference();
        WinDef.ULONGByReference ulSpecificExceptions = new WinDef.ULONGByReference();
        WinDef.ULONGByReference ulArbitraryExceptions = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetNumberEventFilters(ulSpecificEvents, ulSpecificExceptions, ulArbitraryExceptions));
        return new DebugFilterInformation(ulSpecificEvents.getValue().intValue(), ulSpecificExceptions.getValue().intValue(), ulArbitraryExceptions.getValue().intValue());
    }

    @Override
    public String getEventFilterText(int index, int size) {
        WinDef.ULONG ulIndex = new WinDef.ULONG((long)index);
        WinDef.ULONG ulBufferSize = new WinDef.ULONG((long)size);
        WinDef.ULONGByReference ulTextSize = new WinDef.ULONGByReference();
        if (size == 0) {
            COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetEventFilterText(ulIndex, null, new WinDef.ULONG(0L), ulTextSize));
            ulBufferSize = ulTextSize.getValue();
        }
        byte[] buffer = new byte[ulBufferSize.intValue()];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetEventFilterText(ulIndex, buffer, ulBufferSize, null));
        return Native.toString((byte[])buffer);
    }

    @Override
    public String getEventFilterCommand(int index, int size) {
        WinDef.ULONG ulIndex = new WinDef.ULONG((long)index);
        WinDef.ULONG ulBufferSize = new WinDef.ULONG((long)size);
        WinDef.ULONGByReference ulCommandSize = new WinDef.ULONGByReference();
        if (size == 0) {
            COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetEventFilterCommand(ulIndex, null, new WinDef.ULONG(0L), ulCommandSize));
            ulBufferSize = ulCommandSize.getValue();
        }
        byte[] buffer = new byte[ulBufferSize.intValue()];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetEventFilterCommand(ulIndex, buffer, ulBufferSize, null));
        return Native.toString((byte[])buffer);
    }

    @Override
    public void setEventFilterCommand(int index, String text) {
        WinDef.ULONG ulIndex = new WinDef.ULONG((long)index);
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.SetEventFilterCommand(ulIndex, text));
    }

    @Override
    public DebugSpecificFilterInformation getSpecificFilterParameters(int start, int count) {
        WinDef.ULONG ulStart = new WinDef.ULONG((long)start);
        WinDef.ULONG ulCount = new WinDef.ULONG((long)count);
        DbgEngNative.DEBUG_SPECIFIC_FILTER_PARAMETERS[] pParams = new DbgEngNative.DEBUG_SPECIFIC_FILTER_PARAMETERS[count];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetSpecificFilterParameters(ulStart, ulCount, pParams));
        return new DebugSpecificFilterInformation(count, pParams);
    }

    @Override
    public void setSpecificFilterParameters(int start, int count, DebugSpecificFilterInformation info) {
        WinDef.ULONG ulStart = new WinDef.ULONG((long)start);
        WinDef.ULONG ulCount = new WinDef.ULONG((long)count);
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.SetSpecificFilterParameters(ulStart, ulCount, info.getParameters()));
    }

    @Override
    public String getSpecificFilterArgument(int index, int size) {
        WinDef.ULONG ulIndex = new WinDef.ULONG((long)index);
        WinDef.ULONG ulBufferSize = new WinDef.ULONG((long)size);
        WinDef.ULONGByReference ulArgumentSize = new WinDef.ULONGByReference();
        if (size == 0) {
            WinNT.HRESULT hr = this.jnaControl.GetSpecificFilterArgument(ulIndex, null, ulBufferSize, ulArgumentSize);
            if (hr.equals((Object)COMUtilsExtra.E_INVALID_PARAM)) {
                return null;
            }
            COMUtils.checkRC((WinNT.HRESULT)hr);
            ulBufferSize = ulArgumentSize.getValue();
        }
        byte[] buffer = new byte[ulBufferSize.intValue()];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetSpecificFilterArgument(ulIndex, buffer, ulBufferSize, null));
        return Native.toString((byte[])buffer);
    }

    @Override
    public void setSpecificFilterArgument(int index, String arg) {
        if (arg != null) {
            WinDef.ULONG ulIndex = new WinDef.ULONG((long)index);
            COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.SetSpecificFilterArgument(ulIndex, arg));
        }
    }

    @Override
    public DebugExceptionFilterInformation getExceptionFilterParameters(int start, int[] codes, int count) {
        WinDef.ULONG ulStart = new WinDef.ULONG((long)start);
        WinDef.ULONG ulCount = new WinDef.ULONG((long)count);
        DbgEngNative.DEBUG_EXCEPTION_FILTER_PARAMETERS[] pParams = new DbgEngNative.DEBUG_EXCEPTION_FILTER_PARAMETERS[count];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetExceptionFilterParameters(ulCount, null, ulStart, pParams));
        return new DebugExceptionFilterInformation(count, pParams);
    }

    @Override
    public void setExceptionFilterParameters(int count, DebugExceptionFilterInformation info) {
        WinDef.ULONG ulCount = new WinDef.ULONG((long)count);
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.SetExceptionFilterParameters(ulCount, info.getParameters()));
    }

    @Override
    public String getExceptionFilterSecondCommand(int index, int size) {
        WinDef.ULONG ulIndex = new WinDef.ULONG((long)index);
        WinDef.ULONG ulBufferSize = new WinDef.ULONG((long)size);
        WinDef.ULONGByReference ulCommandSize = new WinDef.ULONGByReference();
        if (size == 0) {
            COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetExceptionFilterSecondCommand(ulIndex, null, ulBufferSize, ulCommandSize));
            ulBufferSize = ulCommandSize.getValue();
        }
        byte[] buffer = new byte[ulBufferSize.intValue()];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetExceptionFilterSecondCommand(ulIndex, buffer, ulBufferSize, null));
        return Native.toString((byte[])buffer);
    }

    @Override
    public void setExceptionFilterSecondCommand(int index, String cmd) {
        WinDef.ULONG ulIndex = new WinDef.ULONG((long)index);
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.SetExceptionFilterSecondCommand(ulIndex, cmd));
    }
}

