/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.database.target.InternalTraceObjectValue;
import ghidra.trace.database.target.TraceObjectValueQuery;
import ghidra.trace.database.target.ValueShape;
import ghidra.trace.database.target.ValueSpace;
import ghidra.trace.model.Lifespan;
import ghidra.util.AbstractAddressSetView;
import ghidra.util.LockHold;
import ghidra.util.UnionAddressRangeIterator;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.spatial.SpatialMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;
import org.apache.commons.collections4.IteratorUtils;

public class DBTraceObjectValueMapAddressSetView
extends AbstractAddressSetView {
    private final AddressFactory factory;
    private final ReadWriteLock lock;
    private final SpatialMap<ValueShape, InternalTraceObjectValue, TraceObjectValueQuery> map;
    private final Predicate<? super InternalTraceObjectValue> predicate;

    public DBTraceObjectValueMapAddressSetView(AddressFactory factory, ReadWriteLock lock, SpatialMap<ValueShape, InternalTraceObjectValue, TraceObjectValueQuery> map, Predicate<? super InternalTraceObjectValue> predicate) {
        this.factory = factory;
        this.lock = lock;
        this.map = map;
        this.predicate = predicate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(Address addr) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (InternalTraceObjectValue value : this.map.reduce((Object)TraceObjectValueQuery.intersecting(Lifespan.ALL, (AddressRange)new AddressRangeImpl(addr, addr))).values()) {
                if (!this.predicate.test(value)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean contains(Address start, Address end) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            boolean bl = super.contains(start, end);
            return bl;
        }
    }

    public boolean contains(AddressSetView rangeSet) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            boolean bl = super.contains(rangeSet);
            return bl;
        }
    }

    public boolean isEmpty() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (InternalTraceObjectValue value : this.map.values()) {
                if (!this.predicate.test(value)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public Address getMinAddress() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (Map.Entry entry : this.map.reduce((Object)((TraceObjectValueQuery)TraceObjectValueQuery.all().starting(ValueSpace.AddressDimension.FORWARD))).orderedEntries()) {
                if (!this.predicate.test((InternalTraceObjectValue)entry.getValue())) continue;
                Address address = ((ValueShape)entry.getKey()).getMinAddress(this.factory);
                return address;
            }
        }
        return null;
    }

    public Address getMaxAddress() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (Map.Entry entry : this.map.reduce((Object)((TraceObjectValueQuery)TraceObjectValueQuery.all().starting(ValueSpace.AddressDimension.BACKWARD))).orderedEntries()) {
                if (!this.predicate.test((InternalTraceObjectValue)entry.getValue())) continue;
                Address address = ((ValueShape)entry.getKey()).getMaxAddress(this.factory);
                return address;
            }
        }
        return null;
    }

    public int getNumAddressRanges() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            int n = super.getNumAddressRanges();
            return n;
        }
    }

    public AddressRangeIterator getAddressRanges() {
        return this.doGetAddressRanges(ValueSpace.AddressDimension.INSTANCE.absoluteMin(), ValueSpace.AddressDimension.INSTANCE.absoluteMax(), true);
    }

    public AddressRangeIterator getAddressRanges(boolean forward) {
        return this.doGetAddressRanges(ValueSpace.AddressDimension.INSTANCE.absoluteMin(), ValueSpace.AddressDimension.INSTANCE.absoluteMax(), forward);
    }

    protected AddressRangeIterator doGetAddressRanges(DBCachedObjectStoreFactory.RecAddress start, DBCachedObjectStoreFactory.RecAddress end, boolean forward) {
        Iterator mapIt = this.map.reduce((Object)((TraceObjectValueQuery)TraceObjectValueQuery.intersecting(ValueSpace.EntryKeyDimension.INSTANCE.absoluteMin(), ValueSpace.EntryKeyDimension.INSTANCE.absoluteMax(), Lifespan.ALL, start, end).starting(forward ? ValueSpace.AddressDimension.FORWARD : ValueSpace.AddressDimension.BACKWARD))).orderedEntries().iterator();
        Iterator fltIt = IteratorUtils.filteredIterator(mapIt, e -> this.predicate.test((InternalTraceObjectValue)e.getValue()));
        Iterator rawIt = IteratorUtils.transformedIterator((Iterator)fltIt, e -> ((ValueShape)e.getKey()).getRange(this.factory));
        return new UnionAddressRangeIterator(rawIt, forward);
    }

    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        DBCachedObjectStoreFactory.RecAddress min = forward ? DBCachedObjectStoreFactory.RecAddress.fromAddress((Address)start) : ValueSpace.AddressDimension.INSTANCE.absoluteMin();
        DBCachedObjectStoreFactory.RecAddress max = forward ? ValueSpace.AddressDimension.INSTANCE.absoluteMax() : DBCachedObjectStoreFactory.RecAddress.fromAddress((Address)start);
        return this.doGetAddressRanges(min, max, forward);
    }

    public long getNumAddresses() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            long l = super.getNumAddresses();
            return l;
        }
    }

    public boolean intersects(AddressSetView addrSet) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            boolean bl = super.intersects(addrSet);
            return bl;
        }
    }

    public boolean intersects(Address start, Address end) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            boolean bl = super.intersects(start, end);
            return bl;
        }
    }

    public AddressSet intersect(AddressSetView view) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressSet addressSet = super.intersect(view);
            return addressSet;
        }
    }

    public AddressSet intersectRange(Address start, Address end) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressSet addressSet = super.intersectRange(start, end);
            return addressSet;
        }
    }

    public AddressSet union(AddressSetView addrSet) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressSet addressSet = super.union(addrSet);
            return addressSet;
        }
    }

    public AddressSet subtract(AddressSetView addrSet) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressSet addressSet = super.subtract(addrSet);
            return addressSet;
        }
    }

    public AddressSet xor(AddressSetView addrSet) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressSet addressSet = super.xor(addrSet);
            return addressSet;
        }
    }

    public boolean hasSameAddresses(AddressSetView view) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            boolean bl = super.hasSameAddresses(view);
            return bl;
        }
    }

    public AddressRange getFirstRange() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressRange addressRange = super.getFirstRange();
            return addressRange;
        }
    }

    public AddressRange getLastRange() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressRange addressRange = super.getLastRange();
            return addressRange;
        }
    }

    public AddressRange getRangeContaining(Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressRange addressRange = super.getRangeContaining(address);
            return addressRange;
        }
    }

    public Address findFirstAddressInCommon(AddressSetView set) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            Address address = super.findFirstAddressInCommon(set);
            return address;
        }
    }
}

