/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectDBFieldCodec;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.database.target.DBTraceObjectValueRStarTree;
import ghidra.trace.database.target.ImmutableValueBox;
import ghidra.trace.database.target.ImmutableValueShape;
import ghidra.trace.database.target.InternalTraceObjectValue;
import ghidra.trace.database.target.ValueBox;
import ghidra.trace.database.target.ValueShape;
import ghidra.trace.database.target.ValueTriple;
import ghidra.trace.database.target.visitors.TreeTraversal;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.database.spatial.DBTreeDataRecord;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.stream.Stream;

@DBAnnotatedObjectInfo(version=1)
public class DBTraceObjectValueData
extends DBTreeDataRecord<ValueShape, ValueBox, InternalTraceObjectValue>
implements InternalTraceObjectValue,
ValueShape {
    static final String TABLE_NAME = "ObjectValue";
    static final String PARENT_COLUMN_NAME = "Parent";
    static final String OBJ_PARENT_COLUMN_NAME = "ObjParent";
    static final String ENTRY_KEY_COLUMN_NAME = "EntryKey";
    static final String MIN_SNAP_COLUMN_NAME = "MinSnap";
    static final String MAX_SNAP_COLUMN_NAME = "MaxSnap";
    static final String CHILD_COLUMN_NAME = "Child";
    static final String PRIMITIVE_COLUMN_NAME = "Primitive";
    @DBAnnotatedColumn(value="Parent")
    static DBObjectColumn PARENT_COLUMN;
    @DBAnnotatedColumn(value="ObjParent")
    static DBObjectColumn OBJ_PARENT_COLUMN;
    @DBAnnotatedColumn(value="EntryKey")
    static DBObjectColumn ENTRY_KEY_COLUMN;
    @DBAnnotatedColumn(value="MinSnap")
    static DBObjectColumn MIN_SNAP_COLUMN;
    @DBAnnotatedColumn(value="MaxSnap")
    static DBObjectColumn MAX_SNAP_COLUMN;
    @DBAnnotatedColumn(value="Child")
    static DBObjectColumn CHILD_COLUMN;
    @DBAnnotatedColumn(value="Primitive")
    static DBObjectColumn PRIMITIVE_COLUMN;
    @DBAnnotatedField(column="Parent", indexed=true)
    private long parentKey;
    @DBAnnotatedField(column="ObjParent", codec=DBTraceObjectDBFieldCodec.class)
    private DBTraceObject objParent;
    @DBAnnotatedField(column="EntryKey")
    private String entryKey;
    @DBAnnotatedField(column="MinSnap")
    private long minSnap;
    @DBAnnotatedField(column="MaxSnap")
    private long maxSnap;
    @DBAnnotatedField(column="Child", indexed=true, codec=DBTraceObjectDBFieldCodec.class)
    private DBTraceObject child;
    @DBAnnotatedField(column="Primitive", codec=DBCachedObjectStoreFactory.VariantDBFieldCodec.class)
    private Object primitive;
    protected final DBTraceObjectManager manager;
    protected final DBTraceObjectValueRStarTree tree;
    protected ValueBox bounds;
    protected Lifespan lifespan;
    protected Address address;
    protected AddressRange range;

    public DBTraceObjectValueData(DBTraceObjectManager manager, DBTraceObjectValueRStarTree tree, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.manager = manager;
        this.tree = tree;
    }

    @Override
    public void doSetPrimitive(Object primitive) {
        if (primitive instanceof TraceObject) {
            throw new AssertionError();
        }
        if (primitive instanceof Address) {
            Address address;
            this.address = address = (Address)primitive;
            this.range = null;
            this.primitive = DBCachedObjectStoreFactory.RecAddress.fromAddress((Address)address);
        } else if (primitive instanceof AddressRange) {
            AddressRange range = (AddressRange)primitive;
            this.address = null;
            this.range = range;
            this.primitive = DBCachedObjectStoreFactory.RecRange.fromRange((AddressRange)range);
        } else {
            this.address = null;
            this.range = null;
            this.primitive = primitive;
        }
        this.update(PRIMITIVE_COLUMN);
    }

    protected long getObjParentKey() {
        return this.objParent == null ? -1L : this.objParent.getKey();
    }

    protected long getObjChildKey() {
        return this.child == null ? -1L : this.child.getKey();
    }

    @Override
    public int getAddressSpaceId() {
        Object object = this.primitive;
        if (object instanceof DBCachedObjectStoreFactory.RecAddress) {
            DBCachedObjectStoreFactory.RecAddress addr = (DBCachedObjectStoreFactory.RecAddress)object;
            return addr.spaceId();
        }
        object = this.primitive;
        if (object instanceof DBCachedObjectStoreFactory.RecRange) {
            DBCachedObjectStoreFactory.RecRange rng = (DBCachedObjectStoreFactory.RecRange)object;
            return rng.spaceId();
        }
        return -1;
    }

    @Override
    public long getMinAddressOffset() {
        Object object = this.primitive;
        if (object instanceof DBCachedObjectStoreFactory.RecAddress) {
            DBCachedObjectStoreFactory.RecAddress addr = (DBCachedObjectStoreFactory.RecAddress)object;
            return addr.offset();
        }
        object = this.primitive;
        if (object instanceof DBCachedObjectStoreFactory.RecRange) {
            DBCachedObjectStoreFactory.RecRange rng = (DBCachedObjectStoreFactory.RecRange)object;
            return rng.min();
        }
        return 0L;
    }

    @Override
    public long getMaxAddressOffset() {
        Object object = this.primitive;
        if (object instanceof DBCachedObjectStoreFactory.RecAddress) {
            DBCachedObjectStoreFactory.RecAddress addr = (DBCachedObjectStoreFactory.RecAddress)object;
            return addr.offset();
        }
        object = this.primitive;
        if (object instanceof DBCachedObjectStoreFactory.RecRange) {
            DBCachedObjectStoreFactory.RecRange rng = (DBCachedObjectStoreFactory.RecRange)object;
            return rng.max();
        }
        return 0L;
    }

    protected void updateBounds() {
        long objParentKey = this.getObjParentKey();
        long objChildKey = this.getObjChildKey();
        int spaceId = this.getAddressSpaceId();
        this.bounds = new ImmutableValueBox(new ValueTriple(objParentKey, objChildKey, this.entryKey, this.minSnap, new DBCachedObjectStoreFactory.RecAddress(spaceId, this.getMinAddressOffset())), new ValueTriple(objParentKey, objChildKey, this.entryKey, this.maxSnap, new DBCachedObjectStoreFactory.RecAddress(spaceId, this.getMaxAddressOffset())));
    }

    protected void fresh(boolean created) throws IOException {
        super.fresh(created);
        if (created) {
            return;
        }
        this.updateBounds();
        this.lifespan = Lifespan.span(this.minSnap, this.maxSnap);
        Object object = this.primitive;
        if (object instanceof DBCachedObjectStoreFactory.RecAddress) {
            DBCachedObjectStoreFactory.RecAddress address = (DBCachedObjectStoreFactory.RecAddress)object;
            this.address = address.toAddress(this.manager.trace.getBaseAddressFactory());
            this.range = null;
        } else {
            object = this.primitive;
            if (object instanceof DBCachedObjectStoreFactory.RecRange) {
                DBCachedObjectStoreFactory.RecRange range = (DBCachedObjectStoreFactory.RecRange)object;
                this.address = null;
                this.range = range.toRange(this.manager.trace.getBaseAddressFactory());
            } else {
                this.address = null;
                this.range = null;
            }
        }
    }

    @Override
    public Trace getTrace() {
        return this.manager.trace;
    }

    @Override
    public DBTraceObject getParent() {
        return this.objParent;
    }

    @Override
    public String getEntryKey() {
        return this.entryKey;
    }

    protected TraceObjectKeyPath doGetCanonicalPath() {
        if (this.objParent == null) {
            return TraceObjectKeyPath.of(new String[0]);
        }
        return this.objParent.getCanonicalPath().extend(this.entryKey);
    }

    protected boolean doIsCanonical() {
        if (this.child == null) {
            return false;
        }
        if (this.objParent == null) {
            return true;
        }
        return this.doGetCanonicalPath().equals(this.child.getCanonicalPath());
    }

    @Override
    public TraceObjectKeyPath getCanonicalPath() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            TraceObjectKeyPath traceObjectKeyPath = this.doGetCanonicalPath();
            return traceObjectKeyPath;
        }
    }

    @Override
    public boolean isCanonical() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            boolean bl = this.doIsCanonical();
            return bl;
        }
    }

    @Override
    public Object getValue() {
        try (LockHold hold = this.manager.trace.lockRead();){
            if (this.child != null) {
                DBTraceObject dBTraceObject = this.child;
                return dBTraceObject;
            }
            if (this.address != null) {
                Address address = this.address;
                return address;
            }
            if (this.range != null) {
                AddressRange addressRange = this.range;
                return addressRange;
            }
            Object object = this.child != null ? this.child : this.primitive;
            return object;
        }
    }

    @Override
    public DBTraceObject getChild() {
        return (DBTraceObject)this.getValue();
    }

    @Override
    public boolean isObject() {
        return this.child != null;
    }

    @Override
    public Lifespan getLifespan() {
        try (LockHold hold = this.manager.trace.lockRead();){
            Lifespan lifespan = this.lifespan;
            return lifespan;
        }
    }

    @Override
    public void setMinSnap(long minSnap) {
        try (LockHold hold = this.manager.trace.lockWrite();){
            this.setLifespan(Lifespan.span(minSnap, this.maxSnap));
        }
    }

    @Override
    public long getMinSnap() {
        try (LockHold hold = this.manager.trace.lockRead();){
            long l = this.minSnap;
            return l;
        }
    }

    @Override
    public void setMaxSnap(long maxSnap) {
        try (LockHold hold = this.manager.trace.lockWrite();){
            this.setLifespan(Lifespan.span(this.minSnap, maxSnap));
        }
    }

    @Override
    public long getMaxSnap() {
        try (LockHold hold = this.manager.trace.lockRead();){
            long l = this.maxSnap;
            return l;
        }
    }

    @Override
    public void delete() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.objParent == null) {
                throw new IllegalArgumentException("Cannot delete root value");
            }
            this.doDeleteAndEmit();
        }
    }

    @Override
    public TraceObjectValue truncateOrDelete(Lifespan span) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.objParent == null) {
                throw new IllegalArgumentException("Cannot truncate or delete root value");
            }
            InternalTraceObjectValue internalTraceObjectValue = this.doTruncateOrDeleteAndEmitLifeChange(span);
            return internalTraceObjectValue;
        }
    }

    protected boolean shapeEquals(ValueShape shape) {
        if (this.objParent != shape.getParent()) {
            return false;
        }
        if (!Objects.equals(this.entryKey, shape.getEntryKey())) {
            return false;
        }
        return Objects.equals(this.lifespan, shape.getLifespan());
    }

    protected void setRecordValue(InternalTraceObjectValue value) {
    }

    protected InternalTraceObjectValue getRecordValue() {
        return this;
    }

    public ValueShape getShape() {
        return this;
    }

    public ValueBox getBounds() {
        return this.bounds;
    }

    public void setShape(ValueShape shape) {
        this.objParent = shape.getParent();
        this.child = shape.getChild();
        this.entryKey = shape.getEntryKey();
        this.minSnap = shape.getLifespan().lmin();
        this.maxSnap = shape.getLifespan().lmax();
        this.update(new DBObjectColumn[]{OBJ_PARENT_COLUMN, CHILD_COLUMN, ENTRY_KEY_COLUMN, MIN_SNAP_COLUMN, MAX_SNAP_COLUMN});
        this.lifespan = shape.getLifespan();
        this.bounds = (ValueBox)shape.getBounds();
    }

    public long getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(long parentKey) {
        this.parentKey = parentKey;
        this.update(PARENT_COLUMN);
    }

    public String description() {
        return new ImmutableValueShape(this.getShape()).toString();
    }

    @Override
    public DBTraceObjectManager getManager() {
        return this.manager;
    }

    @Override
    public DBTraceObject getChildOrNull() {
        return this.child;
    }

    @Override
    public void doSetLifespan(Lifespan lifespan) {
        if (this.minSnap == lifespan.lmin() && this.maxSnap == lifespan.lmax()) {
            return;
        }
        DBTraceObjectValueRStarTree tree = this.tree;
        tree.doUnparentEntry(this);
        this.objParent.notifyValueDeleted(this);
        if (this.child != null) {
            this.child.notifyParentValueDeleted(this);
        }
        this.minSnap = lifespan.lmin();
        this.maxSnap = lifespan.lmax();
        this.update(MIN_SNAP_COLUMN, MAX_SNAP_COLUMN);
        this.lifespan = lifespan;
        this.updateBounds();
        tree.doInsertDataEntry(this);
        this.objParent.notifyValueCreated(this);
        if (this.child != null) {
            this.child.notifyParentValueCreated(this);
        }
    }

    @Override
    public void doDelete() {
        this.objParent.notifyValueDeleted(this);
        if (this.child != null) {
            this.child.notifyParentValueDeleted(this);
        }
        this.manager.doDeleteEdge(this);
    }

    protected Stream<? extends TraceObjectValPath> doStreamVisitor(Lifespan span, TreeTraversal.Visitor visitor) {
        return TreeTraversal.INSTANCE.walkValue(visitor, this, span, null);
    }
}

