/*
 * Decompiled with CFR 0.152.
 */
package ghidra.net;

import ghidra.framework.preferences.Preferences;
import ghidra.net.ApplicationKeyManagerUtils;
import ghidra.net.ApplicationKeyStore;
import ghidra.security.KeyStorePasswordProvider;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang3.StringUtils;

public class ApplicationKeyManagerFactory {
    public static final String KEYSTORE_PATH_PROPERTY = "ghidra.keystore";
    public static final String KEYSTORE_PASSWORD_PROPERTY = "ghidra.password";
    public static final String DEFAULT_PASSWORD = "changeme";
    private static final int SELF_SIGNED_DURATION_DAYS = 730;
    private static KeyStorePasswordProvider customPasswordProvider;
    private static X500Principal defaultIdentity;
    private static List<String> subjectAlternativeNames;
    private static ApplicationKeyManagerFactory instance;
    private ApplicationKeyManager keyManagerWrapper = new ApplicationKeyManager();

    static synchronized ApplicationKeyManagerFactory getInstance() {
        if (instance == null) {
            instance = new ApplicationKeyManagerFactory();
        }
        return instance;
    }

    private static ApplicationKeyManager getKeyManagerWrapper() {
        return ApplicationKeyManagerFactory.getInstance().keyManagerWrapper;
    }

    public static synchronized void setKeyStorePasswordProvider(KeyStorePasswordProvider provider) {
        customPasswordProvider = provider;
    }

    private static String prunePath(String path) {
        if (path != null && (path = path.trim()).length() == 0) {
            path = null;
        }
        return path;
    }

    public static synchronized boolean setKeyStore(String path, boolean savePreference) {
        if (System.getProperty(KEYSTORE_PATH_PROPERTY) != null) {
            Msg.showError(ApplicationKeyManagerFactory.class, null, (String)"Set KeyStore Failed", (Object)"PKI KeyStore was set via system property and can not be changed");
            return false;
        }
        path = ApplicationKeyManagerFactory.prunePath(path);
        try {
            boolean keyInitialized = ApplicationKeyManagerFactory.getKeyManagerWrapper().init(path);
            if (savePreference && (path == null || keyInitialized)) {
                Preferences.setProperty(KEYSTORE_PATH_PROPERTY, path);
                Preferences.store();
            }
            return keyInitialized;
        }
        catch (CancelledException e) {
            return false;
        }
    }

    public static synchronized String getKeyStore() {
        return ApplicationKeyManagerFactory.getKeyManagerWrapper().getKeyStore();
    }

    public static synchronized String getPreferredKeyStore() {
        String path = ApplicationKeyManagerFactory.prunePath(System.getProperty(KEYSTORE_PATH_PROPERTY));
        if (path == null && !SystemUtilities.isInHeadlessMode()) {
            path = ApplicationKeyManagerFactory.prunePath(Preferences.getProperty(KEYSTORE_PATH_PROPERTY));
        }
        return path;
    }

    public static synchronized boolean usingGeneratedSelfSignedCertificate() {
        return ApplicationKeyManagerFactory.getKeyManagerWrapper().usingGeneratedSelfSignedCertificate();
    }

    public static synchronized void setDefaultIdentity(X500Principal identity) {
        defaultIdentity = identity;
        ApplicationKeyManagerFactory.getKeyManagerWrapper().invalidateKey();
    }

    public static synchronized void addSubjectAlternativeName(String subjectAltName) {
        if (subjectAltName == null) {
            subjectAlternativeNames = null;
        } else {
            if (subjectAlternativeNames == null) {
                subjectAlternativeNames = new ArrayList<String>();
            }
            subjectAlternativeNames.add(subjectAltName);
        }
        ApplicationKeyManagerFactory.getKeyManagerWrapper().invalidateKey();
    }

    public static synchronized List<String> getSubjectAlternativeName() {
        return Collections.unmodifiableList(subjectAlternativeNames);
    }

    public static synchronized boolean initialize() {
        try {
            return ApplicationKeyManagerFactory.getKeyManagerWrapper().init();
        }
        catch (CancelledException e) {
            return false;
        }
    }

    public static synchronized void invalidateKeyManagers() {
        ApplicationKeyManagerFactory.getKeyManagerWrapper().invalidateKey();
    }

    private ApplicationKeyManagerFactory() {
    }

    KeyManager[] getKeyManagers() {
        return new KeyManager[]{this.keyManagerWrapper};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ProtectedKeyStoreData getProtectedKeyStoreData(String keystorePath) throws CancelledException, KeyStoreException {
        Msg.info(ApplicationKeyManagerFactory.class, (Object)("Using certificate keystore: " + keystorePath));
        String keystorePwd = System.getProperty(KEYSTORE_PASSWORD_PROPERTY);
        int tryCount = 0;
        while (true) {
            ProtectedKeyStoreData protectedKeyStoreData;
            char[] oldPassword;
            char[] password;
            block24: {
                block23: {
                    block22: {
                        password = new char[]{};
                        oldPassword = null;
                        try {
                            block21: {
                                if (tryCount != 0) {
                                    if (tryCount == 1) {
                                        Msg.debug(ApplicationKeyManagerFactory.class, (Object)"Attempting to load keystore without password...");
                                        password = DEFAULT_PASSWORD.toCharArray();
                                    } else {
                                        if (tryCount == 2) {
                                            if (keystorePwd != null) {
                                                Msg.debug(ApplicationKeyManagerFactory.class, (Object)"Attempting to load keystore with property-based password...");
                                                password = keystorePwd.toCharArray();
                                                break block21;
                                            } else {
                                                ++tryCount;
                                                continue;
                                            }
                                        }
                                        if (customPasswordProvider != null) {
                                            ApplicationKeyManagerFactory.disposePassword(oldPassword);
                                            oldPassword = password;
                                            password = customPasswordProvider.getKeyStorePassword(keystorePath, tryCount != 3);
                                            if (password == null) {
                                                throw new CancelledException();
                                            }
                                            if (Arrays.equals(password, oldPassword)) {
                                                ApplicationKeyManagerFactory.disposePassword(oldPassword);
                                                break block22;
                                            }
                                            Msg.debug(ApplicationKeyManagerFactory.class, (Object)"Attempting to open keystore with user-supplied password...");
                                        } else {
                                            ApplicationKeyManagerFactory.disposePassword(oldPassword);
                                            break block23;
                                        }
                                    }
                                }
                            }
                            ++tryCount;
                            KeyStore keyStore = ApplicationKeyStore.getKeyStoreInstance(keystorePath, password);
                            protectedKeyStoreData = new ProtectedKeyStoreData(keyStore, password);
                            ApplicationKeyManagerFactory.disposePassword(oldPassword);
                            break block24;
                        }
                        catch (FileNotFoundException | NoSuchAlgorithmException | CertificateException e) {
                            throw new KeyStoreException("Failed to process keystore: " + keystorePath, e);
                        }
                        catch (IOException | KeyStoreException e) {
                            IOException ioException = ApplicationKeyManagerFactory.getIOException(e);
                            if (ioException == null) throw new KeyStoreException("Failed to process keystore (" + tryCount + "): " + keystorePath, e);
                            continue;
                        }
                    }
                    ApplicationKeyManagerFactory.disposePassword(password);
                    throw new KeyStoreException("Failed to unlock key storage: " + keystorePath);
                }
                ApplicationKeyManagerFactory.disposePassword(password);
                throw new KeyStoreException("Failed to unlock key storage: " + keystorePath);
            }
            ApplicationKeyManagerFactory.disposePassword(password);
            return protectedKeyStoreData;
            finally {
                ApplicationKeyManagerFactory.disposePassword(oldPassword);
                ApplicationKeyManagerFactory.disposePassword(password);
                continue;
            }
            break;
        }
    }

    private static void disposePassword(char[] password) {
        if (password != null) {
            Arrays.fill(password, '\u0000');
            password = null;
        }
    }

    private static IOException getIOException(Exception e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof IOException)) continue;
            return (IOException)cause;
        }
        return null;
    }

    private class ApplicationKeyManager
    extends X509ExtendedKeyManager {
        private X509KeyManager wrappedKeyManager;
        private String keystorePath;
        private boolean isSelfSigned = false;

        private ApplicationKeyManager() {
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            return super.chooseEngineServerAlias(keyType, issuers, engine);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            return super.chooseEngineClientAlias(keyType, issuers, engine);
        }

        @Override
        public synchronized String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            try {
                this.init();
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            if (this.wrappedKeyManager == null) {
                return null;
            }
            return this.wrappedKeyManager.chooseClientAlias(keyType, issuers, socket);
        }

        @Override
        public synchronized String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            try {
                this.init();
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            if (this.wrappedKeyManager == null) {
                return null;
            }
            return this.wrappedKeyManager.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            try {
                this.init();
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            if (this.wrappedKeyManager == null) {
                return null;
            }
            return this.wrappedKeyManager.getClientAliases(keyType, issuers);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            try {
                this.init();
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            if (this.wrappedKeyManager == null) {
                return null;
            }
            return this.wrappedKeyManager.getServerAliases(keyType, issuers);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            if (this.wrappedKeyManager == null) {
                return null;
            }
            return this.wrappedKeyManager.getCertificateChain(alias);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            if (this.wrappedKeyManager == null) {
                return null;
            }
            return this.wrappedKeyManager.getPrivateKey(alias);
        }

        private synchronized void invalidateKey() {
            this.wrappedKeyManager = null;
            this.keystorePath = null;
            this.isSelfSigned = false;
        }

        private synchronized String getKeyStore() {
            return this.wrappedKeyManager != null ? this.keystorePath : ApplicationKeyManagerFactory.getPreferredKeyStore();
        }

        private synchronized boolean usingGeneratedSelfSignedCertificate() {
            return this.wrappedKeyManager != null && this.isSelfSigned;
        }

        private synchronized boolean init() throws CancelledException {
            if (this.wrappedKeyManager != null) {
                return true;
            }
            return this.init(ApplicationKeyManagerFactory.getPreferredKeyStore());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean init(String newKeystorePath) throws CancelledException {
            if (this.wrappedKeyManager != null) {
                if (StringUtils.equals((CharSequence)this.keystorePath, (CharSequence)newKeystorePath)) {
                    return true;
                }
                this.invalidateKey();
            }
            ProtectedKeyStoreData keystoreData = null;
            try {
                if (newKeystorePath != null && newKeystorePath.length() != 0) {
                    keystoreData = ApplicationKeyManagerFactory.getProtectedKeyStoreData(newKeystorePath);
                } else if (defaultIdentity != null) {
                    Msg.info((Object)this, (Object)("Using self-signed certificate: " + defaultIdentity.getName()));
                    char[] pwd = ApplicationKeyManagerFactory.DEFAULT_PASSWORD.toCharArray();
                    KeyStore selfSignedKeyStore = ApplicationKeyManagerUtils.createKeyStore("defaultSigKey", defaultIdentity.getName(), 730, null, null, "JKS", subjectAlternativeNames, pwd);
                    keystoreData = new ProtectedKeyStoreData(selfSignedKeyStore, pwd);
                    this.isSelfSigned = true;
                } else {
                    boolean pwd = false;
                    return pwd;
                }
                ApplicationKeyStore.logCerts(keystoreData.keyStore);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keystoreData.keyStore, keystoreData.password);
                KeyManager[] keyManagers = kmf.getKeyManagers();
                if (keyManagers.length == 1 && keyManagers[0] instanceof X509KeyManager) {
                    this.wrappedKeyManager = (X509KeyManager)keyManagers[0];
                    this.keystorePath = newKeystorePath;
                    boolean bl = true;
                    return bl;
                }
                this.isSelfSigned = false;
                if (keyManagers.length == 0) {
                    Msg.showError((Object)this, null, (String)"PKI Keystore Failure", (Object)"Failed to create PKI key manager: failed to process keystore (no keys processed)");
                } else if (keyManagers.length == 1) {
                    Msg.showError((Object)this, null, (String)"PKI Keystore Failure", (Object)"Failed to create PKI key manager: failed to process keystore (expected X.509)");
                } else {
                    Msg.showError((Object)this, null, (String)"PKI Keystore Failure", (Object)"Failed to create PKI key manager: unsupported keystore produced multiple KeyManagers");
                }
            }
            catch (CancelledException e) {
                throw e;
            }
            catch (Exception e) {
                Msg.showError((Object)this, null, (String)"PKI Keystore Failure", (Object)("Failed to create PKI key manager: " + e.getMessage()), (Throwable)e);
            }
            finally {
                if (keystoreData != null) {
                    keystoreData.dispose();
                    keystoreData = null;
                }
            }
            return false;
        }
    }

    private static class ProtectedKeyStoreData {
        KeyStore keyStore;
        char[] password;

        ProtectedKeyStoreData(KeyStore keyStore, char[] password) {
            this.keyStore = keyStore;
            this.password = password != null ? (char[])password.clone() : null;
        }

        void dispose() {
            if (this.password != null) {
                Arrays.fill(this.password, ' ');
            }
            this.keyStore = null;
        }

        protected void finalize() throws Throwable {
            this.dispose();
            super.finalize();
        }
    }
}

