/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.xml.XmlUtilities;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.KeyStroke;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;
import utilities.util.FileUtilities;

public class GProperties {
    private static final String G_PROPERTIES_TYPE = "GProperties";
    private static final String SAVE_STATE_LEGACY_TYPE = "SaveState";
    private static final String GPROPERTIES_TAG = "GPROPERTIES";
    private static final String PROPERTIES_NAME = "GPROPERTIES_NAME";
    private static final String LEGACY_PROPERTIES_NAME = "SAVE_STATE_NAME";
    private static final String STATE = "STATE";
    protected static final String TYPE = "TYPE";
    protected static final String NAME = "NAME";
    private static final String VALUE = "VALUE";
    public static DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final String ARRAY_ELEMENT_NAME = "A";
    protected TreeMap<String, Object> map;
    private String propertiesName;

    public GProperties(String name) {
        this.propertiesName = name;
        this.map = new TreeMap();
    }

    public GProperties(Element root) {
        this(root.getName());
        for (Element elem : root.getChildren()) {
            this.processElement(elem);
        }
    }

    public GProperties(JsonObject root) {
        this(GProperties.getPropertiesName(root));
        JsonObject values = root.get("VALUES").getAsJsonObject();
        JsonObject types = root.get("TYPES").getAsJsonObject();
        JsonObject enumClasses = root.get("ENUM_CLASSES").getAsJsonObject();
        for (String name : values.keySet()) {
            JsonElement enumClass;
            JsonElement valueElement;
            String type = types.get(name).getAsString();
            Object value = this.getObjectFromJson(type, valueElement = values.get(name), enumClass = enumClasses.get(name));
            if (value == null) continue;
            this.map.put(name, value);
        }
    }

    protected void processElement(Element elem) {
        block69: {
            String tag = elem.getName();
            String name = elem.getAttributeValue(NAME);
            String type = elem.getAttributeValue(TYPE);
            String value = elem.getAttributeValue(VALUE);
            if (tag.equals("XML")) {
                this.map.put(name, elem.getChildren().get(0));
            } else if (tag.equals("BYTES")) {
                if (value != null) {
                    this.map.put(name, NumericUtilities.convertStringToBytes(value));
                }
            } else if (tag.equals(STATE)) {
                try {
                    if (type == null) break block69;
                    if (type.equals("byte")) {
                        this.map.put(name, Byte.valueOf(value));
                    } else if (type.equals("short")) {
                        this.map.put(name, Short.valueOf(value));
                    } else if (type.equals("int")) {
                        this.map.put(name, Integer.valueOf(value));
                    } else if (type.equals("long")) {
                        this.map.put(name, Long.valueOf(value));
                    } else if (type.equals("float")) {
                        this.map.put(name, Float.valueOf(value));
                    } else if (type.equals("double")) {
                        this.map.put(name, Double.valueOf(value));
                    } else if (type.equals("boolean")) {
                        this.map.put(name, Boolean.valueOf(value));
                    } else if (type.equals("string")) {
                        String encodedValue = elem.getAttributeValue("ENCODED_VALUE");
                        if (value == null && encodedValue != null) {
                            byte[] strBytes = NumericUtilities.convertStringToBytes(encodedValue);
                            value = new String(strBytes, StandardCharsets.UTF_8);
                        }
                        this.map.put(name, value);
                    } else if (type.equals("Color")) {
                        this.map.put(name, new Color(Integer.valueOf(value)));
                    } else if (type.equals("Date")) {
                        this.map.put(name, DATE_FORMAT.parse(value));
                    } else if (type.equals("File")) {
                        this.map.put(name, new File(value));
                    } else if (type.equals("KeyStroke")) {
                        this.map.put(name, KeyStroke.getKeyStroke(value));
                    } else if (type.equals("Font")) {
                        this.map.put(name, Font.decode(value));
                    }
                }
                catch (Exception e) {
                    Msg.warn((Object)this, (Object)"Error processing primitive value in GProperties", (Throwable)e);
                }
            } else if (tag.equals("ARRAY")) {
                if (type == null) {
                    return;
                }
                try {
                    List list = elem.getChildren(ARRAY_ELEMENT_NAME);
                    Iterator it = list.iterator();
                    int i = 0;
                    if (type.equals("short")) {
                        short[] vals = new short[list.size()];
                        while (it.hasNext()) {
                            Element e = (Element)it.next();
                            vals[i++] = Short.parseShort(e.getAttributeValue(VALUE));
                        }
                        this.map.put(name, vals);
                    } else if (type.equals("int")) {
                        int[] vals = new int[list.size()];
                        while (it.hasNext()) {
                            Element e = (Element)it.next();
                            vals[i++] = Integer.parseInt(e.getAttributeValue(VALUE));
                        }
                        this.map.put(name, vals);
                    } else if (type.equals("long")) {
                        long[] vals = new long[list.size()];
                        while (it.hasNext()) {
                            Element e = (Element)it.next();
                            vals[i++] = Long.parseLong(e.getAttributeValue(VALUE));
                        }
                        this.map.put(name, vals);
                    } else if (type.equals("float")) {
                        float[] vals = new float[list.size()];
                        while (it.hasNext()) {
                            Element e = (Element)it.next();
                            vals[i++] = Float.parseFloat(e.getAttributeValue(VALUE));
                        }
                        this.map.put(name, vals);
                    } else if (type.equals("double")) {
                        double[] vals = new double[list.size()];
                        while (it.hasNext()) {
                            Element e = (Element)it.next();
                            vals[i++] = Double.parseDouble(e.getAttributeValue(VALUE));
                        }
                        this.map.put(name, vals);
                    } else if (type.equals("boolean")) {
                        boolean[] vals = new boolean[list.size()];
                        while (it.hasNext()) {
                            Element e = (Element)it.next();
                            vals[i++] = Boolean.valueOf(e.getAttributeValue(VALUE));
                        }
                        this.map.put(name, vals);
                    } else if (type.equals("string")) {
                        String[] vals = new String[list.size()];
                        while (it.hasNext()) {
                            Element e = (Element)it.next();
                            vals[i++] = e.getAttributeValue(VALUE);
                        }
                        this.map.put(name, vals);
                    }
                }
                catch (Exception exc) {
                    Msg.warn((Object)this, (Object)"Error processing array value in GProperties", (Throwable)exc);
                }
            } else if (tag.equals("ENUM")) {
                String className;
                Enum<?> e;
                if (type == null) {
                    return;
                }
                if (type.equals("stringenum")) {
                    return;
                }
                if (type.equals("enum") && (e = this.getEnumValue(className = elem.getAttributeValue("CLASS"), value)) != null) {
                    this.map.put(name, e);
                }
            } else if (tag.equals(GPROPERTIES_TAG)) {
                Element element = (Element)elem.getChildren().get(0);
                if (element != null) {
                    this.map.put(name, new GProperties(element));
                }
            } else if (tag.equals("NULL")) {
                this.map.put(name, null);
            }
        }
    }

    private static String getPropertiesName(JsonObject root) {
        if (root.has(LEGACY_PROPERTIES_NAME)) {
            return root.get(LEGACY_PROPERTIES_NAME).getAsString();
        }
        return root.get(PROPERTIES_NAME).getAsString();
    }

    private Object getObjectFromJson(String type, JsonElement value, JsonElement enumClass) {
        switch (type) {
            case "null": {
                return null;
            }
            case "String": {
                return value.getAsString();
            }
            case "Color": {
                return new Color(value.getAsInt());
            }
            case "Date": {
                return this.parseDate(value.getAsString());
            }
            case "File": {
                return new File(value.getAsString());
            }
            case "KeyStroke": {
                return KeyStroke.getKeyStroke(value.getAsString());
            }
            case "Font": {
                return Font.decode(value.getAsString());
            }
            case "byte": {
                return value.getAsByte();
            }
            case "short": {
                return value.getAsShort();
            }
            case "int": {
                return value.getAsInt();
            }
            case "long": {
                return value.getAsLong();
            }
            case "float": {
                return Float.valueOf(value.getAsFloat());
            }
            case "double": {
                return value.getAsDouble();
            }
            case "boolean": {
                return value.getAsBoolean();
            }
            case "byte[]": {
                JsonArray byteArray = value.getAsJsonArray();
                byte[] bytes = new byte[byteArray.size()];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = byteArray.get(i).getAsByte();
                }
                return bytes;
            }
            case "short[]": {
                JsonArray shortArray = value.getAsJsonArray();
                short[] shorts = new short[shortArray.size()];
                for (int i = 0; i < shorts.length; ++i) {
                    shorts[i] = shortArray.get(i).getAsShort();
                }
                return shorts;
            }
            case "int[]": {
                JsonArray intArray = value.getAsJsonArray();
                int[] ints = new int[intArray.size()];
                for (int i = 0; i < ints.length; ++i) {
                    ints[i] = intArray.get(i).getAsInt();
                }
                return ints;
            }
            case "long[]": {
                JsonArray longArray = value.getAsJsonArray();
                long[] longs = new long[longArray.size()];
                for (int i = 0; i < longs.length; ++i) {
                    longs[i] = longArray.get(i).getAsLong();
                }
                return longs;
            }
            case "float[]": {
                JsonArray floatArray = value.getAsJsonArray();
                float[] floats = new float[floatArray.size()];
                for (int i = 0; i < floats.length; ++i) {
                    floats[i] = floatArray.get(i).getAsFloat();
                }
                return floats;
            }
            case "double[]": {
                JsonArray doubleArray = value.getAsJsonArray();
                double[] doubles = new double[doubleArray.size()];
                for (int i = 0; i < doubles.length; ++i) {
                    doubles[i] = doubleArray.get(i).getAsDouble();
                }
                return doubles;
            }
            case "boolean[]": {
                JsonArray boolArray = value.getAsJsonArray();
                boolean[] booleans = new boolean[boolArray.size()];
                for (int i = 0; i < booleans.length; ++i) {
                    booleans[i] = boolArray.get(i).getAsBoolean();
                }
                return booleans;
            }
            case "String[]": {
                JsonArray stringArray = value.getAsJsonArray();
                String[] strings = new String[stringArray.size()];
                for (int i = 0; i < strings.length; ++i) {
                    strings[i] = stringArray.get(i).getAsString();
                }
                return strings;
            }
            case "xml": {
                try {
                    return XmlUtilities.fromString(value.getAsString());
                }
                catch (IOException | JDOMException e) {
                    throw new AssertException("Error processing embedded XML");
                }
            }
            case "enum": {
                String enumClassName = enumClass.getAsString();
                String enumValue = value.getAsString();
                return this.getEnumValue(enumClassName, enumValue);
            }
            case "GProperties": 
            case "SaveState": {
                JsonObject json = (JsonObject)value;
                return new GProperties(json);
            }
        }
        throw new AssertException("Unknown type: " + type);
    }

    private Date parseDate(String dateString) {
        try {
            return DATE_FORMAT.parse(dateString);
        }
        catch (ParseException e) {
            throw new AssertException("Can't parse date string: " + dateString);
        }
    }

    Enum<?> getEnumValue(String enumClassName, String value) {
        try {
            Class<Enum> enumClass = Class.forName(enumClassName).asSubclass(Enum.class);
            Method m = enumClass.getMethod("valueOf", String.class);
            if (m != null) {
                return (Enum)m.invoke(null, value);
            }
        }
        catch (Exception e) {
            Msg.warn((Object)this, (Object)("Can't find field " + value + " in enum class " + enumClassName), (Throwable)e);
        }
        return null;
    }

    public void saveToJsonFile(File file) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject saveToJson = this.saveToJson();
        try (FileWriter writer = new FileWriter(file);){
            writer.write(gson.toJson((JsonElement)saveToJson));
        }
    }

    public void saveToXmlFile(File file) throws IOException {
        Element saveToXml = this.saveToXml();
        byte[] bytes = XmlUtilities.xmlToByteArray(saveToXml);
        FileUtilities.writeBytes((File)file, (byte[])bytes);
    }

    public Element saveToXml() {
        Element root = new Element(this.propertiesName);
        for (String key : this.map.keySet()) {
            Object value = this.map.get(key);
            Element elem = this.createElement(key, value);
            root.addContent((Content)elem);
        }
        return root;
    }

    protected Element createElement(String key, Object value) {
        Element elem = null;
        if (value instanceof Element) {
            elem = this.createElementFromElement(key, (Element)value);
        } else if (value instanceof Byte) {
            elem = this.setAttributes(key, "byte", ((Byte)value).toString());
        } else if (value instanceof Short) {
            elem = this.setAttributes(key, "short", ((Short)value).toString());
        } else if (value instanceof Integer) {
            elem = this.setAttributes(key, "int", ((Integer)value).toString());
        } else if (value instanceof Long) {
            elem = this.setAttributes(key, "long", ((Long)value).toString());
        } else if (value instanceof Float) {
            elem = this.setAttributes(key, "float", ((Float)value).toString());
        } else if (value instanceof Double) {
            elem = this.setAttributes(key, "double", ((Double)value).toString());
        } else if (value instanceof Boolean) {
            elem = this.setAttributes(key, "boolean", ((Boolean)value).toString());
        } else if (value instanceof String) {
            elem = new Element(STATE);
            elem.setAttribute(NAME, key);
            elem.setAttribute(TYPE, "string");
            if (XmlUtilities.hasInvalidXMLCharacters((String)value)) {
                elem.setAttribute("ENCODED_VALUE", NumericUtilities.convertBytesToString(((String)value).getBytes(StandardCharsets.UTF_8)));
            } else {
                elem.setAttribute(VALUE, (String)value);
            }
        } else if (value instanceof Color) {
            elem = this.setAttributes(key, "Color", Integer.toString(((Color)value).getRGB()));
        } else if (value instanceof Date) {
            elem = this.setAttributes(key, "Date", DATE_FORMAT.format((Date)value));
        } else if (value instanceof File) {
            elem = this.setAttributes(key, "File", ((File)value).getAbsolutePath());
        } else if (value instanceof KeyStroke) {
            elem = this.setAttributes(key, "KeyStroke", value.toString());
        } else if (value instanceof Font) {
            Font font = (Font)value;
            elem = this.setAttributes(key, "Font", this.toFontString(font));
        } else if (value instanceof byte[]) {
            elem = new Element("BYTES");
            elem.setAttribute(NAME, key);
            elem.setAttribute(VALUE, NumericUtilities.convertBytesToString((byte[])value));
        } else if (value instanceof short[]) {
            elem = this.setArrayAttributes(key, "short", value);
        } else if (value instanceof int[]) {
            elem = this.setArrayAttributes(key, "int", value);
        } else if (value instanceof long[]) {
            elem = this.setArrayAttributes(key, "long", value);
        } else if (value instanceof float[]) {
            elem = this.setArrayAttributes(key, "float", value);
        } else if (value instanceof double[]) {
            elem = this.setArrayAttributes(key, "double", value);
        } else if (value instanceof boolean[]) {
            elem = this.setArrayAttributes(key, "boolean", value);
        } else if (value instanceof String[]) {
            elem = this.setArrayAttributes(key, "string", value);
        } else if (value instanceof Enum) {
            Enum e = (Enum)value;
            elem = new Element("ENUM");
            elem.setAttribute(NAME, key);
            elem.setAttribute(TYPE, "enum");
            elem.setAttribute("CLASS", e.getClass().getName());
            elem.setAttribute(VALUE, e.name());
        } else if (value instanceof GProperties) {
            Element savedElement = ((GProperties)value).saveToXml();
            elem = new Element(GPROPERTIES_TAG);
            elem.setAttribute(NAME, key);
            elem.setAttribute(TYPE, G_PROPERTIES_TYPE);
            elem.addContent((Content)savedElement);
        } else {
            elem = new Element("NULL");
            elem.setAttribute(NAME, key);
        }
        return elem;
    }

    private <T> Element setArrayAttributes(String key, String type, Object values) {
        Element elem = new Element("ARRAY");
        elem.setAttribute(NAME, key);
        elem.setAttribute(TYPE, type);
        for (int i = 0; i < Array.getLength(values); ++i) {
            Object value = Array.get(values, i);
            if (value == null) continue;
            Element arrElem = new Element(ARRAY_ELEMENT_NAME);
            arrElem.setAttribute(VALUE, value.toString());
            elem.addContent((Content)arrElem);
        }
        return elem;
    }

    private Element setAttributes(String key, String type, String value) {
        Element elem = new Element(STATE);
        elem.setAttribute(NAME, key);
        elem.setAttribute(TYPE, type);
        elem.setAttribute(VALUE, value);
        return elem;
    }

    public JsonObject saveToJson() {
        JsonObject types = new JsonObject();
        JsonObject values = new JsonObject();
        JsonObject enumClasses = new JsonObject();
        for (String key : this.map.keySet()) {
            JsonArray ja;
            Object value = this.map.get(key);
            if (value == null) {
                types.addProperty(key, "null");
                values.addProperty(key, "null");
                continue;
            }
            if (value instanceof Element) {
                types.addProperty(key, "xml");
                String outputString = new XMLOutputter().outputString((Element)value);
                values.addProperty(key, outputString);
                continue;
            }
            if (value instanceof Color) {
                types.addProperty(key, "Color");
                values.addProperty(key, (Number)((Color)value).getRGB());
                continue;
            }
            if (value instanceof Date) {
                types.addProperty(key, "Date");
                values.addProperty(key, DATE_FORMAT.format((Date)value));
                continue;
            }
            if (value instanceof File) {
                types.addProperty(key, "File");
                values.addProperty(key, ((File)value).getAbsolutePath());
                continue;
            }
            if (value instanceof KeyStroke) {
                types.addProperty(key, "KeyStroke");
                values.addProperty(key, value.toString());
                continue;
            }
            if (value instanceof Font) {
                Font font = (Font)value;
                types.addProperty(key, "Font");
                values.addProperty(key, this.toFontString(font));
                continue;
            }
            if (value instanceof Byte) {
                types.addProperty(key, "byte");
                values.addProperty(key, (Number)((Byte)value));
                continue;
            }
            if (value instanceof Short) {
                types.addProperty(key, "short");
                values.addProperty(key, (Number)((Short)value));
                continue;
            }
            if (value instanceof Integer) {
                types.addProperty(key, "int");
                values.addProperty(key, (Number)((Integer)value));
                continue;
            }
            if (value instanceof Long) {
                types.addProperty(key, "long");
                values.addProperty(key, (Number)((Long)value));
                continue;
            }
            if (value instanceof Float) {
                types.addProperty(key, "float");
                values.addProperty(key, (Number)((Float)value));
                continue;
            }
            if (value instanceof Double) {
                types.addProperty(key, "double");
                values.addProperty(key, (Number)((Double)value));
                continue;
            }
            if (value instanceof Boolean) {
                types.addProperty(key, "boolean");
                values.addProperty(key, (Boolean)value);
                continue;
            }
            if (value instanceof String) {
                types.addProperty(key, "String");
                values.addProperty(key, (String)value);
                continue;
            }
            if (value instanceof byte[]) {
                ja = new JsonArray();
                for (byte by : (byte[])value) {
                    ja.add((Number)by);
                }
                types.addProperty(key, "byte[]");
                values.add(key, (JsonElement)ja);
                continue;
            }
            if (value instanceof short[]) {
                ja = new JsonArray();
                for (short s : (short[])value) {
                    ja.add((Number)s);
                }
                types.addProperty(key, "short[]");
                values.add(key, (JsonElement)ja);
                continue;
            }
            if (value instanceof int[]) {
                ja = new JsonArray();
                for (int n : (int[])value) {
                    ja.add((Number)n);
                }
                types.addProperty(key, "int[]");
                values.add(key, (JsonElement)ja);
                continue;
            }
            if (value instanceof long[]) {
                ja = new JsonArray();
                for (long l : (long[])value) {
                    ja.add((Number)l);
                }
                types.addProperty(key, "long[]");
                values.add(key, (JsonElement)ja);
                continue;
            }
            if (value instanceof float[]) {
                ja = new JsonArray();
                for (float f : (float[])value) {
                    ja.add((Number)Float.valueOf(f));
                }
                types.addProperty(key, "float[]");
                values.add(key, (JsonElement)ja);
                continue;
            }
            if (value instanceof double[]) {
                ja = new JsonArray();
                for (double d : (double[])value) {
                    ja.add((Number)d);
                }
                types.addProperty(key, "double[]");
                values.add(key, (JsonElement)ja);
                continue;
            }
            if (value instanceof boolean[]) {
                ja = new JsonArray();
                for (boolean bl : (boolean[])value) {
                    ja.add(Boolean.valueOf(bl));
                }
                types.addProperty(key, "boolean[]");
                values.add(key, (JsonElement)ja);
                continue;
            }
            if (value instanceof String[]) {
                ja = new JsonArray();
                for (String string : (String[])value) {
                    if (string == null) continue;
                    ja.add(string);
                }
                types.addProperty(key, "String[]");
                values.add(key, (JsonElement)ja);
                continue;
            }
            if (value instanceof Enum) {
                Enum e = (Enum)value;
                types.addProperty(key, "enum");
                enumClasses.addProperty(key, e.getClass().getName());
                values.addProperty(key, e.name());
                continue;
            }
            if (value instanceof GProperties) {
                types.addProperty(key, G_PROPERTIES_TYPE);
                JsonObject json = ((GProperties)value).saveToJson();
                values.add(key, (JsonElement)json);
                continue;
            }
            throw new AssertException("found unsupported object type: " + value.getClass());
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(PROPERTIES_NAME, this.propertiesName);
        jsonObject.add("VALUES", (JsonElement)values);
        jsonObject.add("TYPES", (JsonElement)types);
        jsonObject.add("ENUM_CLASSES", (JsonElement)enumClasses);
        return jsonObject;
    }

    protected Element createElementFromElement(String internalKey, Element internalElement) {
        Element newElement = new Element("XML");
        newElement.setAttribute(NAME, internalKey);
        Element internalElementClone = (Element)internalElement.clone();
        newElement.addContent((Content)internalElementClone);
        return newElement;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void remove(String name) {
        this.map.remove(name);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public String[] getNames() {
        String[] names = new String[this.map.size()];
        int idx = 0;
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            names[idx] = iter.next();
            ++idx;
        }
        return names;
    }

    void putObject(String name, Object obj) {
        this.map.put(name, obj);
    }

    Object getObject(String name) {
        return this.map.get(name);
    }

    public void putInt(String name, int value) {
        this.map.put(name, value);
    }

    public void putByte(String name, byte value) {
        this.map.put(name, value);
    }

    public void putShort(String name, short value) {
        this.map.put(name, value);
    }

    public void putLong(String name, long value) {
        this.map.put(name, value);
    }

    public void putString(String name, String value) {
        this.map.put(name, value);
    }

    public void putColor(String name, Color value) {
        this.map.put(name, value);
    }

    public void putDate(String name, Date value) {
        this.map.put(name, value);
    }

    public void putFile(String name, File value) {
        this.map.put(name, value);
    }

    public void putKeyStroke(String name, KeyStroke value) {
        this.map.put(name, value);
    }

    public void putFont(String name, Font value) {
        this.map.put(name, value);
    }

    public void putBoolean(String name, boolean value) {
        this.map.put(name, value);
    }

    public void putFloat(String name, float value) {
        this.map.put(name, Float.valueOf(value));
    }

    public void putDouble(String name, double value) {
        this.map.put(name, value);
    }

    public void putGProperties(String name, GProperties value) {
        this.map.put(name, value);
    }

    public int getInt(String name, int defaultValue) {
        return this.getAsType(name, defaultValue, Integer.class);
    }

    public byte getByte(String name, byte defaultValue) {
        return this.getAsType(name, defaultValue, Byte.class);
    }

    public short getShort(String name, short defaultValue) {
        return this.getAsType(name, defaultValue, Short.class);
    }

    public long getLong(String name, long defaultValue) {
        return this.getAsType(name, defaultValue, Long.class);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.getAsType(name, defaultValue, Boolean.class);
    }

    public String getString(String name, String defaultValue) {
        return this.getAsType(name, defaultValue, String.class);
    }

    public Color getColor(String name, Color defaultValue) {
        return this.getAsType(name, defaultValue, Color.class);
    }

    public Date getDate(String name, Date defaultValue) {
        return this.getAsType(name, defaultValue, Date.class);
    }

    public File getFile(String name, File defaultValue) {
        return this.getAsType(name, defaultValue, File.class);
    }

    public KeyStroke getKeyStroke(String name, KeyStroke defaultValue) {
        return this.getAsType(name, defaultValue, KeyStroke.class);
    }

    public Font getFont(String name, Font defaultValue) {
        return this.getAsType(name, defaultValue, Font.class);
    }

    public float getFloat(String name, float defaultValue) {
        return this.getAsType(name, Float.valueOf(defaultValue), Float.class).floatValue();
    }

    public double getDouble(String name, double defaultValue) {
        return this.getAsType(name, defaultValue, Double.class);
    }

    public void putInts(String name, int[] value) {
        this.map.put(name, value);
    }

    public void putBytes(String name, byte[] value) {
        this.map.put(name, value);
    }

    public void putShorts(String name, short[] value) {
        this.map.put(name, value);
    }

    public void putLongs(String name, long[] value) {
        this.map.put(name, value);
    }

    public void putStrings(String name, String[] value) {
        this.map.put(name, value);
    }

    public void putEnum(String name, Enum<?> value) {
        if ((value.getClass().getModifiers() & 1) == 0) {
            throw new IllegalArgumentException("enum '" + value.name() + "' must be public");
        }
        this.map.put(name, value);
    }

    public void putBooleans(String name, boolean[] value) {
        this.map.put(name, value);
    }

    public void putFloats(String name, float[] value) {
        this.map.put(name, value);
    }

    public void putDoubles(String name, double[] value) {
        this.map.put(name, value);
    }

    public int[] getInts(String name, int[] defaultValue) {
        return this.map.containsKey(name) ? (int[])this.map.get(name) : defaultValue;
    }

    public byte[] getBytes(String name, byte[] defaultValue) {
        return this.map.containsKey(name) ? (byte[])this.map.get(name) : defaultValue;
    }

    public short[] getShorts(String name, short[] defaultValue) {
        return this.map.containsKey(name) ? (short[])this.map.get(name) : defaultValue;
    }

    public long[] getLongs(String name, long[] defaultValue) {
        return this.map.containsKey(name) ? (long[])this.map.get(name) : defaultValue;
    }

    public boolean[] getBooleans(String name, boolean[] defaultValue) {
        return this.map.containsKey(name) ? (boolean[])this.map.get(name) : defaultValue;
    }

    public String[] getStrings(String name, String[] defaultValue) {
        return this.map.containsKey(name) ? (String[])this.map.get(name) : defaultValue;
    }

    public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        if (defaultValue != null && (defaultValue.getClass().getModifiers() & 1) == 0) {
            throw new IllegalArgumentException("enum '" + defaultValue.name() + "' must be public");
        }
        try {
            if (this.map.containsKey(name)) {
                return (T)((Enum)this.map.get(name));
            }
        }
        catch (ClassCastException e) {
            this.map.put(name, defaultValue);
        }
        return defaultValue;
    }

    public float[] getFloats(String name, float[] defaultValue) {
        return this.map.containsKey(name) ? (float[])this.map.get(name) : defaultValue;
    }

    public double[] getDoubles(String name, double[] defaultValue) {
        return this.map.containsKey(name) ? (double[])this.map.get(name) : defaultValue;
    }

    public boolean hasValue(String name) {
        return this.map.containsKey(name);
    }

    public void putXmlElement(String name, Element element) {
        this.map.put(name, element);
    }

    public Element getXmlElement(String name) {
        return this.getAsType(name, null, Element.class);
    }

    public GProperties getGProperties(String name) {
        return this.getAsType(name, null, GProperties.class);
    }

    public String toString() {
        return XmlUtilities.toString(this.saveToXml());
    }

    protected <T> T getAsType(String name, T defaultValue, Class<T> clazz) {
        Object value;
        if (this.map.containsKey(name) && this.isExpectedType(name, value = this.map.get(name), clazz)) {
            return clazz.cast(value);
        }
        return defaultValue;
    }

    private boolean isExpectedType(String name, Object value, Class<?> expectedType) {
        if (value != null && !expectedType.isInstance(value)) {
            Msg.debug((Object)this, (Object)("Type mismatch on GProperties property \"" + name + "\". Attempted to retrieve value as a " + expectedType.getName() + " but was of type " + value.getClass().getName()));
            return false;
        }
        return true;
    }

    private String toFontString(Font font) {
        return String.format("%s-%s-%s", font.getName(), this.getStyleString(font), font.getSize());
    }

    private String getStyleString(Font font) {
        boolean bold = font.isBold();
        boolean italic = font.isItalic();
        if (bold && italic) {
            return "BOLDITALIC";
        }
        if (bold) {
            return "BOLD";
        }
        if (italic) {
            return "ITALIC";
        }
        return "PLAIN";
    }
}

