/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.query.protocol.BSimFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BSimFilterSet {
    List<FilterEntry> filterEntries = new ArrayList<FilterEntry>();

    public BSimFilterSet() {
    }

    private BSimFilterSet(BSimFilterSet set) {
        this.filterEntries.addAll(set.filterEntries);
    }

    public void addEntry(BSimFilterType filterType, List<String> values) {
        this.filterEntries.add(new FilterEntry(filterType, values));
    }

    public int size() {
        return this.filterEntries.size();
    }

    public BSimFilter getBSimFilter() {
        BSimFilter bsimFilter = new BSimFilter();
        for (FilterEntry filterEntry : this.filterEntries) {
            BSimFilterType filterType = filterEntry.filterType;
            List<String> values = filterEntry.values;
            for (String filterVal : values) {
                bsimFilter.addAtom(filterType, filterVal.trim());
            }
        }
        return bsimFilter;
    }

    public BSimFilterSet copy() {
        return new BSimFilterSet(this);
    }

    public List<FilterEntry> getFilterEntries() {
        return this.filterEntries;
    }

    public void removeAll(BSimFilterType filterType) {
        Iterator<FilterEntry> it = this.filterEntries.iterator();
        while (it.hasNext()) {
            if (!it.next().filterType.equals(filterType)) continue;
            it.remove();
        }
    }

    public record FilterEntry(BSimFilterType filterType, List<String> values) {
    }
}

