/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import docking.Tool;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.LaunchAction;
import ghidra.app.services.TerminalService;
import ghidra.app.services.TraceRmiLauncherService;
import ghidra.app.services.TraceRmiService;
import ghidra.debug.api.tracermi.TraceRmiLaunchOffer;
import ghidra.debug.spi.tracermi.TraceRmiLaunchOpinion;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.bean.opteditor.OptionsVetoException;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

@PluginInfo(shortDescription="GUI elements to launch targets using Trace RMI", description="Provides menus and toolbar actions to launch Trace RMI targets.\n", category="Debugger", packageName="Debugger", status=PluginStatus.UNSTABLE, eventsConsumed={ProgramActivatedPluginEvent.class, ProgramClosedPluginEvent.class}, servicesRequired={TraceRmiService.class, TerminalService.class}, servicesProvided={TraceRmiLauncherService.class})
public class TraceRmiLauncherServicePlugin
extends Plugin
implements TraceRmiLauncherService,
OptionsChangeListener {
    protected static final String OPTION_NAME_SCRIPT_PATHS = "Script Paths";
    private static final TraceRmiLaunchOffer.LaunchConfigurator RELAUNCH = new TraceRmiLaunchOffer.LaunchConfigurator(){

        public TraceRmiLaunchOffer.PromptMode getPromptMode() {
            return TraceRmiLaunchOffer.PromptMode.ON_ERROR;
        }
    };
    private static final TraceRmiLaunchOffer.LaunchConfigurator PROMPT = new TraceRmiLaunchOffer.LaunchConfigurator(){

        public TraceRmiLaunchOffer.PromptMode getPromptMode() {
            return TraceRmiLaunchOffer.PromptMode.ALWAYS;
        }
    };
    protected final ToolOptions options;
    protected Program currentProgram;
    protected LaunchAction launchAction;
    protected List<DockingActionIf> currentLaunchers = new ArrayList<DockingActionIf>();

    public static File getProgramPath(Program program) {
        if (program == null) {
            return null;
        }
        String path = program.getExecutablePath();
        if (path == null) {
            return null;
        }
        File file = new File(path);
        try {
            if (!file.canExecute()) {
                return null;
            }
            return file.getCanonicalFile();
        }
        catch (IOException | SecurityException e) {
            Msg.error(TraceRmiLauncherServicePlugin.class, (Object)("Cannot examine file " + path), (Throwable)e);
            return null;
        }
    }

    public TraceRmiLauncherServicePlugin(PluginTool tool) {
        super(tool);
        this.options = tool.getOptions("Debugger");
        this.options.addOptionsChangeListener((OptionsChangeListener)this);
        this.createActions();
    }

    protected void init() {
        super.init();
        for (TraceRmiLaunchOpinion opinion : ClassSearcher.getInstances(TraceRmiLaunchOpinion.class)) {
            opinion.registerOptions((Options)this.options);
        }
    }

    protected void createActions() {
        this.launchAction = new LaunchAction(this);
        this.tool.addAction((DockingActionIf)this.launchAction);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) throws OptionsVetoException {
        for (TraceRmiLaunchOpinion opinion : ClassSearcher.getInstances(TraceRmiLaunchOpinion.class)) {
            if (!opinion.requiresRefresh(optionName)) continue;
            this.updateLauncherMenu();
            return;
        }
    }

    public Collection<TraceRmiLaunchOffer> getOffers(Program program) {
        if (program == null) {
            return List.of();
        }
        return ClassSearcher.getInstances(TraceRmiLaunchOpinion.class).stream().flatMap(op -> op.getOffers(this, program).stream()).toList();
    }

    protected void relaunch(TraceRmiLaunchOffer offer) {
        this.tool.execute((Task)new ReLaunchTask(offer));
    }

    protected void configureAndLaunch(TraceRmiLaunchOffer offer) {
        this.tool.execute((Task)new ConfigureAndLaunchTask(offer));
    }

    protected String[] constructLaunchMenuPrefix() {
        return new String[]{"Debugger", "Configure and Launch " + this.currentProgram.getName() + " using..."};
    }

    protected String[] prependConfigAndLaunch(List<String> menuPath) {
        return (String[])Stream.concat(Stream.of(this.constructLaunchMenuPrefix()), menuPath.stream()).toArray(String[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLauncherMenu() {
        List<TraceRmiLaunchOffer> offers = this.currentProgram == null ? List.of() : this.getOffers(this.currentProgram);
        List<DockingActionIf> list = this.currentLaunchers;
        synchronized (list) {
            for (DockingActionIf launcher : this.currentLaunchers) {
                this.tool.removeAction(launcher);
            }
            this.currentLaunchers.clear();
            if (!offers.isEmpty()) {
                this.tool.setMenuGroup(this.constructLaunchMenuPrefix(), "Dbg1. General", "zz");
            }
            for (TraceRmiLaunchOffer offer : offers) {
                this.currentLaunchers.add(((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(offer.getConfigName(), this.getName()).menuPath(this.prependConfigAndLaunch(offer.getMenuPath()))).menuGroup(offer.getMenuGroup(), offer.getMenuOrder())).menuIcon(offer.getIcon())).helpLocation(offer.getHelpLocation())).enabledWhen(ctx -> true)).onAction(ctx -> this.configureAndLaunch(offer))).buildAndInstall((Tool)this.tool));
            }
        }
    }

    public void processEvent(PluginEvent event) {
        ProgramActivatedPluginEvent evt;
        super.processEvent(event);
        if (event instanceof ProgramActivatedPluginEvent) {
            evt = (ProgramActivatedPluginEvent)event;
            this.currentProgram = evt.getActiveProgram();
            this.updateLauncherMenu();
        }
        if (event instanceof ProgramClosedPluginEvent && this.currentProgram == (evt = (ProgramClosedPluginEvent)event).getProgram()) {
            this.currentProgram = null;
            this.updateLauncherMenu();
        }
    }

    private static class ReLaunchTask
    extends AbstractLaunchTask {
        public ReLaunchTask(TraceRmiLaunchOffer offer) {
            super(offer);
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            this.offer.launchProgram(monitor, RELAUNCH);
        }
    }

    private static class ConfigureAndLaunchTask
    extends AbstractLaunchTask {
        public ConfigureAndLaunchTask(TraceRmiLaunchOffer offer) {
            super(offer);
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            this.offer.launchProgram(monitor, PROMPT);
        }
    }

    private static abstract class AbstractLaunchTask
    extends Task {
        final TraceRmiLaunchOffer offer;

        public AbstractLaunchTask(TraceRmiLaunchOffer offer) {
            super(offer.getTitle(), true, true, true);
            this.offer = offer;
        }
    }
}

