/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.connection.tree;

import ghidra.app.plugin.core.debug.gui.tracermi.connection.TraceRmiConnectionManagerProvider;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.AbstractTraceRmiManagerNode;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.TraceRmiAcceptorNode;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.TraceRmiConnectionNode;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.TraceRmiServerNode;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.TraceRmiTargetNode;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.target.TargetPublicationListener;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.debug.api.tracermi.TraceRmiAcceptor;
import ghidra.debug.api.tracermi.TraceRmiConnection;
import ghidra.debug.api.tracermi.TraceRmiServiceListener;
import ghidra.util.Msg;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;

public class TraceRmiServiceNode
extends AbstractTraceRmiManagerNode
implements TraceRmiServiceListener,
TargetPublicationListener {
    private static final String DESCRIPTION = "The TraceRmi service";
    final TraceRmiServerNode serverNode;
    final Map<TraceRmiConnection, TraceRmiConnectionNode> connectionNodes = new HashMap<TraceRmiConnection, TraceRmiConnectionNode>();
    final Map<TraceRmiAcceptor, TraceRmiAcceptorNode> acceptorNodes = new HashMap<TraceRmiAcceptor, TraceRmiAcceptorNode>();
    final Map<Target, TraceRmiTargetNode> targetNodes = new WeakHashMap<Target, TraceRmiTargetNode>();

    public TraceRmiServiceNode(TraceRmiConnectionManagerProvider provider) {
        super(provider, "<root>");
        this.serverNode = new TraceRmiServerNode(provider);
        this.addNode(this.serverNode);
    }

    public Icon getIcon(boolean expanded) {
        return null;
    }

    public String getToolTip() {
        return DESCRIPTION;
    }

    public boolean isLeaf() {
        return false;
    }

    private TraceRmiConnectionNode newConnectionNode(TraceRmiConnection connection) {
        return new TraceRmiConnectionNode(this.provider, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnectionNode(TraceRmiConnection connection) {
        TraceRmiConnectionNode node;
        Map<TraceRmiConnection, TraceRmiConnectionNode> map = this.connectionNodes;
        synchronized (map) {
            node = this.connectionNodes.computeIfAbsent(connection, this::newConnectionNode);
        }
        this.addNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnectionNode(TraceRmiConnection connection) {
        TraceRmiConnectionNode node;
        Map<TraceRmiConnection, TraceRmiConnectionNode> map = this.connectionNodes;
        synchronized (map) {
            node = this.connectionNodes.remove(connection);
        }
        if (node == null) {
            return;
        }
        this.removeNode(node);
    }

    private TraceRmiAcceptorNode newAcceptorNode(TraceRmiAcceptor acceptor) {
        return new TraceRmiAcceptorNode(this.provider, acceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAcceptorNode(TraceRmiAcceptor acceptor) {
        TraceRmiAcceptorNode node;
        Map<TraceRmiAcceptor, TraceRmiAcceptorNode> map = this.acceptorNodes;
        synchronized (map) {
            node = this.acceptorNodes.computeIfAbsent(acceptor, this::newAcceptorNode);
        }
        this.addNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAcceptorNode(TraceRmiAcceptor acceptor) {
        TraceRmiAcceptorNode node;
        Map<TraceRmiAcceptor, TraceRmiAcceptorNode> map = this.acceptorNodes;
        synchronized (map) {
            node = this.acceptorNodes.remove(acceptor);
        }
        if (node == null) {
            return;
        }
        this.removeNode(node);
    }

    public void serverStarted(SocketAddress address) {
        this.serverNode.fireNodeChanged();
        this.provider.contextChanged();
    }

    public void serverStopped() {
        this.serverNode.fireNodeChanged();
        this.provider.contextChanged();
    }

    public void connected(TraceRmiConnection connection, TraceRmiServiceListener.ConnectMode mode, TraceRmiAcceptor acceptor) {
        this.addConnectionNode(connection);
        this.removeAcceptorNode(acceptor);
        this.provider.contextChanged();
    }

    public void disconnected(TraceRmiConnection connection) {
        this.removeConnectionNode(connection);
        this.provider.contextChanged();
    }

    public void waitingAccept(TraceRmiAcceptor acceptor) {
        this.addAcceptorNode(acceptor);
        this.provider.contextChanged();
    }

    public void acceptCancelled(TraceRmiAcceptor acceptor) {
        this.removeAcceptorNode(acceptor);
        this.provider.contextChanged();
    }

    public void acceptFailed(TraceRmiAcceptor acceptor, Exception e) {
        this.removeAcceptorNode(acceptor);
        this.provider.contextChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetPublished(TraceRmiConnection connection, Target target) {
        TraceRmiConnectionNode cxNode;
        Map<TraceRmiConnection, TraceRmiConnectionNode> map = this.connectionNodes;
        synchronized (map) {
            cxNode = this.connectionNodes.get(connection);
        }
        if (cxNode == null) {
            Msg.warn((Object)this, (Object)("Target published on a connection I don't have! " + connection + " " + target));
            return;
        }
        TraceRmiTargetNode tNode = cxNode.targetPublished(target);
        if (tNode == null) {
            return;
        }
        Map<Target, TraceRmiTargetNode> map2 = this.targetNodes;
        synchronized (map2) {
            this.targetNodes.put(target, tNode);
        }
        this.provider.contextChanged();
    }

    public void targetPublished(Target target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetWithdrawn(Target target) {
        TraceRmiTargetNode node;
        Map<Target, TraceRmiTargetNode> map = this.targetNodes;
        synchronized (map) {
            node = this.targetNodes.remove(target);
        }
        if (node == null) {
            return;
        }
        node.getConnectionNode().targetWithdrawn(target);
        this.provider.contextChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coordinates(DebuggerCoordinates coordinates) {
        TraceRmiTargetNode node;
        Target target = coordinates.getTarget();
        if (target == null) {
            return;
        }
        Map<Target, TraceRmiTargetNode> map = this.targetNodes;
        synchronized (map) {
            node = this.targetNodes.get(target);
        }
        if (node == null) {
            return;
        }
        node.fireNodeChanged();
    }
}

