/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.app.plugin.core.debug.stack.AnalysisUnwoundFrame;
import ghidra.app.plugin.core.debug.stack.StackUnwinder;
import ghidra.app.plugin.core.debug.stack.UnwindInfo;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.cmd.TypedBackgroundCommand;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.exec.DebuggerPcodeUtils;
import ghidra.trace.model.Trace;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class UnwindStackCommand
extends TypedBackgroundCommand<Trace> {
    private final PluginTool tool;
    private final DebuggerCoordinates where;

    public UnwindStackCommand(PluginTool tool, DebuggerCoordinates where) {
        super("Unwind Stack", false, true, false);
        this.tool = tool;
        this.where = where;
    }

    public boolean applyToTyped(Trace obj, TaskMonitor monitor) {
        try {
            StackUnwinder unwinder = new StackUnwinder(this.tool, this.where.getPlatform());
            int prevParamSize = 0;
            for (AnalysisUnwoundFrame<DebuggerPcodeUtils.WatchValue> frame : unwinder.frames(this.where.frame(0), monitor)) {
                UnwindInfo info = frame.getUnwindInfo();
                if (info != null && info.error() == null) {
                    frame.applyToListing(prevParamSize, monitor);
                    prevParamSize = info.computeParamSize();
                    continue;
                }
                this.tool.setStatusInfo(frame.getError().getMessage());
            }
            return true;
        }
        catch (CancelledException e) {
            return true;
        }
    }
}

