/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model.record;

import ghidra.app.plugin.core.debug.service.model.RecorderPermanentTransaction;
import ghidra.async.AsyncFence;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetSymbol;
import ghidra.dbg.target.TargetSymbolNamespace;
import ghidra.dbg.util.PathUtils;
import ghidra.debug.api.model.TraceRecorder;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.SourceType;
import ghidra.trace.model.Trace;
import ghidra.trace.model.symbol.TraceEquate;
import ghidra.trace.model.symbol.TraceEquateManager;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceSymbolManager;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class SymbolRecorder {
    private final TraceRecorder recorder;
    private final Trace trace;

    public SymbolRecorder(TraceRecorder recorder) {
        this.recorder = recorder;
        this.trace = recorder.getTrace();
    }

    public CompletableFuture<Void> captureSymbols(TargetSymbolNamespace namespace, TaskMonitor monitor) {
        String path = PathUtils.toString((List)namespace.getPath());
        monitor.setMessage("Capturing symbols for " + path);
        return namespace.getSymbols().thenAccept(symbols -> {
            try (RecorderPermanentTransaction tid = RecorderPermanentTransaction.start((UndoableDomainObject)this.trace, "Capture types and symbols for " + path);){
                TraceNamespaceSymbol ns = this.createNamespaceIfAbsent(path);
                monitor.setMessage("Capturing symbols for " + path);
                monitor.initialize((long)symbols.size());
                TraceEquateManager equateManager = this.trace.getEquateManager();
                for (TargetSymbol sym : symbols) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    monitor.incrementProgress(1L);
                    String symName = sym.getIndex();
                    if (sym.isConstant()) {
                        TraceEquate equate = equateManager.getByName(symName);
                        long symVal = sym.getValue().getOffset();
                        if (equate != null && equate.getValue() == symVal) continue;
                        try {
                            equateManager.create(symName, symVal);
                        }
                        catch (DuplicateNameException | IllegalArgumentException e) {
                            Msg.error((Object)this, (Object)("Could not create equate: " + symName), (Throwable)e);
                        }
                        continue;
                    }
                    Address addr = this.recorder.getMemoryMapper().targetToTrace(sym.getValue());
                    try {
                        this.trace.getSymbolManager().labels().create(this.recorder.getSnap(), null, addr, symName, ns, SourceType.IMPORTED);
                    }
                    catch (InvalidInputException e) {
                        Msg.error((Object)this, (Object)("Could not add module symbol " + sym + ": " + e));
                    }
                }
            }
        });
    }

    public CompletableFuture<Void> captureSymbols(TargetModule targetModule, TaskMonitor monitor) {
        CompletableFuture future = targetModule.fetchChildrenSupporting(TargetSymbolNamespace.class);
        return future.thenCompose(namespaces -> {
            AsyncFence fence = new AsyncFence();
            for (TargetSymbolNamespace ns : namespaces.values()) {
                fence.include(this.captureSymbols(ns, monitor));
            }
            return fence.ready();
        });
    }

    private TraceNamespaceSymbol createNamespaceIfAbsent(String path) {
        TraceSymbolManager symbolManager = this.trace.getSymbolManager();
        try {
            return symbolManager.namespaces().add(path, symbolManager.getGlobalNamespace(), SourceType.IMPORTED);
        }
        catch (DuplicateNameException e) {
            Msg.info((Object)this, (Object)("Namespace for module " + path + " already exists or another exists with a conflicting name. Using the existing one: " + e));
            TraceNamespaceSymbol ns = (TraceNamespaceSymbol)symbolManager.namespaces().getGlobalNamed(path);
            if (ns != null) {
                return ns;
            }
            Msg.error((Object)this, (Object)("Existing namespace for " + path + " is not a plain namespace. Using global namespace."));
            return symbolManager.getGlobalNamespace();
        }
        catch (InvalidInputException | IllegalArgumentException e) {
            Msg.error((Object)this, (Object)("Could not create namespace for new module: " + path + ". Using global namespace."), (Throwable)e);
            return symbolManager.getGlobalNamespace();
        }
    }
}

