/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.lldb;

import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerMappingOffer;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.debug.api.model.DebuggerMappingOffer;
import ghidra.debug.api.model.DebuggerMappingOpinion;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import ghidra.util.Msg;
import java.util.Set;

public class LldbX86DebuggerMappingOpinion
implements DebuggerMappingOpinion {
    protected static final LanguageID LANG_ID_X86 = new LanguageID("x86:LE:32:default");
    protected static final LanguageID LANG_ID_X86_64 = new LanguageID("x86:LE:64:default");
    protected static final CompilerSpecID COMP_ID_DEFAULT = new CompilerSpecID("default");
    protected static final CompilerSpecID COMP_ID_GCC = new CompilerSpecID("gcc");
    protected static final CompilerSpecID COMP_ID_VS = new CompilerSpecID("windows");

    public Set<DebuggerMappingOffer> offersForEnv(TargetEnvironment env, TargetObject target, boolean includeOverrides) {
        if (!(target instanceof TargetProcess)) {
            return Set.of();
        }
        TargetProcess process = (TargetProcess)target;
        if (!env.getDebugger().toLowerCase().contains("lldb")) {
            return Set.of();
        }
        String arch = env.getArchitecture();
        boolean is32Bit = arch.contains("x86-32") || arch.contains("i386") || arch.contains("x86_32");
        boolean is64Bit = arch.contains("x86-64") || arch.contains("x64-32") || arch.contains("x86_64") || arch.contains("x64_32") || arch.contains("i686");
        String os = env.getOperatingSystem();
        if (os.contains("macos")) {
            if (is64Bit) {
                Msg.info((Object)this, (Object)("Using os=" + os + " arch=" + arch));
                return Set.of(new LldbI386X86_64MacosOffer(process));
            }
            if (is32Bit) {
                Msg.info((Object)this, (Object)("Using os=" + os + " arch=" + arch));
                return Set.of(new LldbI386MacosOffer(process));
            }
            return Set.of();
        }
        if (os.contains("Linux") || os.contains("linux")) {
            if (is64Bit) {
                Msg.info((Object)this, (Object)("Using os=" + os + " arch=" + arch));
                return Set.of(new LldbI386X86_64LinuxOffer(process));
            }
            if (is32Bit) {
                Msg.info((Object)this, (Object)("Using os=" + os + " arch=" + arch));
                return Set.of(new LldbI386LinuxOffer(process));
            }
            return Set.of();
        }
        if (os.contains("windows")) {
            if (is64Bit) {
                Msg.info((Object)this, (Object)("Using os=" + os + " arch=" + arch));
                return Set.of(new LldbI386X86_64WindowsOffer(process));
            }
            if (is32Bit) {
                Msg.info((Object)this, (Object)("Using os=" + os + " arch=" + arch));
                return Set.of(new LldbI386WindowsOffer(process));
            }
            return Set.of();
        }
        return Set.of();
    }

    protected static class LldbI386X86_64MacosOffer
    extends DefaultDebuggerMappingOffer {
        public LldbI386X86_64MacosOffer(TargetProcess process) {
            super((TargetObject)process, 100, "LLDB on macOS x86_64", LANG_ID_X86_64, COMP_ID_GCC, Set.of());
        }
    }

    protected static class LldbI386MacosOffer
    extends DefaultDebuggerMappingOffer {
        public LldbI386MacosOffer(TargetProcess process) {
            super((TargetObject)process, 100, "LLDB on macOS i386", LANG_ID_X86, COMP_ID_GCC, Set.of());
        }
    }

    protected static class LldbI386X86_64LinuxOffer
    extends DefaultDebuggerMappingOffer {
        public LldbI386X86_64LinuxOffer(TargetProcess process) {
            super((TargetObject)process, 100, "LLDB on Linux x86_64", LANG_ID_X86_64, COMP_ID_GCC, Set.of());
        }
    }

    protected static class LldbI386LinuxOffer
    extends DefaultDebuggerMappingOffer {
        public LldbI386LinuxOffer(TargetProcess process) {
            super((TargetObject)process, 100, "LLDB on Linux i386", LANG_ID_X86, COMP_ID_GCC, Set.of());
        }
    }

    protected static class LldbI386X86_64WindowsOffer
    extends DefaultDebuggerMappingOffer {
        public LldbI386X86_64WindowsOffer(TargetProcess process) {
            super((TargetObject)process, 100, "LLDB on Windows x64", LANG_ID_X86_64, COMP_ID_VS, Set.of());
        }
    }

    protected static class LldbI386WindowsOffer
    extends DefaultDebuggerMappingOffer {
        public LldbI386WindowsOffer(TargetProcess process) {
            super((TargetObject)process, 100, "LLDB on Windows i386", LANG_ID_X86, COMP_ID_VS, Set.of());
        }
    }
}

