/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping.legacy;

import ghidra.app.plugin.core.debug.disassemble.DisassemblyInject;
import ghidra.app.plugin.core.debug.mapping.AbstractDebuggerPlatformMapper;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOffer;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOpinion;
import ghidra.debug.api.platform.DebuggerPlatformMapper;
import ghidra.framework.plugintool.PluginTool;
import ghidra.lifecycle.Transitional;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.util.classfinder.ClassSearcher;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;

@Transitional
public class LegacyDebuggerPlatformOpinion
implements DebuggerPlatformOpinion {
    @Override
    public Set<DebuggerPlatformOffer> getOffers(Trace trace, TraceObject focus, long snap, boolean includeOverrides) {
        if (trace.getObjectManager().getRootObject() != null) {
            return Set.of();
        }
        return Set.of(Offers.LEGACY);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Offers implements DebuggerPlatformOffer
    {
        LEGACY{

            @Override
            public String getDescription() {
                return "Legacy (Already mapped by recorder)";
            }

            @Override
            public int getConfidence() {
                return 1;
            }

            @Override
            public CompilerSpec getCompilerSpec() {
                return null;
            }

            @Override
            public DebuggerPlatformMapper take(PluginTool tool, Trace trace) {
                return new LegacyDebuggerPlatformMapper(tool, trace);
            }

            @Override
            public boolean isCreatorOf(DebuggerPlatformMapper mapper) {
                return mapper.getClass() == LegacyDebuggerPlatformMapper.class;
            }
        };

    }

    protected static class LegacyDebuggerPlatformMapper
    extends AbstractDebuggerPlatformMapper {
        public LegacyDebuggerPlatformMapper(PluginTool tool, Trace trace) {
            super(tool, trace);
        }

        public CompilerSpec getCompilerSpec(TraceObject object) {
            return this.trace.getBaseCompilerSpec();
        }

        public void addToTrace(long snap) {
        }

        @Override
        public boolean canInterpret(TraceObject newFocus, long snap) {
            return true;
        }

        @Override
        protected Collection<DisassemblyInject> getDisassemblyInjections(TraceObject object) {
            return ClassSearcher.getInstances(DisassemblyInject.class).stream().filter(i -> i.isApplicable(this.trace)).sorted(Comparator.comparing(i -> i.getPriority())).collect(Collectors.toList());
        }
    }
}

