/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.stack.vars;

import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.debug.stack.AnalysisUnwoundFrame;
import ghidra.app.plugin.core.debug.stack.FakeUnwoundFrame;
import ghidra.app.plugin.core.debug.stack.ListingUnwoundFrame;
import ghidra.app.plugin.core.debug.stack.StackUnwindWarning;
import ghidra.app.plugin.core.debug.stack.StackUnwindWarningSet;
import ghidra.app.plugin.core.debug.stack.StackUnwinder;
import ghidra.app.plugin.core.debug.stack.UnwindException;
import ghidra.app.plugin.core.debug.stack.UnwoundFrame;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.eval.AbstractVarnodeEvaluator;
import ghidra.pcode.exec.DebuggerPcodeUtils;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.opbehavior.UnaryOpBehavior;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AddressSpaceSettingsDefinition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.listing.TraceCodeManager;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.MathUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class VariableValueUtils
extends Enum<VariableValueUtils> {
    private static final /* synthetic */ VariableValueUtils[] $VALUES;

    public static VariableValueUtils[] values() {
        return (VariableValueUtils[])$VALUES.clone();
    }

    public static VariableValueUtils valueOf(String name) {
        return Enum.valueOf(VariableValueUtils.class, name);
    }

    public static AddressRange computeFrameSearchRange(DebuggerCoordinates coordinates) {
        Address max;
        TraceThread thread = coordinates.getThread();
        if (thread == null) {
            return null;
        }
        Trace trace = thread.getTrace();
        long viewSnap = coordinates.getViewSnap();
        TraceMemoryManager mem = trace.getMemoryManager();
        TracePlatform platform = coordinates.getPlatform();
        CompilerSpec cSpec = platform.getCompilerSpec();
        Register sp = cSpec.getStackPointer();
        TraceMemorySpace regs = mem.getMemoryRegisterSpace(thread, 0, false);
        RegisterValue spRV = regs.getValue(platform, viewSnap, sp);
        Address spVal = cSpec.getStackBaseSpace().getAddress(spRV.getUnsignedValue().longValue());
        TraceMemoryRegion stackRegion = mem.getRegionContaining(coordinates.getSnap(), spVal);
        if (stackRegion != null) {
            max = stackRegion.getMaxAddress();
        } else {
            long toMax = spVal.getAddressSpace().getMaxAddress().subtract(spVal);
            max = spVal.add((long)MathUtilities.unsignedMin((int)4095, (long)toMax));
        }
        return new AddressRangeImpl(spVal, max);
    }

    public static ListingUnwoundFrame locateInnermost(PluginTool tool, DebuggerCoordinates coordinates) {
        AddressRange range = VariableValueUtils.computeFrameSearchRange(coordinates);
        if (range == null) {
            return null;
        }
        for (TraceData data : coordinates.getTrace().getCodeManager().definedData().get(coordinates.getViewSnap(), range, true)) {
            try {
                return new ListingUnwoundFrame(tool, coordinates, data);
            }
            catch (UnwindException e) {
                Msg.warn(VariableValueUtils.class, (Object)("Skipping frame " + data + ". " + e));
            }
        }
        return null;
    }

    public static ListingUnwoundFrame locateFrame(PluginTool tool, DebuggerCoordinates coordinates, Function function) {
        int minLevel = coordinates.getFrame();
        AddressRange range = VariableValueUtils.computeFrameSearchRange(coordinates);
        if (range == null) {
            return null;
        }
        for (TraceData data : coordinates.getTrace().getCodeManager().definedData().get(coordinates.getViewSnap(), range, true)) {
            try {
                ListingUnwoundFrame frame = new ListingUnwoundFrame(tool, coordinates, data);
                if (--minLevel >= 0 || frame.getFunction() != function) continue;
                return frame;
            }
            catch (UnwindException e) {
                Msg.warn(VariableValueUtils.class, (Object)("Skipping frame " + data + ". " + e));
            }
        }
        Msg.info(VariableValueUtils.class, (Object)("Cannot find frame for function " + function));
        return null;
    }

    public static boolean requiresFrame(Program program, VariableStorage storage, AddressSetView symbolStorage) {
        return new RequiresFrameEvaluator(symbolStorage).evaluateStorage(program, storage);
    }

    public static boolean requiresFrame(PcodeOp op, AddressSetView symbolStorage) {
        return (Boolean)new RequiresFrameEvaluator(symbolStorage).evaluateOp(null, op);
    }

    public static Address getProgramCounterFromStack(TracePlatform platform, TraceThread thread, long snap) {
        TraceStack stack = thread.getTrace().getStackManager().getStack(thread, snap, false);
        if (stack == null) {
            return null;
        }
        TraceStackFrame frame = stack.getFrame(0, false);
        if (frame == null) {
            return null;
        }
        return frame.getProgramCounter(snap);
    }

    public static Address getProgramCounterFromRegisters(TracePlatform platform, TraceThread thread, long snap) {
        TraceMemorySpace regs = thread.getTrace().getMemoryManager().getMemoryRegisterSpace(thread, false);
        if (regs == null) {
            return null;
        }
        RegisterValue value = regs.getValue(platform, snap, platform.getLanguage().getProgramCounter());
        return platform.getLanguage().getDefaultSpace().getAddress(value.getUnsignedValue().longValue());
    }

    public static Address getProgramCounter(TracePlatform platform, TraceThread thread, long snap) {
        Address pcFromStack = VariableValueUtils.getProgramCounterFromStack(platform, thread, snap);
        if (pcFromStack != null) {
            return pcFromStack;
        }
        return VariableValueUtils.getProgramCounterFromRegisters(platform, thread, snap);
    }

    public static boolean hasFreshUnwind(PluginTool tool, DebuggerCoordinates coordinates) {
        ListingUnwoundFrame innermost = VariableValueUtils.locateInnermost(tool, coordinates);
        return innermost != null && Objects.equals(innermost.getProgramCounter(), VariableValueUtils.getProgramCounter(coordinates.getPlatform(), coordinates.getThread(), coordinates.getViewSnap()));
    }

    public static Variable findVariable(Function function, Register register) {
        for (Variable variable : function.getAllVariables()) {
            if (!variable.isRegisterVariable() || variable.getRegister() != register) continue;
            return variable;
        }
        return null;
    }

    public static Variable findStackVariable(Function function, Address stackAddress) {
        if (!stackAddress.isStackAddress()) {
            throw new IllegalArgumentException("stackAddress is not a stack address");
        }
        return function.getStackFrame().getVariableContaining((int)stackAddress.getOffset());
    }

    public static AddressRange rangeFromVarnode(Varnode vn) {
        return new AddressRangeImpl(vn.getAddress(), vn.getAddress().add((long)(vn.getSize() - 1)));
    }

    public static boolean containsVarnode(AddressSetView set, Varnode vn) {
        return set.contains(vn.getAddress(), vn.getAddress().add((long)(vn.getSize() - 1)));
    }

    public static AddressSet collectSymbolStorage(ClangLine line) {
        AddressSet storage = new AddressSet();
        for (ClangToken tok : line.getAllTokens()) {
            HighSymbol hSym;
            HighVariable hVar;
            Varnode vn = tok.getVarnode();
            if (vn != null) {
                storage.add(VariableValueUtils.rangeFromVarnode(vn));
            }
            if ((hVar = tok.getHighVariable()) == null) continue;
            Varnode rep = hVar.getRepresentative();
            if (rep != null) {
                storage.add(VariableValueUtils.rangeFromVarnode(rep));
            }
            if ((hSym = hVar.getSymbol()) == null) continue;
            for (Varnode stVn : hSym.getStorage().getVarnodes()) {
                storage.add(VariableValueUtils.rangeFromVarnode(stVn));
            }
        }
        return storage;
    }

    public static PcodeOp findDeref(AddressFactory factory, Varnode vn) {
        Iterable it = () -> vn.getDescendants();
        for (PcodeOp desc : it) {
            if (desc.getOpcode() != 2) continue;
            return desc;
        }
        for (PcodeOp desc : it) {
            if (desc.getOpcode() != 3) continue;
            PcodeOpAST op = new PcodeOpAST(desc.getSeqnum(), 2, 2);
            op.setInput(desc.getInput(0), 0);
            op.setInput(desc.getInput(1), 1);
            VarnodeAST out = new VarnodeAST(factory.getUniqueSpace().getAddress(0x80000000L), desc.getInput(2).getSize(), 61453);
            op.setOutput((Varnode)out);
            out.setDef((PcodeOp)op);
            return op;
        }
        return null;
    }

    public static Varnode getInstanceInSymbolStorage(HighVariable hVar) {
        Varnode representative = hVar.getRepresentative();
        HighSymbol hSym = hVar.getSymbol();
        if (hSym == null) {
            return representative;
        }
        AddressSet storageSet = new AddressSet();
        for (Varnode vn : hSym.getStorage().getVarnodes()) {
            storageSet.add(VariableValueUtils.rangeFromVarnode(vn));
        }
        if (VariableValueUtils.containsVarnode((AddressSetView)storageSet, representative)) {
            return representative;
        }
        for (Varnode instance : hVar.getInstances()) {
            if (!VariableValueUtils.containsVarnode((AddressSetView)storageSet, instance)) continue;
            return instance;
        }
        return representative;
    }

    public static VariableStorage fabricateStorage(HighVariable hVar) {
        try {
            return new VariableStorage((ProgramArchitecture)hVar.getHighFunction().getFunction().getProgram(), new Varnode[]{VariableValueUtils.getInstanceInSymbolStorage(hVar)});
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static /* synthetic */ VariableValueUtils[] $values() {
        return new VariableValueUtils[0];
    }

    static {
        $VALUES = VariableValueUtils.$values();
    }

    private static final class RequiresFrameEvaluator
    extends AbstractVarnodeEvaluator<Boolean> {
        private final AddressSetView symbolStorage;

        private RequiresFrameEvaluator(AddressSetView symbolStorage) {
            this.symbolStorage = symbolStorage;
        }

        protected boolean isLeaf(Varnode vn) {
            if (vn.getDef() == null && (vn.isRegister() || vn.isAddress())) {
                return true;
            }
            return vn.isConstant() || this.symbolStorage.contains(vn.getAddress(), vn.getAddress().add((long)(vn.getSize() - 1)));
        }

        protected Address applyBase(long offset) {
            throw new AssertionError();
        }

        protected Boolean evaluateConstant(long value, int size) {
            return false;
        }

        protected Boolean evaluateRegister(Address address, int size) {
            return true;
        }

        protected Boolean evaluateStack(long offset, int size) {
            return true;
        }

        protected Boolean evaluateMemory(Address address, int size) {
            return false;
        }

        protected Boolean evaluateUnique(long offset, int size) {
            return false;
        }

        protected Boolean evaluateAbstract(Program program, AddressSpace space, Boolean offset, int size, Map<Varnode, Boolean> already) {
            return offset;
        }

        protected Boolean evaluateUnaryOp(Program program, PcodeOp op, UnaryOpBehavior unOp, Map<Varnode, Boolean> already) {
            return (Boolean)this.evaluateVarnode(program, op.getInput(0), already);
        }

        protected Boolean evaluateBinaryOp(Program program, PcodeOp op, BinaryOpBehavior binOp, Map<Varnode, Boolean> already) {
            return (Boolean)this.evaluateVarnode(program, op.getInput(0), already) != false || (Boolean)this.evaluateVarnode(program, op.getInput(1), already) != false;
        }

        protected Boolean evaluateLoad(Program program, PcodeOp op, Map<Varnode, Boolean> already) {
            return (Boolean)this.evaluateVarnode(program, op.getInput(1), already);
        }

        protected Boolean evaluatePtrAdd(Program program, PcodeOp op, Map<Varnode, Boolean> already) {
            return this.evaluateBinaryOp(program, op, (BinaryOpBehavior)null, (Map)already);
        }

        protected Boolean evaluatePtrSub(Program program, PcodeOp op, Map<Varnode, Boolean> already) {
            return this.evaluateBinaryOp(program, op, (BinaryOpBehavior)null, (Map)already);
        }

        protected Boolean catenate(int total, Boolean value, Boolean piece, int size) {
            return value != false || piece != false;
        }

        public Boolean evaluateStorage(Program program, VariableStorage storage) {
            return (Boolean)this.evaluateStorage(program, storage, false);
        }
    }

    public static class VariableEvaluator {
        private final Object lock = new Object();
        private final PluginTool tool;
        private final DebuggerCoordinates coordinates;
        private final Language language;
        private final ListenerForChanges listenerForChanges = new ListenerForChanges();
        private List<UnwoundFrame<DebuggerPcodeUtils.WatchValue>> unwound;
        private FakeUnwoundFrame<DebuggerPcodeUtils.WatchValue> fakeFrame;

        public VariableEvaluator(PluginTool tool, DebuggerCoordinates coordinates) {
            this.tool = tool;
            this.coordinates = coordinates;
            this.language = coordinates.getPlatform().getLanguage();
            coordinates.getTrace().addListener((DomainObjectListener)this.listenerForChanges);
        }

        public void dispose() {
            this.coordinates.getTrace().removeListener((DomainObjectListener)this.listenerForChanges);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidateCache() {
            Object object = this.lock;
            synchronized (object) {
                this.unwound = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UnwoundFrame<DebuggerPcodeUtils.WatchValue> getGlobalsFakeFrame() {
            Object object = this.lock;
            synchronized (object) {
                if (this.fakeFrame == null) {
                    this.fakeFrame = new FakeUnwoundFrame<DebuggerPcodeUtils.WatchValue>(this.tool, this.coordinates, DebuggerPcodeUtils.buildWatchState(this.tool, this.coordinates.frame(0)));
                }
                return this.fakeFrame;
            }
        }

        protected void doUnwind(TaskMonitor monitor) {
            monitor.setMessage("Unwinding Stack");
            StackUnwinder unwinder = new StackUnwinder(this.tool, this.coordinates.getPlatform());
            this.unwound = new ArrayList<UnwoundFrame<DebuggerPcodeUtils.WatchValue>>();
            for (AnalysisUnwoundFrame<DebuggerPcodeUtils.WatchValue> frame : unwinder.frames(this.coordinates.frame(0), monitor)) {
                this.unwound.add(frame);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UnwoundFrame<DebuggerPcodeUtils.WatchValue> getStackFrame(Function function, StackUnwindWarningSet warnings, TaskMonitor monitor, boolean required) {
            Object object = this.lock;
            synchronized (object) {
                Object message;
                if (this.unwound == null) {
                    try {
                        this.doUnwind(monitor);
                    }
                    catch (Exception e) {
                        this.unwound = null;
                        throw e;
                    }
                }
                for (UnwoundFrame<DebuggerPcodeUtils.WatchValue> frame : this.unwound.subList(this.coordinates.getFrame(), this.unwound.size())) {
                    if (frame.getFunction() != function) continue;
                    StackUnwindWarningSet unwindWarnings = frame.getWarnings();
                    if (unwindWarnings != null) {
                        warnings.addAll(unwindWarnings);
                    }
                    return frame;
                }
                if (this.unwound.isEmpty()) {
                    message = "Could not recover the innermost frame!";
                } else {
                    message = "There is no frame for %s among the %d frames unwound.".formatted(function, this.unwound.size());
                    Exception error = this.unwound.get(this.unwound.size() - 1).getError();
                    if (error != null) {
                        message = (String)message + "\nTerminating error: %s".formatted(error.getMessage());
                    }
                }
                if (required) {
                    throw new UnwindException((String)message);
                }
                warnings.add(new StackUnwindWarning.CustomStackUnwindWarning((String)message));
                return null;
            }
        }

        public TraceData getRegisterUnit(Register register) {
            TraceCodeManager code;
            TraceCodeManager codeManager = this.coordinates.getTrace().getCodeManager();
            if (register.getAddressSpace().isRegisterSpace()) {
                TraceThread thread = this.coordinates.getThread();
                if (thread == null) {
                    return null;
                }
                code = codeManager.getCodeRegisterSpace(thread, false);
                if (code == null) {
                    return null;
                }
            } else {
                code = codeManager;
            }
            return (TraceData)code.definedData().getForRegister(this.coordinates.getPlatform(), this.coordinates.getViewSnap(), register);
        }

        public DebuggerPcodeUtils.WatchValue getRawRegisterValue(Register register) {
            DebuggerPcodeUtils.WatchValuePcodeExecutorState state = DebuggerPcodeUtils.buildWatchState(this.tool, this.coordinates.frame(0));
            return (DebuggerPcodeUtils.WatchValue)state.getVar(register, PcodeExecutorStatePiece.Reason.INSPECT);
        }

        public String getRepresentation(Address address, byte[] bytes, DataType type, Settings settings) {
            if (type instanceof Pointer && !AddressSpaceSettingsDefinition.DEF.hasValue(settings) && address.isRegisterAddress()) {
                settings = new DefaultSpaceSettings(settings, this.language.getDefaultSpace());
            }
            ByteMemBufferImpl buf = new ByteMemBufferImpl(address, bytes, this.language.isBigEndian()){

                public Memory getMemory() {
                    return coordinates.getView().getMemory();
                }
            };
            return type.getRepresentation((MemBuffer)buf, settings, bytes.length);
        }

        public String getRepresentation(UnwoundFrame<?> frame, Address address, DebuggerPcodeUtils.WatchValue value, DataType type) {
            if (type == DataType.DEFAULT) {
                return null;
            }
            Settings settings = type.getDefaultSettings();
            if (address.isStackAddress()) {
                address = frame.getBasePointer().add(address.getOffset());
                if (frame instanceof ListingUnwoundFrame) {
                    ListingUnwoundFrame listingFrame = (ListingUnwoundFrame)frame;
                    settings = listingFrame.getComponentContaining(address);
                }
            }
            return this.getRepresentation(address, value.bytes().bytes(), type, settings);
        }

        private class ListenerForChanges
        extends TraceDomainObjectListener {
            public ListenerForChanges() {
                this.listenFor((TraceChangeType)Trace.TraceMemoryBytesChangeType.CHANGED, this::bytesChanged);
            }

            private void bytesChanged(TraceAddressSpace space, TraceAddressSnapRange range) {
                TraceThread thread = space.getThread();
                if (thread == null || thread == VariableEvaluator.this.coordinates.getThread()) {
                    VariableEvaluator.this.invalidateCache();
                }
            }
        }
    }

    static class DefaultSpaceSettings
    implements Settings {
        final Settings delegate;
        final AddressSpace space;

        public DefaultSpaceSettings(Settings delegate, AddressSpace space) {
            this.delegate = delegate;
            this.space = space;
        }

        public boolean isChangeAllowed(SettingsDefinition settingsDefinition) {
            return this.delegate.isChangeAllowed(settingsDefinition);
        }

        public Long getLong(String name) {
            return this.delegate.getLong(name);
        }

        public String getString(String name) {
            if (AddressSpaceSettingsDefinition.DEF.getStorageKey().equals(name)) {
                return this.space.getName();
            }
            return this.delegate.getString(name);
        }

        public Object getValue(String name) {
            if (AddressSpaceSettingsDefinition.DEF.getStorageKey().equals(name)) {
                return this.space.getName();
            }
            return this.delegate.getValue(name);
        }

        public void setLong(String name, long value) {
            throw new UnsupportedOperationException();
        }

        public void setString(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public void clearSetting(String name) {
            throw new UnsupportedOperationException();
        }

        public void clearAllSettings() {
            throw new UnsupportedOperationException();
        }

        public String[] getNames() {
            return this.delegate.getNames();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public Settings getDefaultSettings() {
            return this.delegate.getDefaultSettings();
        }
    }
}

