/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.utils.MiscellaneousUtils;
import ghidra.dbg.target.TargetMethod;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.text.StringEscapeUtils;
import org.jdom.Element;

public class DebuggerMethodInvocationDialog
extends DialogComponentProvider
implements PropertyChangeListener {
    private static final String KEY_MEMORIZED_ARGUMENTS = "memorizedArguments";
    private final BidiMap<TargetMethod.ParameterDescription<?>, PropertyEditor> paramEditors = new DualLinkedHashBidiMap();
    private JPanel panel;
    private JLabel descriptionLabel;
    private JPanel pairPanel;
    private PairLayout layout;
    protected JButton invokeButton;
    protected JButton resetButton;
    protected boolean resetRequested;
    private final PluginTool tool;
    Map<String, TargetMethod.ParameterDescription<?>> parameters;
    private Map<NameTypePair, Object> memorized = new HashMap<NameTypePair, Object>();
    private Map<String, ?> arguments;

    public DebuggerMethodInvocationDialog(PluginTool tool, String title, String buttonText, Icon buttonIcon) {
        super(title, true, true, true, false);
        this.tool = tool;
        this.populateComponents(buttonText, buttonIcon);
        this.setRememberSize(false);
    }

    protected Object computeMemorizedValue(TargetMethod.ParameterDescription<?> parameter) {
        return this.memorized.computeIfAbsent(NameTypePair.fromParameter(parameter), ntp -> parameter.defaultValue);
    }

    public Map<String, ?> promptArguments(Map<String, TargetMethod.ParameterDescription<?>> parameterMap) {
        this.setParameters(parameterMap);
        this.tool.showDialog((DialogComponentProvider)this);
        return this.getArguments();
    }

    public void setParameters(Map<String, TargetMethod.ParameterDescription<?>> parameterMap) {
        this.parameters = parameterMap;
        this.populateOptions();
    }

    private void populateComponents(String buttonText, Icon buttonIcon) {
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.layout = new PairLayout(5, 5);
        this.pairPanel = new JPanel((LayoutManager)this.layout);
        JPanel centering = new JPanel(new FlowLayout(1));
        JScrollPane scrolling = new JScrollPane(centering, 20, 31);
        this.panel.add((Component)scrolling, "Center");
        centering.add(this.pairPanel);
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setMaximumSize(new Dimension(300, 100));
        this.panel.add((Component)this.descriptionLabel, "North");
        this.addWorkPanel(this.panel);
        this.invokeButton = new JButton(buttonText, buttonIcon);
        this.addButton(this.invokeButton);
        this.resetButton = new JButton("Reset", DebuggerResources.ICON_REFRESH);
        this.addButton(this.resetButton);
        this.addCancelButton();
        this.invokeButton.addActionListener(this::invoke);
        this.resetButton.addActionListener(this::reset);
        this.resetRequested = false;
    }

    protected void cancelCallback() {
        this.arguments = null;
        this.resetRequested = false;
        this.close();
    }

    void invoke(ActionEvent evt) {
        this.arguments = TargetMethod.validateArguments(this.parameters, this.collectArguments(), (boolean)false);
        this.resetRequested = false;
        this.close();
    }

    void reset(ActionEvent evt) {
        this.arguments = new LinkedHashMap();
        this.resetRequested = true;
        this.close();
    }

    protected PropertyEditor getEditor(TargetMethod.ParameterDescription<?> param) {
        if (!param.choices.isEmpty()) {
            return new ChoicesPropertyEditor(param.choices);
        }
        Class type = param.type;
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            return editor;
        }
        Msg.warn((Object)this, (Object)("No editor for " + type + "? Trying String instead"));
        return PropertyEditorManager.findEditor(String.class);
    }

    void populateOptions() {
        this.pairPanel.removeAll();
        this.paramEditors.clear();
        for (TargetMethod.ParameterDescription<?> param : this.parameters.values()) {
            JLabel label = new JLabel(param.display);
            label.setToolTipText(param.description);
            this.pairPanel.add(label);
            PropertyEditor editor = this.getEditor(param);
            Object val = this.computeMemorizedValue(param);
            editor.setValue(val);
            editor.addPropertyChangeListener(this);
            this.pairPanel.add(MiscellaneousUtils.getEditorComponent(editor));
            this.paramEditors.put(param, (Object)editor);
        }
    }

    protected Map<String, ?> collectArguments() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (TargetMethod.ParameterDescription param : this.paramEditors.keySet()) {
            Object val = this.memorized.get((Object)NameTypePair.fromParameter(param));
            if (val == null) continue;
            map.put(param.name, val);
        }
        return map;
    }

    public Map<String, ?> getArguments() {
        return this.arguments;
    }

    public <T> void setMemorizedArgument(String name, Class<T> type, T value) {
        if (value == null) {
            return;
        }
        this.memorized.put(new NameTypePair(name, type), value);
    }

    public <T> T getMemorizedArgument(String name, Class<T> type) {
        return type.cast(this.memorized.get((Object)new NameTypePair(name, type)));
    }

    public void forgetMemorizedArguments() {
        this.memorized.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PropertyEditor editor = (PropertyEditor)evt.getSource();
        TargetMethod.ParameterDescription param = (TargetMethod.ParameterDescription)this.paramEditors.getKey((Object)editor);
        this.memorized.put(NameTypePair.fromParameter(param), editor.getValue());
    }

    public void writeConfigState(SaveState saveState) {
        SaveState subState = new SaveState();
        for (Map.Entry<NameTypePair, Object> ent : this.memorized.entrySet()) {
            NameTypePair ntp = ent.getKey();
            AutoConfigState.ConfigStateField.putState((SaveState)subState, ntp.getType().asSubclass(Object.class), (String)ntp.getName(), (Object)ent.getValue());
        }
        saveState.putXmlElement(KEY_MEMORIZED_ARGUMENTS, subState.saveToXml());
    }

    public void readConfigState(SaveState saveState) {
        Element element = saveState.getXmlElement(KEY_MEMORIZED_ARGUMENTS);
        if (element == null) {
            return;
        }
        SaveState subState = new SaveState(element);
        for (String name : subState.getNames()) {
            try {
                NameTypePair ntp = NameTypePair.fromString(name);
                this.memorized.put(ntp, AutoConfigState.ConfigStateField.getState((SaveState)subState, ntp.getType(), (String)ntp.getName()));
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Error restoring memorized parameter " + name), (Throwable)e);
            }
        }
    }

    public boolean isResetRequested() {
        return this.resetRequested;
    }

    public void setDescription(String htmlDescription) {
        if (htmlDescription == null) {
            this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder());
            this.descriptionLabel.setText("");
        } else {
            this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.descriptionLabel.setText(htmlDescription);
        }
    }

    static final class NameTypePair
    extends MutablePair<String, Class<?>> {
        public static NameTypePair fromParameter(TargetMethod.ParameterDescription<?> parameter) {
            return new NameTypePair(parameter.name, parameter.type);
        }

        public static NameTypePair fromString(String name) throws ClassNotFoundException {
            String[] parts = name.split(",", 2);
            if (parts.length != 2) {
                return new NameTypePair(parts[0], String.class);
            }
            return new NameTypePair(parts[0], Class.forName(parts[1]));
        }

        public NameTypePair(String name, Class<?> type) {
            super((Object)name, type);
        }

        public String toString() {
            return this.getName() + "," + this.getType().getName();
        }

        public Class<?> setValue(Class<?> value) {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return (String)this.getLeft();
        }

        public Class<?> getType() {
            return (Class)this.getRight();
        }
    }

    static class ChoicesPropertyEditor
    implements PropertyEditor {
        private final List<?> choices;
        private final String[] tags;
        private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
        private Object value;

        public ChoicesPropertyEditor(Set<?> choices) {
            this.choices = List.copyOf(choices);
            this.tags = (String[])choices.stream().map(Objects::toString).toArray(String[]::new);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(Object value) {
            List<PropertyChangeListener> listeners;
            Object oldValue;
            if (Objects.equals(value, this.value)) {
                return;
            }
            if (!this.choices.contains(value)) {
                throw new IllegalArgumentException("Unsupported value: " + value);
            }
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                oldValue = this.value;
                this.value = value;
                if (this.listeners.isEmpty()) {
                    return;
                }
                listeners = List.copyOf(this.listeners);
            }
            PropertyChangeEvent evt = new PropertyChangeEvent(this, null, oldValue, value);
            for (PropertyChangeListener l : listeners) {
                l.propertyChange(evt);
            }
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isPaintable() {
            return false;
        }

        @Override
        public void paintValue(Graphics gfx, Rectangle box) {
        }

        @Override
        public String getJavaInitializationString() {
            if (this.value == null) {
                return "null";
            }
            Object object = this.value;
            if (object instanceof String) {
                String str = (String)object;
                return "\"" + StringEscapeUtils.escapeJava((String)str) + "\"";
            }
            return Objects.toString(this.value);
        }

        @Override
        public String getAsText() {
            return Objects.toString(this.value);
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            int index = ArrayUtils.indexOf((Object[])this.tags, (Object)text);
            if (index < 0) {
                throw new IllegalArgumentException("Unsupported value: " + text);
            }
            this.setValue(this.choices.get(index));
        }

        @Override
        public String[] getTags() {
            return (String[])this.tags.clone();
        }

        @Override
        public Component getCustomEditor() {
            return null;
        }

        @Override
        public boolean supportsCustomEditor() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }
}

