/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.RangeCursorTableHeaderRenderer;
import ghidra.app.plugin.core.debug.gui.model.AbstractQueryTableModel;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.Plugin;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractQueryTablePanel<T, M extends AbstractQueryTableModel<T>>
extends JPanel {
    protected final M tableModel;
    protected final GhidraTable table;
    protected final GhidraTableFilterPanel<T> filterPanel;
    protected DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    protected boolean limitToSnap = false;
    protected boolean showHidden = false;
    private final ListenerSet<CellActivationListener> cellActivationListeners = new ListenerSet(CellActivationListener.class, true);

    public AbstractQueryTablePanel(Plugin plugin) {
        super(new BorderLayout());
        this.tableModel = this.createModel(plugin);
        this.table = new GhidraTable(this.tableModel);
        this.filterPanel = new GhidraTableFilterPanel((JTable)this.table, this.tableModel);
        this.add((Component)new JScrollPane((Component)this.table), "Center");
        this.add((Component)this.filterPanel, "South");
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    AbstractQueryTablePanel.this.fireCellActivated();
                }
            }
        });
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AbstractQueryTablePanel.this.fireCellActivated();
                    e.consume();
                }
            }
        });
    }

    protected abstract M createModel(Plugin var1);

    public void goToCoordinates(DebuggerCoordinates coords) {
        if (DebuggerCoordinates.equalsIgnoreRecorderAndView((DebuggerCoordinates)this.current, (DebuggerCoordinates)coords)) {
            return;
        }
        DebuggerCoordinates previous = this.current;
        this.current = coords;
        if (previous.getSnap() == this.current.getSnap() && previous.getTrace() == this.current.getTrace() && previous.getObject() == this.current.getObject()) {
            return;
        }
        ((AbstractQueryTableModel)this.tableModel).setDiffTrace(previous.getTrace());
        ((AbstractQueryTableModel)this.tableModel).setTrace(this.current.getTrace());
        ((AbstractQueryTableModel)this.tableModel).setDiffSnap(previous.getSnap());
        ((AbstractQueryTableModel)this.tableModel).setSnap(this.current.getSnap());
        ((AbstractQueryTableModel)this.tableModel).setCurrentObject(this.current.getObject());
        if (this.limitToSnap) {
            ((AbstractQueryTableModel)this.tableModel).setSpan(Lifespan.at((long)this.current.getSnap()));
        }
    }

    public void reload() {
        this.tableModel.reload();
    }

    public void setQuery(ModelQuery query) {
        ((AbstractQueryTableModel)this.tableModel).setQuery(query);
    }

    public ModelQuery getQuery() {
        return ((AbstractQueryTableModel)this.tableModel).getQuery();
    }

    public void setLimitToSnap(boolean limitToSnap) {
        if (this.limitToSnap == limitToSnap) {
            return;
        }
        this.limitToSnap = limitToSnap;
        ((AbstractQueryTableModel)this.tableModel).setSpan((Lifespan)(limitToSnap ? Lifespan.at((long)this.current.getSnap()) : Lifespan.ALL));
    }

    public boolean isLimitToSnap() {
        return this.limitToSnap;
    }

    public void setShowHidden(boolean showHidden) {
        if (this.showHidden == showHidden) {
            return;
        }
        this.showHidden = showHidden;
        ((AbstractQueryTableModel)this.tableModel).setShowHidden(showHidden);
    }

    public boolean isShowHidden() {
        return this.showHidden;
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this.table.getSelectionModel().addListSelectionListener(listener);
    }

    public void removeSelectionListener(ListSelectionListener listener) {
        this.table.getSelectionModel().removeListSelectionListener(listener);
    }

    public void addCellActivationListener(CellActivationListener listener) {
        this.cellActivationListeners.add((Object)listener);
    }

    public void removeCellActivationListener(CellActivationListener listener) {
        this.cellActivationListeners.remove((Object)listener);
    }

    public void addSeekListener(RangeCursorTableHeaderRenderer.SeekListener listener) {
        ((AbstractQueryTableModel)this.tableModel).addSeekListener(listener);
    }

    public void setSelectionMode(int selectionMode) {
        this.table.setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return this.table.getSelectionModel().getSelectionMode();
    }

    public void setSelectedItem(T item) {
        this.filterPanel.setSelectedItem(item);
    }

    public void setSelectedItems(Collection<T> items) {
        this.table.clearSelection();
        for (T t : items) {
            int modelRow = this.tableModel.getRowIndex(t);
            int viewRow = this.filterPanel.getViewRow(modelRow);
            this.table.getSelectionModel().addSelectionInterval(viewRow, viewRow);
        }
        this.table.scrollToSelectedRow();
    }

    public boolean trySelect(TraceObject object) {
        Object t = ((AbstractQueryTableModel)this.tableModel).findTraceObject(object);
        if (t == null) {
            return false;
        }
        this.setSelectedItem(t);
        return true;
    }

    public void trySelect(Collection<TraceObject> objects) {
        List ts = objects.stream().map(arg_0 -> this.tableModel.findTraceObject(arg_0)).collect(Collectors.toList());
        this.setSelectedItems(ts);
    }

    public List<T> getSelectedItems() {
        return this.filterPanel.getSelectedItems();
    }

    public T getSelectedItem() {
        return (T)this.filterPanel.getSelectedItem();
    }

    public List<T> getAllItems() {
        return List.copyOf(this.tableModel.getModelData());
    }

    public <V> Map.Entry<Integer, DynamicTableColumn<T, V, Trace>> getColumnByNameAndType(String name, Class<V> type) {
        int count = this.tableModel.getColumnCount();
        for (int i = 0; i < count; ++i) {
            DynamicTableColumn column = this.tableModel.getColumn(i);
            if (!name.equals(column.getColumnName()) || column.getColumnClass() != type) continue;
            return Map.entry(this.table.convertColumnIndexToView(i), column);
        }
        return null;
    }

    public void setDiffColor(Color diffColor) {
        ((AbstractQueryTableModel)this.tableModel).setDiffColor(diffColor);
    }

    public void setDiffColorSel(Color diffColorSel) {
        ((AbstractQueryTableModel)this.tableModel).setDiffColorSel(diffColorSel);
    }

    protected void fireCellActivated() {
        ((CellActivationListener)this.cellActivationListeners.invoke()).cellActivated((JTable)this.table);
    }

    public static interface CellActivationListener {
        public void cellActivated(JTable var1);
    }
}

