/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.action.DebuggerGoToTrait;
import ghidra.app.plugin.core.debug.gui.breakpoint.AbstractDebuggerSleighInputDialog;
import ghidra.app.plugin.core.debug.gui.listing.DebuggerListingPlugin;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.async.AsyncUtils;
import ghidra.debug.api.action.GoToInput;
import ghidra.framework.plugintool.util.PluginUtils;
import ghidra.pcode.exec.SleighUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.util.HelpLocation;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class DebuggerGoToDialog
extends AbstractDebuggerSleighInputDialog {
    private static final String TEXT = "<html>\n<body width=\"400px\">\n<p>\nEnter an address or Sleigh expression. Press <b>F1</b> for help and examples.\n</p>\n</body>\n</html>\n";
    private final DebuggerGoToTrait trait;
    private final DefaultComboBoxModel<String> modelSpaces;
    final JComboBox<String> comboSpaces;

    public DebuggerGoToDialog(DebuggerGoToTrait trait) {
        super("Go To", TEXT);
        this.setHelpLocation(new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerListingPlugin.class), "go_to"));
        this.trait = trait;
        this.modelSpaces = new DefaultComboBoxModel();
        this.comboSpaces = new JComboBox<String>(this.modelSpaces);
        Box hbox = Box.createHorizontalBox();
        hbox.add(this.comboSpaces);
        hbox.add(new JLabel(":"));
        this.panel.add((Component)hbox, "West");
        this.setFocusComponent(this.textInput);
        this.textInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerGoToDialog.this.okCallback();
                    e.consume();
                }
            }
        });
    }

    protected void populateSpaces(SleighLanguage language) {
        String curSpace = (String)this.comboSpaces.getSelectedItem();
        this.modelSpaces.removeAllElements();
        AddressFactory factory = language.getAddressFactory();
        List names = Stream.of(factory.getAddressSpaces()).filter(AddressSpace::isMemorySpace).map(AddressSpace::getName).collect(Collectors.toList());
        this.modelSpaces.addAll(names);
        if (names.contains(curSpace)) {
            this.comboSpaces.setSelectedItem(curSpace);
        } else {
            this.comboSpaces.setSelectedItem(factory.getDefaultAddressSpace().getName());
        }
    }

    @Override
    protected void validate() {
        TracePlatform platform = this.trait.current.getPlatform();
        if (platform == null) {
            throw new AssertionError((Object)"No current trace platform");
        }
        Address address = platform.getAddressFactory().getAddress(this.getInput());
        if (address != null) {
            return;
        }
        SleighUtils.parseSleighExpression((String)this.getInput());
    }

    @Override
    public void okCallback() {
        CompletableFuture<Object> future;
        this.validateAndMarkup();
        if (!this.isValid) {
            return;
        }
        try {
            future = this.trait.goTo((String)this.comboSpaces.getSelectedItem(), this.getInput());
        }
        catch (Throwable t) {
            future = CompletableFuture.failedFuture(t);
        }
        ((CompletableFuture)future.thenAccept(result -> {
            if (!result.success().booleanValue()) {
                this.setStatusText("<html>Address <code>" + result.address() + "</code> not in trace", MessageType.ERROR, true);
            } else {
                this.close();
            }
        })).exceptionally(ex -> {
            ex = AsyncUtils.unwrapThrowable((Throwable)ex);
            Msg.error((Object)((Object)this), (Object)ex.getMessage(), (Throwable)ex);
            this.setStatusText(ex.getMessage(), MessageType.ERROR, true);
            return null;
        });
    }

    @Override
    public void cancelCallback() {
        this.close();
    }

    public void show(SleighLanguage language, GoToInput defaultInput) {
        this.populateSpaces(language);
        if (language.getAddressFactory().getAddressSpace(defaultInput.space()) != null) {
            this.comboSpaces.setSelectedItem(defaultInput.space());
        }
        this.prompt(this.trait.tool, defaultInput.offset());
    }

    public void setOffset(String offset) {
        this.textInput.setText(offset);
    }
}

