/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.action.AutoMapSpec;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.ProgramManager;
import ghidra.debug.api.modules.MapProposal;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class BySectionAutoMapSpec
implements AutoMapSpec {
    public static final String CONFIG_NAME = "1_MAP_BY_SECTION";

    @Override
    public String getConfigName() {
        return CONFIG_NAME;
    }

    @Override
    public String getMenuName() {
        return "Auto-Map by Section";
    }

    @Override
    public Collection<TraceChangeType<?, ?>> getChangeTypes() {
        return List.of(Trace.TraceSectionChangeType.ADDED);
    }

    @Override
    public void performMapping(DebuggerStaticMappingService mappingService, Trace trace, ProgramManager programManager, TaskMonitor monitor) throws CancelledException {
        List<Program> programs = Arrays.asList(programManager.getAllOpenPrograms());
        Map maps = mappingService.proposeSectionMaps(trace.getModuleManager().getAllModules(), programs);
        Collection entries = MapProposal.flatten(maps.values());
        entries = MapProposal.removeOverlapping((Collection)entries);
        mappingService.addSectionMappings(entries, monitor, false);
    }
}

