/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.program.util.LanguageTranslator;
import ghidra.program.util.TemporaryCompilerSpec;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

class FactoryLanguageTranslator
implements LanguageTranslator {
    private final LanguageTranslator t1;
    private final LanguageTranslator t2;

    FactoryLanguageTranslator(LanguageTranslator t1, LanguageTranslator t2) {
        this.t1 = t1;
        this.t2 = t2;
    }

    @Override
    public Language getNewLanguage() {
        return this.t2.getNewLanguage();
    }

    @Override
    public Language getOldLanguage() {
        return this.t1.getOldLanguage();
    }

    @Override
    public Register getOldRegister(Address oldAddr, int size) {
        return this.t1.getOldRegister(oldAddr, size);
    }

    @Override
    public Register getOldRegisterContaining(Address oldAddr) {
        return this.t1.getOldRegisterContaining(oldAddr);
    }

    @Override
    public Register getOldContextRegister() {
        return this.t1.getOldContextRegister();
    }

    @Override
    public Register getNewContextRegister() {
        return this.t2.getNewContextRegister();
    }

    @Override
    public Register getNewRegister(Register oldReg) {
        Register reg = this.t1.getNewRegister(oldReg);
        if (reg != null) {
            return this.t2.getNewRegister(reg);
        }
        return null;
    }

    @Override
    public AddressSpace getNewAddressSpace(String oldSpaceName) {
        AddressSpace space = this.t1.getNewAddressSpace(oldSpaceName);
        if (space != null) {
            return this.t2.getNewAddressSpace(space.getName());
        }
        return null;
    }

    @Override
    public LanguageID getOldLanguageID() {
        return this.t1.getOldLanguageID();
    }

    @Override
    public int getOldVersion() {
        return this.t1.getOldVersion();
    }

    @Override
    public LanguageID getNewLanguageID() {
        return this.t2.getNewLanguageID();
    }

    @Override
    public int getNewVersion() {
        return this.t2.getNewVersion();
    }

    @Override
    public boolean isValueTranslationRequired(Register oldReg) {
        Register reg = this.t1.getNewRegister(oldReg);
        if (reg == null) {
            return false;
        }
        return this.t2.isValueTranslationRequired(reg) || this.t1.isValueTranslationRequired(oldReg);
    }

    @Override
    public RegisterValue getNewRegisterValue(RegisterValue oldRegValue) {
        RegisterValue newVal = this.t1.getNewRegisterValue(oldRegValue);
        if (newVal == null) {
            Register reg = this.t1.getNewRegister(oldRegValue.getRegister());
            if (reg == null) {
                return null;
            }
            newVal = new RegisterValue(reg);
        }
        return this.t2.getNewRegisterValue(newVal);
    }

    @Override
    public boolean isValid() {
        return this.t1.isValid() && this.t2.isValid();
    }

    @Override
    public CompilerSpecID getNewCompilerSpecID(CompilerSpecID oldCompilerSpecID) {
        CompilerSpecID specId = this.t1.getNewCompilerSpecID(oldCompilerSpecID);
        return this.t2.getNewCompilerSpecID(specId);
    }

    @Override
    public CompilerSpec getOldCompilerSpec(CompilerSpecID oldCompilerSpecID) throws CompilerSpecNotFoundException {
        return new TemporaryCompilerSpec(this, oldCompilerSpecID);
    }

    @Override
    public void fixupInstructions(Program program, Language oldLanguage, TaskMonitor monitor) throws Exception, CancelledException {
        this.t2.fixupInstructions(program, oldLanguage, monitor);
    }

    public String toString() {
        return this.t1.toString() + "; " + System.getProperty("line.separator") + this.t2.toString();
    }
}

