/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Program;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class DefinedDataIterator
implements DataIterator {
    private Predicate<DataType> dataTypePredicate;
    private Predicate<Data> dataInstancePredicate;
    private Deque<DataIterator> itStack = new ArrayDeque<DataIterator>();
    private Data currentDataResult;

    public static DefinedDataIterator byDataType(Program program, Predicate<DataType> dataTypePredicate) {
        return new DefinedDataIterator(program, null, dataTypePredicate, null);
    }

    public static DefinedDataIterator byDataType(Program program, AddressSetView addresses, Predicate<DataType> dataTypePredicate) {
        return new DefinedDataIterator(program, addresses, dataTypePredicate, null);
    }

    public static DefinedDataIterator byDataInstance(Program program, Predicate<Data> dataInstancePredicate) {
        return new DefinedDataIterator(program, null, null, dataInstancePredicate);
    }

    public static DefinedDataIterator definedStrings(Program program) {
        return new DefinedDataIterator(program, null, dataType -> StringDataInstance.isStringDataType(dataType), data -> StringDataInstance.isString(data));
    }

    public static DefinedDataIterator definedStrings(Program program, AddressSetView addrs) {
        return new DefinedDataIterator(program, addrs, dataType -> StringDataInstance.isStringDataType(dataType), data -> StringDataInstance.isString(data));
    }

    public static DefinedDataIterator definedStrings(Data singleDataInstance) {
        return new DefinedDataIterator(singleDataInstance, dataType -> StringDataInstance.isStringDataType(dataType), data -> StringDataInstance.isString(data));
    }

    private DefinedDataIterator(Program program, AddressSetView addrs, Predicate<DataType> dataTypePredicate, Predicate<Data> dataInstancePredicate) {
        this.dataTypePredicate = dataTypePredicate;
        this.dataInstancePredicate = dataInstancePredicate;
        this.itStack.addLast(program.getListing().getDefinedData(addrs == null ? program.getMemory().getAllInitializedAddressSet() : addrs, true));
    }

    private DefinedDataIterator(Data singleDataInstance, Predicate<DataType> dataTypePredicate, Predicate<Data> dataInstancePredicate) {
        this.dataTypePredicate = dataTypePredicate;
        this.dataInstancePredicate = dataInstancePredicate;
        this.itStack.addLast(DataIterator.of(singleDataInstance));
    }

    @Override
    public boolean hasNext() {
        if (this.currentDataResult == null) {
            this.findNext();
        }
        return this.currentDataResult != null;
    }

    @Override
    public Data next() {
        if (this.currentDataResult == null) {
            throw new NoSuchElementException();
        }
        Data result = this.currentDataResult;
        this.currentDataResult = null;
        return result;
    }

    private DataIterator currentIt() {
        DataIterator it = null;
        while ((it = this.itStack.peekLast()) != null && !it.hasNext()) {
            this.itStack.removeLast();
        }
        return it;
    }

    private void findNext() {
        DataIterator it = null;
        while ((it = this.currentIt()) != null) {
            Data data = it.next();
            DataType dt = data.getBaseDataType();
            if (this.matchesDataTypePredicate(dt) && this.matchesDataInstancePredicate(data)) {
                this.currentDataResult = data;
                return;
            }
            if (this.dataTypePredicate == null || !this.isContainerDT(dt) || !this.recursiveMatchesDataTypePredicate(dt)) continue;
            this.itStack.addLast(new DataComponentIterator(data));
        }
    }

    private boolean isContainerDT(DataType dt) {
        return dt instanceof Array || dt instanceof Composite;
    }

    private boolean recursiveMatchesDataTypePredicate(DataType dt) {
        if (this.matchesDataTypePredicate(dt)) {
            return true;
        }
        if (dt instanceof Array) {
            Array arrayDT = (Array)dt;
            DataType elementDT = arrayDT.getDataType();
            return this.recursiveMatchesDataTypePredicate(elementDT);
        }
        if (dt instanceof Structure) {
            Structure comp = (Structure)dt;
            for (DataTypeComponent dtc : comp.getDefinedComponents()) {
                if (!this.recursiveMatchesDataTypePredicate(dtc.getDataType())) continue;
                return true;
            }
            return false;
        }
        if (dt instanceof Composite) {
            Composite comp = (Composite)dt;
            for (DataTypeComponent dtc : comp.getComponents()) {
                if (!this.recursiveMatchesDataTypePredicate(dtc.getDataType())) continue;
                return true;
            }
            return false;
        }
        if (dt instanceof TypeDef) {
            TypeDef tdDT = (TypeDef)dt;
            return this.recursiveMatchesDataTypePredicate(tdDT.getBaseDataType());
        }
        return false;
    }

    private boolean matchesDataTypePredicate(DataType dt) {
        return this.dataTypePredicate == null || this.dataTypePredicate.test(dt);
    }

    private boolean matchesDataInstancePredicate(Data data) {
        return this.dataInstancePredicate == null || this.dataInstancePredicate.test(data);
    }

    private static class DataComponentIterator
    implements DataIterator {
        private Data data;
        private int currentIndex;
        private int elementCount;

        public DataComponentIterator(Data data) {
            this.data = data;
            this.elementCount = data.getNumComponents();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.elementCount;
        }

        @Override
        public Data next() {
            Data result = this.data.getComponent(this.currentIndex);
            ++this.currentIndex;
            return result;
        }
    }
}

