/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.xml.SpecXmlUtils;
import java.io.IOException;
import java.io.OutputStream;

public class XmlEncode
implements Encoder {
    private StringBuilder buffer = new StringBuilder();
    private boolean elementTagIsOpen = false;

    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public void clear() {
        this.buffer = new StringBuilder();
        this.elementTagIsOpen = false;
    }

    @Override
    public void openElement(ElementId elemId) throws IOException {
        if (this.elementTagIsOpen) {
            this.buffer.append('>');
        } else {
            this.elementTagIsOpen = true;
        }
        this.buffer.append('<');
        this.buffer.append(elemId.name());
    }

    @Override
    public void closeElement(ElementId elemId) throws IOException {
        if (this.elementTagIsOpen) {
            this.buffer.append("/>");
            this.elementTagIsOpen = false;
        } else {
            this.buffer.append("</");
            this.buffer.append(elemId.name());
            this.buffer.append('>');
        }
    }

    @Override
    public void writeBool(AttributeId attribId, boolean val) throws IOException {
        if (attribId == AttributeId.ATTRIB_CONTENT) {
            if (this.elementTagIsOpen) {
                this.buffer.append('>');
                this.elementTagIsOpen = false;
            }
            this.buffer.append(val ? "true" : "false");
            return;
        }
        this.buffer.append(' ');
        this.buffer.append(attribId.name());
        this.buffer.append("=\"");
        this.buffer.append(val ? "true" : "false");
        this.buffer.append("\"");
    }

    @Override
    public void writeSignedInteger(AttributeId attribId, long val) throws IOException {
        if (attribId == AttributeId.ATTRIB_CONTENT) {
            if (this.elementTagIsOpen) {
                this.buffer.append('>');
                this.elementTagIsOpen = false;
            }
            this.buffer.append(Long.toString(val, 10));
            return;
        }
        this.buffer.append(' ');
        this.buffer.append(attribId.name());
        this.buffer.append("=\"");
        this.buffer.append(Long.toString(val, 10));
        this.buffer.append("\"");
    }

    @Override
    public void writeUnsignedInteger(AttributeId attribId, long val) throws IOException {
        if (attribId == AttributeId.ATTRIB_CONTENT) {
            if (this.elementTagIsOpen) {
                this.buffer.append('>');
                this.elementTagIsOpen = false;
            }
            this.buffer.append("0x");
            this.buffer.append(Long.toHexString(val));
            return;
        }
        this.buffer.append(' ');
        this.buffer.append(attribId.name());
        this.buffer.append("=\"0x");
        this.buffer.append(Long.toHexString(val));
        this.buffer.append("\"");
    }

    @Override
    public void writeString(AttributeId attribId, String val) throws IOException {
        if (attribId == AttributeId.ATTRIB_CONTENT) {
            if (this.elementTagIsOpen) {
                this.buffer.append('>');
                this.elementTagIsOpen = false;
            }
            SpecXmlUtils.xmlEscape((StringBuilder)this.buffer, (String)val);
            return;
        }
        this.buffer.append(' ');
        this.buffer.append(attribId.name());
        this.buffer.append("=\"");
        SpecXmlUtils.xmlEscape((StringBuilder)this.buffer, (String)val);
        this.buffer.append("\"");
    }

    @Override
    public void writeStringIndexed(AttributeId attribId, int index, String val) throws IOException {
        this.buffer.append(' ');
        this.buffer.append(attribId.name());
        this.buffer.append(index + 1);
        this.buffer.append("=\"");
        SpecXmlUtils.xmlEscape((StringBuilder)this.buffer, (String)val);
        this.buffer.append("\"");
    }

    @Override
    public void writeSpace(AttributeId attribId, AddressSpace spc) throws IOException {
        String spcName = spc.getType() == 11 ? "join" : spc.getName();
        if (attribId == AttributeId.ATTRIB_CONTENT) {
            if (this.elementTagIsOpen) {
                this.buffer.append('>');
                this.elementTagIsOpen = false;
            }
            SpecXmlUtils.xmlEscape((StringBuilder)this.buffer, (String)spcName);
            return;
        }
        this.buffer.append(' ');
        this.buffer.append(attribId.name());
        this.buffer.append("=\"");
        SpecXmlUtils.xmlEscape((StringBuilder)this.buffer, (String)spcName);
        this.buffer.append("\"");
    }

    @Override
    public void writeTo(OutputStream stream) throws IOException {
        byte[] res = this.buffer.toString().getBytes();
        stream.write(res);
    }

    @Override
    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }
}

