/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.mem;

import ghidra.program.database.mem.ByteMappingScheme;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.mem.MemoryBlock;
import java.util.Optional;

public interface MemoryBlockSourceInfo {
    public long getLength();

    public Address getMinAddress();

    public Address getMaxAddress();

    public String getDescription();

    public Optional<FileBytes> getFileBytes();

    public long getFileBytesOffset();

    public long getFileBytesOffset(Address var1);

    public Optional<AddressRange> getMappedRange();

    public Optional<ByteMappingScheme> getByteMappingScheme();

    public MemoryBlock getMemoryBlock();

    public boolean contains(Address var1);

    default public boolean containsFileOffset(long fileOffset) {
        long startOffset = this.getFileBytesOffset();
        if (startOffset < 0L || fileOffset < 0L) {
            return false;
        }
        long endOffset = startOffset + (this.getLength() - 1L);
        return fileOffset >= startOffset && fileOffset <= endOffset;
    }

    default public Address locateAddressForFileOffset(long fileOffset) {
        long startOffset = this.getFileBytesOffset();
        if (!this.containsFileOffset(fileOffset)) {
            return null;
        }
        long offset = fileOffset - startOffset;
        if (offset >= this.getLength()) {
            return null;
        }
        return this.getMinAddress().add(offset);
    }
}

