/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.protorules.DatatypeFilter;
import ghidra.program.model.lang.protorules.SizeRestrictedFilter;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public class MetaTypeFilter
extends SizeRestrictedFilter {
    protected int metaType;

    public MetaTypeFilter(int meta) {
        this.metaType = meta;
    }

    public MetaTypeFilter(int meta, int min, int max) {
        super(min, max);
        this.metaType = meta;
    }

    @Override
    public boolean isEquivalent(DatatypeFilter op) {
        if (!super.isEquivalent(op)) {
            return false;
        }
        if (this.getClass() != op.getClass()) {
            return false;
        }
        MetaTypeFilter otherFilter = (MetaTypeFilter)op;
        return this.metaType == otherFilter.metaType;
    }

    @Override
    public DatatypeFilter clone() {
        return new MetaTypeFilter(this.metaType, this.minSize, this.maxSize);
    }

    @Override
    public boolean filter(DataType dt) {
        if (PcodeDataTypeManager.getMetatype(dt) != this.metaType) {
            return false;
        }
        return this.filterOnSize(dt);
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_DATATYPE);
        String meta = PcodeDataTypeManager.getMetatypeString(this.metaType);
        encoder.writeString(AttributeId.ATTRIB_NAME, meta);
        this.encodeAttributes(encoder);
        encoder.closeElement(ElementId.ELEM_DATATYPE);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_DATATYPE.name()});
        this.metaType = PcodeDataTypeManager.getMetatype(elem.getAttribute(AttributeId.ATTRIB_NAME.name()));
        this.restoreAttributesXml(elem);
        parser.end(elem);
    }
}

