/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.ArrayStringable;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeEncodeException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeWithCharset;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.WideCharDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.StringUtilities;

public class WideChar16DataType
extends BuiltIn
implements ArrayStringable,
DataTypeWithCharset {
    public static final WideChar16DataType dataType = new WideChar16DataType();

    public WideChar16DataType() {
        this(null);
    }

    public WideChar16DataType(DataTypeManager dtm) {
        super(null, "wchar16", dtm);
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public String getDescription() {
        return "Wide-Character (16-bit/UTF16)";
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new WideChar16DataType(dtm);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "wchar16";
    }

    @Override
    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return WideCharDataType.DEFAULT_WIDE_CHAR_SETTINGS;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return new StringDataInstance(this, settings, buf, this.getLength()).getCharRepresentation();
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        try {
            return Character.valueOf((char)buf.getUnsignedShort(0));
        }
        catch (MemoryAccessException memoryAccessException) {
            return null;
        }
    }

    @Override
    public boolean isEncodable() {
        return true;
    }

    @Override
    public byte[] encodeValue(Object value, MemBuffer buf, Settings settings, int length) throws DataTypeEncodeException {
        return this.encodeCharacterValue(value, buf, settings);
    }

    @Override
    public byte[] encodeRepresentation(String repr, MemBuffer buf, Settings settings, int length) throws DataTypeEncodeException {
        return this.encodeCharacterRepresentation(repr, buf, settings);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Character.class;
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int length, DataTypeDisplayOptions options) {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append("WCHAR16_");
        try {
            int val = buf.getUnsignedShort(0);
            if (StringUtilities.isAsciiChar((int)val)) {
                strBuf.append((char)val);
            } else {
                strBuf.append(Integer.toHexString(val));
                strBuf.append('h');
            }
        }
        catch (MemoryAccessException e) {
            strBuf.append("??");
        }
        return strBuf.toString();
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "WCHAR16";
    }

    @Override
    public boolean hasStringValue(Settings settings) {
        return true;
    }

    @Override
    public String getArrayDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return new StringDataInstance(this, settings, buf, len, true).getLabel("u_", "UNI", "UNICODE", options);
    }

    @Override
    public String getArrayDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutOffset) {
        return new StringDataInstance(this, settings, buf, len, true).getOffcutLabelString("u_", "UNI", "UNICODE", options, offcutOffset);
    }

    @Override
    public String getCharsetName(Settings settings) {
        return "UTF-16";
    }
}

