/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import java.util.Comparator;
import java.util.List;

public interface Structure
extends Composite {
    @Override
    public Structure clone(DataTypeManager var1);

    @Override
    public DataTypeComponent getComponent(int var1) throws IndexOutOfBoundsException;

    public DataTypeComponent getDefinedComponentAtOrAfterOffset(int var1);

    public DataTypeComponent getComponentContaining(int var1);

    default public DataTypeComponent getComponentAt(int offset) {
        DataTypeComponent dtc = this.getComponentContaining(offset);
        while (dtc != null && dtc.isBitFieldComponent() && dtc.getOffset() < offset && dtc.getOrdinal() < this.getNumComponents() - 1) {
            dtc = this.getComponent(dtc.getOrdinal() + 1);
        }
        if (dtc != null && dtc.getOffset() == offset) {
            return dtc;
        }
        return null;
    }

    public List<DataTypeComponent> getComponentsContaining(int var1);

    public DataTypeComponent getDataTypeAt(int var1);

    public DataTypeComponent insertBitField(int var1, int var2, int var3, DataType var4, int var5, String var6, String var7) throws InvalidDataTypeException, IndexOutOfBoundsException;

    public DataTypeComponent insertBitFieldAt(int var1, int var2, int var3, DataType var4, int var5, String var6, String var7) throws InvalidDataTypeException;

    public DataTypeComponent insertAtOffset(int var1, DataType var2, int var3) throws IllegalArgumentException;

    public DataTypeComponent insertAtOffset(int var1, DataType var2, int var3, String var4, String var5) throws IllegalArgumentException;

    public void deleteAtOffset(int var1) throws IllegalArgumentException;

    public void deleteAll();

    public void clearAtOffset(int var1);

    public void clearComponent(int var1) throws IndexOutOfBoundsException;

    public DataTypeComponent replace(int var1, DataType var2, int var3) throws IndexOutOfBoundsException, IllegalArgumentException;

    public DataTypeComponent replace(int var1, DataType var2, int var3, String var4, String var5) throws IndexOutOfBoundsException, IllegalArgumentException;

    public DataTypeComponent replaceAtOffset(int var1, DataType var2, int var3, String var4, String var5) throws IllegalArgumentException;

    public void growStructure(int var1);

    public static class BitOffsetComparator
    implements Comparator<Object> {
        public static final Comparator<Object> INSTANCE_LE = new BitOffsetComparator(false);
        public static final Comparator<Object> INSTANCE_BE = new BitOffsetComparator(true);
        private boolean bigEndian;

        public BitOffsetComparator(boolean bigEndian) {
            this.bigEndian = bigEndian;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int endBit;
            int startBit;
            if (o1 instanceof Integer) {
                return -this.compare(o2, o1);
            }
            DataTypeComponent dtc = (DataTypeComponent)o1;
            int bitOffset = (Integer)o2;
            if (dtc.isBitFieldComponent()) {
                BitFieldDataType bitfield = (BitFieldDataType)dtc.getDataType();
                startBit = BitOffsetComparator.getNormalizedBitfieldOffset(dtc.getOffset(), dtc.getLength(), bitfield.getBitSize(), bitfield.getBitOffset(), this.bigEndian);
                endBit = startBit + bitfield.getBitSize() - 1;
            } else {
                startBit = 8 * dtc.getOffset();
                endBit = startBit + 8 * dtc.getLength() - 1;
            }
            if (bitOffset < startBit) {
                return 1;
            }
            if (bitOffset > endBit) {
                return -1;
            }
            return 0;
        }

        public static int getNormalizedBitfieldOffset(int byteOffset, int storageSize, int effectiveBitSize, int bitOffset, boolean bigEndian) {
            int offset = 8 * byteOffset;
            if (effectiveBitSize == 0) {
                effectiveBitSize = 1;
                bitOffset = bigEndian ? (bitOffset |= 7) : (bitOffset &= 0xFFFFFFF8);
            }
            offset = bigEndian ? (offset += 8 * storageSize - effectiveBitSize - bitOffset) : (offset += bitOffset);
            return offset;
        }
    }
}

